/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.util.Stack;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class PluginListHandler
extends DefaultHandler {
    private final String path;
    private final PluginList pluginList;
    private PluginList.PluginSet pluginSet;
    private final StringBuilder pluginSetEntry;
    private PluginList.Plugin plugin;
    private String jar;
    private StringBuilder author;
    private PluginList.Branch branch;
    private boolean obsolete;
    private String version;
    private String date;
    private StringBuilder download;
    private int downloadSize;
    private StringBuilder downloadSource;
    private int downloadSourceSize;
    private int size;
    private String depWhat;
    private String depFrom;
    private String depTo;
    private String depPlugin;
    private String name;
    private StringBuilder description;
    private final Stack<String> stateStack = new Stack();

    PluginListHandler(PluginList pluginList, String path) {
        this.pluginList = pluginList;
        this.path = path;
        this.author = new StringBuilder();
        this.description = new StringBuilder();
        this.pluginSetEntry = new StringBuilder();
        this.download = new StringBuilder();
        this.downloadSource = new StringBuilder();
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return XMLUtilities.findEntity(systemId, "plugins.dtd", this.getClass());
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        if (aname == "NAME") {
            this.name = value;
        } else if (aname == "JAR") {
            this.jar = value;
        } else if (aname == "VERSION") {
            this.version = value;
        } else if (aname == "DATE") {
            this.date = value;
        } else if (aname == "OBSOLETE") {
            this.obsolete = "TRUE".equals(value);
        } else if (aname == "WHAT") {
            this.depWhat = value;
        } else if (aname == "FROM") {
            this.depFrom = value;
        } else if (aname == "TO") {
            this.depTo = value;
        } else if (aname == "PLUGIN") {
            this.depPlugin = value;
        } else if (aname == "SIZE") {
            this.size = Integer.parseInt(value);
            if (this.size == 0) {
                Log.log(7, this, "SIZE = 0");
            }
        }
    }

    public void characters(char[] c, int off, int len) {
        String tag = this.peekElement();
        if (tag.equals("DESCRIPTION")) {
            this.description.append(c, off, len);
        } else if (tag.equals("PLUGIN_SET_ENTRY")) {
            this.pluginSetEntry.append(c, off, len);
        } else if (tag.equals("AUTHOR")) {
            if (this.author.length() != 0) {
                this.author.append(", ");
            }
            this.author.append(c, off, len);
        } else if (tag.equals("DOWNLOAD")) {
            this.download.append(c, off, len);
        } else if (tag.equals("DOWNLOAD_SOURCE")) {
            this.downloadSource.append(c, off, len);
        }
    }

    public void startElement(String uri, String localName, String tag, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String aName = attrs.getQName(i);
            String aValue = attrs.getValue(i);
            this.attribute(aName, aValue, true);
        }
        if ((tag = this.pushElement(tag)).equals("PLUGIN_SET")) {
            this.description.setLength(0);
            this.pluginSet = new PluginList.PluginSet();
            this.pluginSet.name = this.name;
        } else if (tag.equals("PLUGIN")) {
            this.description.setLength(0);
            this.author.setLength(0);
            this.branch = null;
            this.plugin = new PluginList.Plugin();
        } else if (tag.equals("BRANCH")) {
            this.download.setLength(0);
            this.branch = new PluginList.Branch();
        } else if (tag.equals("DOWNLOAD")) {
            this.downloadSize = this.size;
        } else if (tag.equals("DOWNLOAD_SOURCE")) {
            this.downloadSourceSize = this.size;
        }
    }

    public void endElement(String uri, String localName, String tag) {
        this.popElement();
        if (tag.equals("PLUGIN_SET")) {
            this.pluginList.addPluginSet(this.pluginSet);
            this.pluginSet = null;
            this.pluginSetEntry.setLength(0);
        } else if (tag.equals("PLUGIN_SET_ENTRY")) {
            this.pluginSet.plugins.add(this.pluginSetEntry.toString());
            this.pluginSetEntry.setLength(0);
        } else if (tag.equals("PLUGIN")) {
            this.plugin.jar = this.jar;
            this.plugin.name = this.name;
            this.plugin.author = this.author.toString();
            this.plugin.description = this.description.toString();
            this.pluginList.addPlugin(this.plugin);
            this.jar = null;
            this.name = null;
            this.author.setLength(0);
            this.description.setLength(0);
        } else if (tag.equals("BRANCH")) {
            this.branch.version = this.version;
            this.branch.date = this.date;
            this.branch.download = this.download.toString();
            this.branch.downloadSize = this.downloadSize;
            this.branch.downloadSource = this.downloadSource.toString();
            this.branch.downloadSourceSize = this.downloadSourceSize;
            this.branch.obsolete = this.obsolete;
            this.plugin.branches.add(this.branch);
            this.version = null;
            this.download.setLength(0);
            this.downloadSource.setLength(0);
            this.obsolete = false;
        } else if (tag.equals("DEPEND")) {
            PluginList.Dependency dep = new PluginList.Dependency(this.depWhat, this.depFrom, this.depTo, this.depPlugin);
            this.branch.deps.add(dep);
            this.depWhat = null;
            this.depFrom = null;
            this.depTo = null;
            this.depPlugin = null;
        }
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    public void endDocument() {
        this.pluginList.finished();
    }

    private String pushElement(String name) {
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

