/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.StyleEditor;
import org.gjt.sp.jedit.options.StyleTableModel;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

public class SyntaxHiliteOptionPane
extends AbstractOptionPane {
    public static final EmptyBorder noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private StyleTableModel styleModel;
    private JTable styleTable;

    public SyntaxHiliteOptionPane() {
        super("syntax");
    }

    protected void _init() {
        this.setLayout(new BorderLayout(6, 6));
        this.add("Center", this.createStyleTableScroller());
    }

    protected void _save() {
        this.styleModel.save();
    }

    private JScrollPane createStyleTableScroller() {
        this.styleModel = SyntaxHiliteOptionPane.createStyleTableModel();
        this.styleTable = new JTable(this.styleModel);
        this.styleTable.setRowSelectionAllowed(false);
        this.styleTable.setColumnSelectionAllowed(false);
        this.styleTable.setCellSelectionEnabled(false);
        this.styleTable.getTableHeader().setReorderingAllowed(false);
        this.styleTable.addMouseListener(new MouseHandler());
        TableColumnModel tcm = this.styleTable.getColumnModel();
        TableColumn styleColumn = tcm.getColumn(1);
        styleColumn.setCellRenderer(new StyleTableModel.StyleRenderer());
        Dimension d = this.styleTable.getPreferredSize();
        d.height = Math.min(d.height, 100);
        JScrollPane scroller = new JScrollPane(this.styleTable);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private static StyleTableModel createStyleTableModel() {
        return new StyleTableModel();
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            SyntaxStyle style;
            int row = SyntaxHiliteOptionPane.this.styleTable.rowAtPoint(evt.getPoint());
            if (row == -1) {
                return;
            }
            SyntaxStyle current = (SyntaxStyle)SyntaxHiliteOptionPane.this.styleModel.getValueAt(row, 1);
            String token = (String)SyntaxHiliteOptionPane.this.styleModel.getValueAt(row, 0);
            JDialog dialog = GUIUtilities.getParentDialog(SyntaxHiliteOptionPane.this);
            if (dialog != null) {
                style = new StyleEditor(dialog, current, token).getStyle();
            } else {
                View view = GUIUtilities.getView(SyntaxHiliteOptionPane.this);
                style = new StyleEditor(view, current, token).getStyle();
            }
            if (style != null) {
                SyntaxHiliteOptionPane.this.styleModel.setValueAt(style, row, 1);
            }
        }
    }
}

