/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.SyntaxHiliteOptionPane;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.StandardUtilities;

class StyleTableModel
extends AbstractTableModel {
    private List<StyleChoice> styleChoices = new Vector<StyleChoice>(23);

    StyleTableModel() {
        for (int i = 1; i < 19; ++i) {
            String tokenName = Token.tokenToString((byte)i);
            this.addStyleChoice(tokenName, "view.style." + tokenName.toLowerCase());
        }
        this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.1"), "view.style.foldLine.1");
        this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.2"), "view.style.foldLine.2");
        this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.3"), "view.style.foldLine.3");
        this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.0"), "view.style.foldLine.0");
        Collections.sort(this.styleChoices, new StandardUtilities.StringCompare(true));
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.styleChoices.size();
    }

    public Object getValueAt(int row, int col) {
        StyleChoice ch = this.styleChoices.get(row);
        switch (col) {
            case 0: {
                return ch.label;
            }
            case 1: {
                return ch.style;
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        StyleChoice ch = this.styleChoices.get(row);
        if (col == 1) {
            ch.style = (SyntaxStyle)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.syntax.object");
            }
            case 1: {
                return jEdit.getProperty("options.syntax.style");
            }
        }
        return null;
    }

    public void save() {
        for (int i = 0; i < this.styleChoices.size(); ++i) {
            StyleChoice ch = this.styleChoices.get(i);
            jEdit.setProperty(ch.property, GUIUtilities.getStyleString(ch.style));
        }
    }

    private void addStyleChoice(String label, String property) {
        this.styleChoices.add(new StyleChoice(label, property, GUIUtilities.parseStyle(jEdit.getProperty(property), "Dialog", 12)));
    }

    static class StyleRenderer
    extends JLabel
    implements TableCellRenderer {
        StyleRenderer() {
            this.setOpaque(true);
            this.setBorder(SyntaxHiliteOptionPane.noFocusBorder);
            this.setText("Hello World");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            if (value != null) {
                SyntaxStyle style = (SyntaxStyle)value;
                this.setForeground(style.getForegroundColor());
                if (style.getBackgroundColor() != null) {
                    this.setBackground(style.getBackgroundColor());
                } else {
                    this.setBackground(jEdit.getColorProperty("view.bgColor"));
                }
                this.setFont(style.getFont());
            }
            this.setBorder(cellHasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : SyntaxHiliteOptionPane.noFocusBorder);
            return this;
        }
    }

    private static class StyleChoice {
        private String label;
        private String property;
        private SyntaxStyle style;

        StyleChoice(String label, String property, SyntaxStyle style) {
            this.label = label;
            this.property = property;
            this.style = style;
        }

        public String toString() {
            return this.label;
        }
    }
}

