/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.gui.FilteredTableModel;
import org.gjt.sp.jedit.gui.GrabKeyDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortcutsOptionPane
extends AbstractOptionPane {
    private JTable keyTable;
    private Vector<ShortcutsModel> models;
    private FilteredTableModel<ShortcutsModel> filteredModel;
    private JComboBox selectModel;
    private List<GrabKeyDialog.KeyBinding> allBindings;
    private JTextField filterTF;

    public ShortcutsOptionPane() {
        super("shortcuts");
    }

    @Override
    protected void _init() {
        this.allBindings = new Vector<GrabKeyDialog.KeyBinding>();
        this.setLayout(new BorderLayout(12, 12));
        this.initModels();
        this.selectModel = new JComboBox<ShortcutsModel>(this.models);
        this.selectModel.addActionListener(new ActionHandler());
        this.selectModel.setToolTipText(jEdit.getProperty("options.shortcuts.select.tooltip"));
        Box north = Box.createHorizontalBox();
        north.add(new JLabel(jEdit.getProperty("options.shortcuts.select.label")));
        north.add(Box.createHorizontalStrut(6));
        north.add(this.selectModel);
        this.filterTF = new JTextField(40);
        this.filterTF.setToolTipText(jEdit.getProperty("options.shortcuts.filter.tooltip"));
        this.filterTF.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ShortcutsOptionPane.this.setFilter();
            }

            public void insertUpdate(DocumentEvent e) {
                ShortcutsOptionPane.this.setFilter();
            }

            public void removeUpdate(DocumentEvent e) {
                ShortcutsOptionPane.this.setFilter();
            }
        });
        JButton clearButton = new JButton(jEdit.getProperty("options.shortcuts.clear.label"));
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ShortcutsOptionPane.this.filterTF.setText("");
                ShortcutsOptionPane.this.filterTF.requestFocus();
            }
        });
        JPanel filterPanel = new JPanel(new FlowLayout(0));
        filterPanel.add(new JLabel(jEdit.getProperty("options.shortcuts.filter.label")));
        filterPanel.add(this.filterTF);
        filterPanel.add(clearButton);
        this.keyTable = new JTable(this.filteredModel);
        this.filteredModel.setTable(this.keyTable);
        this.keyTable.getTableHeader().setReorderingAllowed(false);
        this.keyTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.keyTable.addMouseListener(new TableMouseHandler());
        Dimension d = this.keyTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.keyTable);
        scroller.setPreferredSize(d);
        JPanel tableFilterPanel = new JPanel(new BorderLayout());
        tableFilterPanel.add("North", filterPanel);
        tableFilterPanel.add("Center", scroller);
        this.add("North", north);
        this.add("Center", tableFilterPanel);
        try {
            this.selectModel.setSelectedIndex(jEdit.getIntegerProperty("options.shortcuts.select.index", 0));
        }
        catch (IllegalArgumentException eae) {
            // empty catch block
        }
    }

    private void setFilter() {
        this.filteredModel.setFilter(this.filterTF.getText());
    }

    @Override
    protected void _save() {
        if (this.keyTable.getCellEditor() != null) {
            this.keyTable.getCellEditor().stopCellEditing();
        }
        for (ShortcutsModel model : this.models) {
            model.save();
        }
        Macros.loadMacros();
    }

    private void initModels() {
        Vector<GrabKeyDialog.KeyBinding[]> allBindings = new Vector<GrabKeyDialog.KeyBinding[]>();
        this.models = new Vector();
        ActionSet[] actionSets = jEdit.getActionSets();
        for (int i = 0; i < actionSets.length; ++i) {
            ActionSet actionSet = actionSets[i];
            if (actionSet.getActionCount() == 0) continue;
            String modelLabel = actionSet.getLabel();
            if (modelLabel == null) {
                Log.log(9, this, "Empty action set: " + actionSet.getPluginJAR());
            }
            ShortcutsModel model = this.createModel(modelLabel, actionSet.getActionNames());
            this.models.addElement(model);
            allBindings.addAll(model.getBindings());
        }
        if (this.models.size() > 1) {
            this.models.addElement(new ShortcutsModel("All", allBindings));
        }
        Collections.sort(this.models, new StandardUtilities.StringCompare(true));
        ShortcutsModel currentModel = this.models.elementAt(0);
        this.filteredModel = new FilteredTableModel<ShortcutsModel>(currentModel){

            @Override
            public String prepareFilter(String filter) {
                return filter.toLowerCase();
            }

            @Override
            public boolean passFilter(int row, String filter) {
                String name = ((ShortcutsModel)this.delegated).getBindingAt((int)row, (int)0).label.toLowerCase();
                return name.contains(filter);
            }
        };
    }

    private ShortcutsModel createModel(String modelLabel, String[] actions) {
        Vector<GrabKeyDialog.KeyBinding[]> bindings = new Vector<GrabKeyDialog.KeyBinding[]>(actions.length);
        for (int i = 0; i < actions.length; ++i) {
            String name = actions[i];
            EditAction ea = jEdit.getAction(name);
            String label = ea.getLabel();
            if (label == null) continue;
            label = GUIUtilities.prettifyMenuLabel(label);
            this.addBindings(name, label, bindings);
        }
        return new ShortcutsModel(modelLabel, bindings);
    }

    private void addBindings(String name, String label, List<GrabKeyDialog.KeyBinding[]> bindings) {
        GrabKeyDialog.KeyBinding[] b = new GrabKeyDialog.KeyBinding[]{this.createBinding(name, label, jEdit.getProperty(name + ".shortcut")), this.createBinding(name, label, jEdit.getProperty(name + ".shortcut2"))};
        bindings.add(b);
    }

    private GrabKeyDialog.KeyBinding createBinding(String name, String label, String shortcut) {
        if (shortcut != null && shortcut.length() == 0) {
            shortcut = null;
        }
        GrabKeyDialog.KeyBinding binding = new GrabKeyDialog.KeyBinding(name, label, shortcut, false);
        this.allBindings.add(binding);
        return binding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShortcutsModel
    extends AbstractTableModel {
        private List<GrabKeyDialog.KeyBinding[]> bindings;
        private String name;

        ShortcutsModel(String name, List<GrabKeyDialog.KeyBinding[]> bindings) {
            this.name = name;
            this.bindings = bindings;
            this.sort(0);
        }

        public List<GrabKeyDialog.KeyBinding[]> getBindings() {
            return this.bindings;
        }

        public void sort(int col) {
            Collections.sort(this.bindings, new KeyCompare(col));
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.bindings.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.getBindingAt((int)row, (int)0).label;
                }
                case 1: {
                    return this.getBindingAt((int)row, (int)0).shortcut;
                }
                case 2: {
                    return this.getBindingAt((int)row, (int)1).shortcut;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                return;
            }
            this.getBindingAt((int)row, (int)(col - 1)).shortcut = (String)value;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return jEdit.getProperty("options.shortcuts.name");
                }
                case 1: {
                    return jEdit.getProperty("options.shortcuts.shortcut1");
                }
                case 2: {
                    return jEdit.getProperty("options.shortcuts.shortcut2");
                }
            }
            return null;
        }

        public void save() {
            for (GrabKeyDialog.KeyBinding[] binding : this.bindings) {
                jEdit.setProperty(binding[0].name + ".shortcut", binding[0].shortcut);
                jEdit.setProperty(binding[1].name + ".shortcut2", binding[1].shortcut);
            }
        }

        public GrabKeyDialog.KeyBinding getBindingAt(int row, int nr) {
            GrabKeyDialog.KeyBinding[] binding = this.bindings.get(row);
            return binding[nr];
        }

        public String toString() {
            return this.name;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyCompare
        implements Comparator<GrabKeyDialog.KeyBinding[]> {
            private int col;

            KeyCompare(int col) {
                this.col = col;
            }

            @Override
            public int compare(GrabKeyDialog.KeyBinding[] k1, GrabKeyDialog.KeyBinding[] k2) {
                String shortcut2;
                String shortcut1;
                String label1 = k1[0].label.toLowerCase();
                String label2 = k2[0].label.toLowerCase();
                if (this.col == 0) {
                    return StandardUtilities.compareStrings(label1, label2, true);
                }
                if (this.col == 1) {
                    shortcut1 = k1[0].shortcut;
                    shortcut2 = k2[0].shortcut;
                } else {
                    shortcut1 = k1[1].shortcut;
                    shortcut2 = k2[1].shortcut;
                }
                if (shortcut1 == null && shortcut2 != null) {
                    return 1;
                }
                if (shortcut2 == null && shortcut1 != null) {
                    return -1;
                }
                if (shortcut1 == null) {
                    return StandardUtilities.compareStrings(label1, label2, true);
                }
                return StandardUtilities.compareStrings(shortcut1, shortcut2, true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            ShortcutsModel newModel = (ShortcutsModel)ShortcutsOptionPane.this.selectModel.getSelectedItem();
            if (ShortcutsOptionPane.this.filteredModel.getDelegated() != newModel) {
                jEdit.setIntegerProperty("options.shortcuts.select.index", ShortcutsOptionPane.this.selectModel.getSelectedIndex());
                ShortcutsOptionPane.this.filteredModel.setDelegated(newModel);
                ShortcutsOptionPane.this.setFilter();
            }
        }
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            GrabKeyDialog gkd;
            int row = ShortcutsOptionPane.this.keyTable.getSelectedRow();
            int col = ShortcutsOptionPane.this.keyTable.getSelectedColumn();
            if (col != 0 && row != -1 && (gkd = new GrabKeyDialog((Dialog)GUIUtilities.getParentDialog(ShortcutsOptionPane.this), ((ShortcutsModel)ShortcutsOptionPane.this.filteredModel.getDelegated()).getBindingAt(ShortcutsOptionPane.this.filteredModel.getTrueRow(row), col - 1), (List<GrabKeyDialog.KeyBinding>)ShortcutsOptionPane.this.allBindings, null)).isOK()) {
                ShortcutsOptionPane.this.filteredModel.setValueAt(gkd.getShortcut(), row, col);
            }
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            ShortcutsModel shortcutsModel = (ShortcutsModel)ShortcutsOptionPane.this.filteredModel.getDelegated();
            switch (ShortcutsOptionPane.this.keyTable.getTableHeader().columnAtPoint(evt.getPoint())) {
                case 0: {
                    shortcutsModel.sort(0);
                    break;
                }
                case 1: {
                    shortcutsModel.sort(1);
                    break;
                }
                case 2: {
                    shortcutsModel.sort(2);
                }
            }
            ShortcutsOptionPane.this.setFilter();
        }
    }
}

