/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.options.WindowTableModel;

public class DockingOptionPane
extends AbstractOptionPane {
    private JTable windowTable;
    private WindowTableModel windowModel;

    public DockingOptionPane() {
        super("docking");
    }

    public void _init() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.createWindowTableScroller());
    }

    public void _save() {
        this.windowModel.save();
    }

    private JScrollPane createWindowTableScroller() {
        this.windowModel = DockingOptionPane.createWindowModel();
        this.windowTable = new JTable(this.windowModel);
        this.windowTable.getTableHeader().setReorderingAllowed(false);
        this.windowTable.setColumnSelectionAllowed(false);
        this.windowTable.setRowSelectionAllowed(false);
        this.windowTable.setCellSelectionEnabled(false);
        DockPositionCellRenderer comboBox = new DockPositionCellRenderer();
        this.windowTable.setRowHeight(comboBox.getPreferredSize().height);
        TableColumn column = this.windowTable.getColumnModel().getColumn(1);
        column.setCellRenderer(comboBox);
        column.setCellEditor(new DefaultCellEditor(new DockPositionCellRenderer()));
        Dimension d = this.windowTable.getPreferredSize();
        d.height = Math.min(d.height, 50);
        JScrollPane scroller = new JScrollPane(this.windowTable);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private static WindowTableModel createWindowModel() {
        return new WindowTableModel();
    }

    static class DockPositionCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        DockPositionCellRenderer() {
            super(new String[]{"floating", "top", "left", "bottom", "right"});
            this.setRequestFocusEnabled(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelectedItem(value);
            return this;
        }
    }
}

