/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.Abbrev;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbbrevsModel
extends AbstractTableModel {
    List<Abbrev> abbrevs = new Vector<Abbrev>();
    int lastSort;

    AbbrevsModel(Map<String, String> abbrevHash) {
        if (abbrevHash != null) {
            Set<Map.Entry<String, String>> entrySet = abbrevHash.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                this.abbrevs.add(new Abbrev(entry.getKey(), entry.getValue()));
            }
            this.sort(0);
        }
    }

    void sort(int col) {
        this.lastSort = col;
        Collections.sort(this.abbrevs, new AbbrevCompare(col));
        this.fireTableDataChanged();
    }

    void add(String abbrev, String expansion) {
        this.abbrevs.add(new Abbrev(abbrev, expansion));
        this.sort(this.lastSort);
    }

    void remove(int index) {
        this.abbrevs.remove(index);
        this.fireTableStructureChanged();
    }

    public Hashtable<String, String> toHashtable() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (int i = 0; i < this.abbrevs.size(); ++i) {
            Abbrev abbrev = this.abbrevs.get(i);
            if (abbrev.abbrev.length() <= 0 || abbrev.expand.length() <= 0) continue;
            hash.put(abbrev.abbrev, abbrev.expand);
        }
        return hash;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.abbrevs.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Abbrev abbrev = this.abbrevs.get(row);
        switch (col) {
            case 0: {
                return abbrev.abbrev;
            }
            case 1: {
                return abbrev.expand;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            value = "";
        }
        Abbrev abbrev = this.abbrevs.get(row);
        if (col == 0) {
            abbrev.abbrev = (String)value;
        } else {
            abbrev.expand = (String)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.abbrevs.abbrev");
            }
            case 1: {
                return jEdit.getProperty("options.abbrevs.expand");
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbbrevCompare
    implements Comparator<Abbrev> {
        private int col;

        AbbrevCompare(int col) {
            this.col = col;
        }

        @Override
        public int compare(Abbrev a1, Abbrev a2) {
            if (this.col == 0) {
                String abbrev1 = a1.abbrev.toLowerCase();
                String abbrev2 = a2.abbrev.toLowerCase();
                return StandardUtilities.compareStrings(abbrev1, abbrev2, true);
            }
            String expand1 = a1.expand.toLowerCase();
            String expand2 = a2.expand.toLowerCase();
            return StandardUtilities.compareStrings(expand1, expand2, true);
        }
    }
}

