/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.util.regex.Pattern;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSFileFilter;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class GlobVFSFileFilter
implements VFSFileFilter {
    private String glob;
    private Pattern pattern;

    public GlobVFSFileFilter(String glob) {
        this.glob = glob;
    }

    public boolean accept(VFSFile file) {
        if (file.getType() == 1 || file.getType() == 2) {
            return true;
        }
        return this.accept(file.getName());
    }

    public boolean accept(String url) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(StandardUtilities.globToRE(this.glob), 2);
        }
        return this.pattern.matcher(url).matches();
    }

    public String getDescription() {
        return jEdit.getProperty("vfs.browser.file_filter.glob");
    }

    public String toString() {
        return this.glob;
    }

    public void setGlob(String glob) {
        this.glob = glob;
        this.pattern = null;
    }

    public String getGlob() {
        return this.glob;
    }
}

