/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.input;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.ShortcutPrefixActiveEvent;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInputHandler<E extends JEditAbstractEditAction> {
    protected int lastActionCount;
    protected KeyListener keyEventInterceptor;
    protected String readNextChar;
    protected int repeatCount = 1;
    protected E lastAction;
    protected static final int REPEAT_COUNT_THRESHOLD = 20;
    public static Object PREFIX_STR = "PREFIX_STR";
    protected boolean shortcutOn = false;
    protected Hashtable bindings;
    protected Hashtable currentBindings;

    public void addKeyBinding(String keyBinding, String action) {
        this.addKeyBinding(keyBinding, (Object)action);
    }

    public void addKeyBinding(String keyBinding, E action) {
        this.addKeyBinding(keyBinding, (Object)action);
    }

    public void addKeyBinding(String keyBinding, Object action) {
        Hashtable current = this.bindings;
        String prefixStr = null;
        StringTokenizer st = new StringTokenizer(keyBinding);
        while (st.hasMoreTokens()) {
            String keyCodeStr = st.nextToken();
            prefixStr = prefixStr == null ? keyCodeStr : prefixStr + " " + keyCodeStr;
            KeyEventTranslator.Key keyStroke = KeyEventTranslator.parseKey(keyCodeStr);
            if (keyStroke == null) {
                return;
            }
            if (st.hasMoreTokens()) {
                Object o = current.get(keyStroke);
                if (o instanceof Hashtable) {
                    current = (Hashtable)o;
                    continue;
                }
                Hashtable<Object, String> hash = new Hashtable<Object, String>();
                hash.put(PREFIX_STR, prefixStr);
                o = hash;
                current.put(keyStroke, o);
                current = (Hashtable)o;
                continue;
            }
            current.put(keyStroke, action);
        }
    }

    public void removeKeyBinding(String keyBinding) {
        Hashtable current = this.bindings;
        StringTokenizer st = new StringTokenizer(keyBinding);
        while (st.hasMoreTokens()) {
            String keyCodeStr = st.nextToken();
            KeyEventTranslator.Key keyStroke = KeyEventTranslator.parseKey(keyCodeStr);
            if (keyStroke == null) {
                return;
            }
            if (st.hasMoreTokens()) {
                Object o = current.get(keyStroke);
                if (o instanceof Hashtable) {
                    current = (Hashtable)o;
                    continue;
                }
                if (o != null) {
                    current.remove(keyStroke);
                    return;
                }
                return;
            }
            current.remove(keyStroke);
        }
    }

    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    public Object getKeyBinding(String keyBinding) {
        Hashtable current = this.bindings;
        StringTokenizer st = new StringTokenizer(keyBinding);
        while (st.hasMoreTokens()) {
            KeyEventTranslator.Key keyStroke = KeyEventTranslator.parseKey(st.nextToken());
            if (keyStroke == null) {
                return null;
            }
            if (st.hasMoreTokens()) {
                Object o = current.get(keyStroke);
                if (o instanceof Hashtable) {
                    if (!st.hasMoreTokens()) {
                        return o;
                    }
                    current = (Hashtable)o;
                    continue;
                }
                return o;
            }
            return current.get(keyStroke);
        }
        return null;
    }

    public int getLastActionCount() {
        return this.lastActionCount;
    }

    public void resetLastActionCount() {
        this.lastActionCount = 0;
    }

    public KeyListener getKeyEventInterceptor() {
        return this.keyEventInterceptor;
    }

    public void setKeyEventInterceptor(KeyListener keyEventInterceptor) {
        this.keyEventInterceptor = keyEventInterceptor;
    }

    public boolean isPrefixActive() {
        return this.readNextChar != null;
    }

    public void setBindings(Hashtable bindings) {
        this.bindings = this.currentBindings = bindings;
    }

    public void setCurrentBindings(Hashtable bindings) {
        this.currentBindings = bindings;
    }

    public abstract boolean handleKey(KeyEventTranslator.Key var1, boolean var2);

    public abstract void processKeyEvent(KeyEvent var1, int var2, boolean var3);

    protected void sendShortcutPrefixOff() {
        if (this.shortcutOn) {
            ShortcutPrefixActiveEvent.firePrefixStateChange(null, false);
            this.shortcutOn = false;
        }
    }

    public abstract void invokeAction(String var1);

    public abstract void invokeAction(E var1);

    public static String toString(KeyEvent evt) {
        String id;
        switch (evt.getID()) {
            case 401: {
                id = "KEY_PRESSED";
                break;
            }
            case 402: {
                id = "KEY_RELEASED";
                break;
            }
            case 400: {
                id = "KEY_TYPED";
                break;
            }
            default: {
                id = "unknown type";
            }
        }
        StringBuilder b = new StringBuilder(50);
        b.append(id);
        b.append(",keyCode=0x").append(Integer.toString(evt.getKeyCode(), 16));
        b.append(",keyChar=0x").append(Integer.toString(evt.getKeyChar(), 16));
        b.append(",modifiers=0x").append(Integer.toString(evt.getModifiers(), 16));
        b.append(",consumed=");
        b.append(evt.isConsumed() ? (char)'1' : '0');
        return b.toString();
    }

    protected void processKeyEventKeyStrokeHandling(KeyEvent evt, int from, String mode, boolean global) {
        KeyEventTranslator.Key keyStroke = KeyEventTranslator.translateKeyEvent2(evt);
        if (keyStroke != null) {
            keyStroke.setIsFromGlobalContext(global);
            if (Debug.DUMP_KEY_EVENTS) {
                Log.log(1, this, "Translated (key " + mode + "): " + keyStroke + " from " + from);
            }
            boolean consumed = false;
            if (this.handleKey(keyStroke, keyStroke.isPhantom())) {
                evt.consume();
                consumed = true;
            }
            if (Debug.DUMP_KEY_EVENTS) {
                Log.log(1, this, "Translated (key " + mode + "): " + keyStroke + " from " + from + ": consumed=" + consumed + '.');
            }
        }
    }
}

