/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.IndentAction;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpIndentRule
implements IndentRule {
    private IndentAction prevPrevAction;
    private IndentAction prevAction;
    private IndentAction thisAction;
    private Pattern regexp;
    private boolean collapse;

    public RegexpIndentRule(String regexp, IndentAction prevPrev, IndentAction prev, IndentAction thisLine, boolean collapse) throws PatternSyntaxException {
        this.prevPrevAction = prevPrev;
        this.prevAction = prev;
        this.thisAction = thisLine;
        this.regexp = Pattern.compile(regexp, 2);
        this.collapse = collapse;
    }

    @Override
    public void apply(JEditBuffer buffer, int thisLineIndex, int prevLineIndex, int prevPrevLineIndex, List<IndentAction> indentActions) {
        if (this.thisAction != null && this.lineMatches(buffer, thisLineIndex)) {
            indentActions.add(this.thisAction);
        }
        if (this.prevAction != null && prevLineIndex != -1 && this.lineMatches(buffer, prevLineIndex)) {
            indentActions.add(this.prevAction);
            if (this.collapse) {
                indentActions.add(IndentAction.PrevCollapse);
            }
        }
        if (this.prevPrevAction != null && prevPrevLineIndex != -1 && this.lineMatches(buffer, prevPrevLineIndex)) {
            indentActions.add(this.prevPrevAction);
            if (this.collapse) {
                indentActions.add(IndentAction.PrevPrevCollapse);
            }
        }
    }

    @Deprecated
    public boolean isMatch(String line) {
        Matcher m = this.regexp.matcher(line);
        return m.matches();
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.regexp + ']';
    }

    private boolean lineMatches(JEditBuffer buffer, int lineIndex) {
        TokenFilter filter = new TokenFilter(buffer.getLineLength(lineIndex));
        buffer.markTokens(lineIndex, filter);
        return this.regexp.matcher(filter.result).matches();
    }

    private static class TokenFilter
    implements TokenHandler {
        public StringBuilder result;

        public TokenFilter(int originalLength) {
            this.result = new StringBuilder(originalLength);
        }

        public void handleToken(Segment seg, byte id, int offset, int length, TokenMarker.LineContext context) {
            if (length <= 0) {
                return;
            }
            switch (id) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.result.append(' ');
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.result.append('0');
                    break;
                }
                default: {
                    this.result.append(seg.array, seg.offset + offset, length);
                }
            }
        }

        public void setLineContext(TokenMarker.LineContext lineContext) {
        }
    }
}

