/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.StandardUtilities;

public interface IndentAction {
    public static final Collapse PrevCollapse = new Collapse();
    public static final Collapse PrevPrevCollapse = new Collapse();

    public int calculateIndent(JEditBuffer var1, int var2, int var3, int var4);

    public boolean keepChecking();

    public static class NoIncrease
    implements IndentAction {
        public int calculateIndent(JEditBuffer buffer, int line, int oldIndent, int newIndent) {
            int current = StandardUtilities.getLeadingWhiteSpaceWidth(buffer.getLineSegment(line), buffer.getTabSize());
            return current < newIndent ? current : newIndent;
        }

        public boolean keepChecking() {
            return true;
        }
    }

    public static class AlignParameter
    implements IndentAction {
        private int openParensColumn;

        public AlignParameter(int openParensColumn) {
            this.openParensColumn = openParensColumn;
        }

        public int calculateIndent(JEditBuffer buffer, int line, int oldIndent, int newIndent) {
            return this.openParensColumn + 1;
        }

        public boolean keepChecking() {
            return false;
        }
    }

    public static class AlignOffset
    implements IndentAction {
        private int offset;

        public AlignOffset(int offset) {
            this.offset = offset;
        }

        public int calculateIndent(JEditBuffer buffer, int line, int oldIndent, int newIndent) {
            return this.offset;
        }

        public boolean keepChecking() {
            return false;
        }
    }

    public static class Decrease
    implements IndentAction {
        public int calculateIndent(JEditBuffer buffer, int line, int oldIndent, int newIndent) {
            return newIndent - buffer.getIndentSize();
        }

        public boolean keepChecking() {
            return true;
        }
    }

    public static class Increase
    implements IndentAction {
        private int amount;

        public Increase() {
            this.amount = 1;
        }

        public Increase(int amount) {
            this.amount = amount;
        }

        public int calculateIndent(JEditBuffer buffer, int line, int oldIndent, int newIndent) {
            return newIndent + buffer.getIndentSize() * this.amount;
        }

        public boolean keepChecking() {
            return true;
        }

        public boolean equals(Object o) {
            if (o instanceof Increase) {
                return ((Increase)o).amount == this.amount;
            }
            return false;
        }
    }

    public static class Reset
    implements IndentAction {
        public int calculateIndent(JEditBuffer buffer, int line, int oldIndent, int newIndent) {
            return oldIndent;
        }

        public boolean keepChecking() {
            return true;
        }
    }

    public static class Collapse
    implements IndentAction {
        public int calculateIndent(JEditBuffer buffer, int line, int oldIndent, int newIndent) {
            return newIndent;
        }

        public boolean keepChecking() {
            return true;
        }

        private Collapse() {
        }
    }
}

