/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import java.util.List;
import java.util.Stack;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.IndentAction;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepIndentRule
implements IndentRule {
    private final char openChar;
    private final char closeChar;

    public DeepIndentRule(char openChar, char closeChar) {
        this.openChar = openChar;
        this.closeChar = closeChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(JEditBuffer buffer, int thisLineIndex, int prevLineIndex, int prevPrevLineIndex, List<IndentAction> indentActions) {
        int lineIndex;
        if (prevLineIndex == -1) {
            return;
        }
        int oldLineIndex = lineIndex = prevLineIndex;
        CharSequence lineText = buffer.getLineSegment(lineIndex);
        int searchPos = -1;
        while (true) {
            if (lineIndex != oldLineIndex) {
                lineText = buffer.getLineSegment(lineIndex);
                oldLineIndex = lineIndex;
            }
            Parens parens = new Parens(buffer, lineIndex, searchPos);
            if (parens.openOffset == -1 && parens.closeOffset == -1) {
                if (prevPrevLineIndex == -1) return;
                searchPos = -1;
                lineIndex = prevPrevLineIndex;
                prevPrevLineIndex = -1;
                continue;
            }
            if (parens.closeOffset == -1) {
                int indent = parens.openOffset + this.getIndent(lineText, buffer.getTabSize()) - lineText.length();
                indentActions.clear();
                indentActions.add(new IndentAction.AlignParameter(indent));
                return;
            }
            int openParenOffset = TextUtilities.findMatchingBracket(buffer, lineIndex, parens.closeOffset);
            if (openParenOffset < 0) return;
            prevPrevLineIndex = -1;
            lineIndex = buffer.getLineOfOffset(openParenOffset);
            searchPos = openParenOffset - buffer.getLineStartOffset(lineIndex) - 1;
            if (searchPos < 0) return;
        }
    }

    private int getIndent(CharSequence line, int tabSize) {
        int cnt = 0;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == '\t') {
                cnt += tabSize;
                continue;
            }
            if (!Character.isWhitespace(line.charAt(i))) {
                cnt += line.length() - i;
                break;
            }
            ++cnt;
        }
        return cnt;
    }

    private class Parens
    implements TokenHandler {
        int openOffset;
        int closeOffset;
        private int searchPos;
        private Stack<Integer> open;
        private Stack<Integer> close;

        Parens(JEditBuffer b, int line, int pos) {
            this.searchPos = pos;
            this.open = new Stack();
            this.close = new Stack();
            b.markTokens(line, this);
            this.openOffset = this.open.isEmpty() ? -1 : this.open.pop();
            this.closeOffset = this.close.isEmpty() ? -1 : this.close.pop();
        }

        public void handleToken(Segment seg, byte id, int offset, int length, TokenMarker.LineContext context) {
            if (length <= 0 || this.searchPos != -1 && this.searchPos < offset) {
                return;
            }
            if (this.searchPos != -1 && offset + length > this.searchPos) {
                length = this.searchPos - offset + 1;
            }
            switch (id) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    for (int i = offset; i < offset + length; ++i) {
                        if (seg.array[seg.offset + i] == DeepIndentRule.this.openChar) {
                            if (this.open.isEmpty() && !this.close.isEmpty()) {
                                this.close.pop();
                                continue;
                            }
                            this.open.push(i);
                            continue;
                        }
                        if (seg.array[seg.offset + i] != DeepIndentRule.this.closeChar) continue;
                        if (this.close.isEmpty() && !this.open.isEmpty()) {
                            this.open.pop();
                            continue;
                        }
                        this.close.push(i);
                    }
                }
            }
        }

        public void setLineContext(TokenMarker.LineContext lineContext) {
        }

        public String toString() {
            return "Parens(" + this.openOffset + ',' + this.closeOffset + ')';
        }
    }
}

