/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class RectSelectWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        RectSelectWidget rect = new RectSelectWidget(view);
        return rect;
    }

    private static class RectSelectWidget
    implements Widget {
        private final JLabel rectSelect = new ToolTipLabel();
        private final View view;

        RectSelectWidget(final View view) {
            this.rectSelect.setHorizontalAlignment(0);
            this.rectSelect.setToolTipText(jEdit.getProperty("view.status.rect-tooltip"));
            this.view = view;
            this.rectSelect.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    JEditTextArea textArea = view.getTextArea();
                    if (textArea != null) {
                        textArea.toggleRectangularSelectionEnabled();
                    }
                }
            });
        }

        public JComponent getComponent() {
            return this.rectSelect;
        }

        public void update() {
            JEditTextArea textArea = this.view.getTextArea();
            if (textArea != null) {
                this.rectSelect.setText(textArea.isRectangularSelectionEnabled() ? "R" : "-");
            }
        }

        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fm = this.rectSelect.getFontMetrics(font);
            Dimension dim = new Dimension(Math.max(fm.charWidth('-'), fm.charWidth('R')) + 1, fm.getHeight());
            this.rectSelect.setPreferredSize(dim);
            this.rectSelect.setMaximumSize(dim);
        }
    }
}

