/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class OverwriteWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        OverwriteWidget overwrite = new OverwriteWidget(view);
        return overwrite;
    }

    private static class OverwriteWidget
    implements Widget {
        private final JLabel overwrite = new ToolTipLabel();
        private final View view;

        OverwriteWidget(final View view) {
            this.overwrite.setHorizontalAlignment(0);
            this.overwrite.setToolTipText(jEdit.getProperty("view.status.overwrite-tooltip"));
            this.view = view;
            this.overwrite.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    JEditTextArea textArea = view.getTextArea();
                    if (textArea != null) {
                        textArea.toggleOverwriteEnabled();
                    }
                }
            });
        }

        public JComponent getComponent() {
            return this.overwrite;
        }

        public void update() {
            JEditTextArea textArea = this.view.getTextArea();
            if (textArea != null) {
                this.overwrite.setText(textArea.isOverwriteEnabled() ? "O" : "-");
            }
        }

        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fm = this.overwrite.getFontMetrics(font);
            Dimension dim = new Dimension(Math.max(fm.charWidth('-'), fm.charWidth('O')) + 1, fm.getHeight());
            this.overwrite.setPreferredSize(dim);
            this.overwrite.setMaximumSize(dim);
        }
    }
}

