/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class MemoryStatusWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        MemoryStatusWidget memory = new MemoryStatusWidget(view);
        return memory;
    }

    private static class MemoryStatus
    extends JComponent
    implements ActionListener {
        private View view;
        private static final String memoryTestStr = "999/999Mb";
        private final LineMetrics lm;
        private final Color progressForeground;
        private final Color progressBackground;
        private final Integer[] args = new Integer[2];
        private Timer timer;

        MemoryStatus(View view) {
            this.view = view;
            Font font = new JLabel().getFont();
            this.setFont(font);
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D bounds = font.getStringBounds(memoryTestStr, frc);
            Dimension dim = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
            this.setPreferredSize(dim);
            this.setMaximumSize(dim);
            this.lm = font.getLineMetrics(memoryTestStr, frc);
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
            this.progressForeground = jEdit.getColorProperty("view.status.memory.foreground");
            this.progressBackground = jEdit.getColorProperty("view.status.memory.background");
            this.addMouseListener(new MouseHandler());
        }

        public void addNotify() {
            super.addNotify();
            this.timer = new Timer(2000, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public String getToolTipText() {
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() >> 10);
            int totalMemory = (int)(runtime.totalMemory() >> 10);
            int usedMemory = totalMemory - freeMemory;
            this.args[0] = new Integer(usedMemory);
            this.args[1] = new Integer(totalMemory);
            return jEdit.getProperty("view.status.memory-tooltip", this.args);
        }

        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX(), -20);
        }

        public void actionPerformed(ActionEvent evt) {
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            Insets insets = new Insets(0, 0, 0, 0);
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() >> 10);
            int totalMemory = (int)(runtime.totalMemory() >> 10);
            int usedMemory = totalMemory - freeMemory;
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom - 1;
            float fraction = (float)usedMemory / (float)totalMemory;
            g.setColor(this.progressBackground);
            g.fillRect(insets.left, insets.top, (int)((float)width * fraction), height);
            String str = (usedMemory >> 10) + "/" + (totalMemory >> 10) + "Mb";
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D bounds = g.getFont().getStringBounds(str, frc);
            Graphics g2 = g.create();
            g2.setClip(insets.left, insets.top, (int)((float)width * fraction), height);
            g2.setColor(this.progressForeground);
            g2.drawString(str, insets.left + ((int)((double)width - bounds.getWidth()) >> 1), (int)((float)insets.top + this.lm.getAscent()));
            g2.dispose();
            g2 = g.create();
            g2.setClip(insets.left + (int)((float)width * fraction), insets.top, this.getWidth() - insets.left - (int)((float)width * fraction), height);
            g2.setColor(this.getForeground());
            g2.drawString(str, insets.left + ((int)((double)width - bounds.getWidth()) >> 1), (int)((float)insets.top + this.lm.getAscent()));
            g2.dispose();
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    jEdit.showMemoryDialog(MemoryStatus.this.view);
                    MemoryStatus.this.repaint();
                }
            }
        }
    }

    private static class MemoryStatusWidget
    implements Widget {
        private final MemoryStatus memoryStatus;

        public MemoryStatusWidget(View view) {
            this.memoryStatus = new MemoryStatus(view);
        }

        public JComponent getComponent() {
            return this.memoryStatus;
        }

        public void update() {
        }

        public void propertiesChanged() {
        }
    }
}

