/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

public class StyleEditor
extends EnhancedDialog
implements ActionListener {
    private JCheckBox italics;
    private JCheckBox bold;
    private JCheckBox fgColorCheckBox;
    private ColorWellButton fgColor;
    private JCheckBox bgColorCheckBox;
    private ColorWellButton bgColor;
    private JButton ok;
    private JButton cancel;
    private boolean okClicked;

    public StyleEditor(JDialog parent, SyntaxStyle style, String styleName) {
        super(parent, jEdit.getProperty("style-editor.title"), true);
        this.initialize(parent, style, styleName);
    }

    public StyleEditor(JFrame parent, SyntaxStyle style, String styleName) {
        super(parent, jEdit.getProperty("style-editor.title"), true);
        this.initialize(parent, style, styleName);
    }

    private void initialize(Component comp, SyntaxStyle style, String styleName) {
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel panel = new JPanel(new GridLayout(5, 2, 12, 12));
        panel.add(new JLabel(jEdit.getProperty("style-editor.tokenType")));
        panel.add(new JLabel(styleName));
        this.italics = new JCheckBox(jEdit.getProperty("style-editor.italics"));
        this.italics.setSelected(style.getFont().isItalic());
        panel.add(this.italics);
        panel.add(new JLabel());
        this.bold = new JCheckBox(jEdit.getProperty("style-editor.bold"));
        this.bold.setSelected(style.getFont().isBold());
        panel.add(this.bold);
        panel.add(new JLabel());
        Color fg = style.getForegroundColor();
        this.fgColorCheckBox = new JCheckBox(jEdit.getProperty("style-editor.fgColor"));
        this.fgColorCheckBox.setSelected(fg != null);
        this.fgColorCheckBox.addActionListener(this);
        panel.add(this.fgColorCheckBox);
        this.fgColor = new ColorWellButton(fg);
        this.fgColor.setEnabled(fg != null);
        panel.add(this.fgColor);
        Color bg = style.getBackgroundColor();
        this.bgColorCheckBox = new JCheckBox(jEdit.getProperty("style-editor.bgColor"));
        this.bgColorCheckBox.setSelected(bg != null);
        this.bgColorCheckBox.addActionListener(this);
        panel.add(this.bgColorCheckBox);
        this.bgColor = new ColorWellButton(bg);
        this.bgColor.setEnabled(bg != null);
        panel.add(this.bgColor);
        content.add("Center", panel);
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        box.add(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addActionListener(this);
        box.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        box.add(this.cancel);
        this.cancel.addActionListener(this);
        box.add(Box.createGlue());
        content.add("South", box);
        this.pack();
        this.setLocationRelativeTo(comp);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.fgColorCheckBox) {
            this.fgColor.setEnabled(this.fgColorCheckBox.isSelected());
        } else if (source == this.bgColorCheckBox) {
            this.bgColor.setEnabled(this.bgColorCheckBox.isSelected());
        }
    }

    public void ok() {
        this.okClicked = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public SyntaxStyle getStyle() {
        if (!this.okClicked) {
            return null;
        }
        Color foreground = this.fgColorCheckBox.isSelected() ? this.fgColor.getSelectedColor() : null;
        Color background = this.bgColorCheckBox.isSelected() ? this.bgColor.getSelectedColor() : null;
        return new SyntaxStyle(foreground, background, new Font("Dialog", (this.italics.isSelected() ? 2 : 0) | (this.bold.isSelected() ? 1 : 0), 12));
    }
}

