/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class StatusBar
extends JPanel
implements WorkThreadProgressListener {
    private String currentBar;
    private View view;
    private JPanel panel;
    private Box box;
    private ToolTipLabel caretStatus;
    private Component messageComp;
    private JLabel message;
    private Widget modeWidget;
    private Widget foldWidget;
    private Widget encodingWidget;
    private Widget wrapWidget;
    private Widget multiSelectWidget;
    private Widget rectSelectWidget;
    private Widget overwriteWidget;
    private Widget lineSepWidget;
    StringBuilder buf = new StringBuilder();
    private Timer tempTimer;
    private boolean currentMessageIsIO;
    private Segment seg = new Segment();
    private boolean showCaretStatus;
    static final String caretTestStr = "9999,999-999 99%";

    public StatusBar(View view) {
        super(new BorderLayout());
        this.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 0, OperatingSystem.isMacOS() ? 18 : 0), UIManager.getBorder("TextField.border")));
        this.view = view;
        this.panel = new JPanel(new BorderLayout());
        this.box = new Box(0);
        this.panel.add("East", this.box);
        this.add("Center", this.panel);
        MouseHandler mouseHandler = new MouseHandler();
        this.caretStatus = new ToolTipLabel();
        this.caretStatus.setToolTipText(jEdit.getProperty("view.status.caret-tooltip"));
        this.caretStatus.addMouseListener(mouseHandler);
        this.message = new JLabel(" ");
        this.setMessageComponent(this.message);
        this.modeWidget = this._getWidget("mode");
        this.foldWidget = this._getWidget("fold");
        this.encodingWidget = this._getWidget("encoding");
        this.wrapWidget = this._getWidget("wrap");
        this.multiSelectWidget = this._getWidget("multiSelect");
        this.rectSelectWidget = this._getWidget("rectSelect");
        this.overwriteWidget = this._getWidget("overwrite");
        this.lineSepWidget = this._getWidget("lineSep");
    }

    public void propertiesChanged() {
        Color fg = jEdit.getColorProperty("view.status.foreground");
        Color bg = jEdit.getColorProperty("view.status.background");
        this.showCaretStatus = jEdit.getBooleanProperty("view.status.show-caret-status");
        this.panel.setBackground(bg);
        this.panel.setForeground(fg);
        this.caretStatus.setBackground(bg);
        this.caretStatus.setForeground(fg);
        this.message.setBackground(bg);
        this.message.setForeground(fg);
        Font font = new JLabel().getFont();
        FontMetrics fm = this.getFontMetrics(font);
        if (this.showCaretStatus) {
            this.panel.add("West", this.caretStatus);
            this.caretStatus.setFont(font);
            Dimension dim = new Dimension(fm.stringWidth(caretTestStr), fm.getHeight());
            this.caretStatus.setPreferredSize(dim);
        } else {
            this.panel.remove(this.caretStatus);
        }
        String statusBar = jEdit.getProperty("view.status");
        if (!StandardUtilities.objectsEqual(this.currentBar, statusBar)) {
            this.box.removeAll();
            StringTokenizer tokenizer = new StringTokenizer(statusBar);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (Character.isLetter(token.charAt(0))) {
                    Widget widget = this.getWidget(token);
                    if (widget == null) {
                        Log.log(7, this, "Widget " + token + " doesn't exists");
                        continue;
                    }
                    JComponent c = widget.getComponent();
                    ((Component)c).setBackground(bg);
                    ((Component)c).setForeground(fg);
                    this.box.add(c);
                    widget.update();
                    widget.propertiesChanged();
                    continue;
                }
                this.box.add(new JLabel(token));
            }
            this.currentBar = statusBar;
        }
        this.updateBufferStatus();
        this.updateMiscStatus();
    }

    public void addNotify() {
        super.addNotify();
        VFSManager.getIOThreadPool().addProgressListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        VFSManager.getIOThreadPool().removeProgressListener(this);
    }

    public void statusUpdate(final WorkThreadPool threadPool, int threadIndex) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (StatusBar.this.message != null && !"".equals(StatusBar.this.message.getText().trim()) && !StatusBar.this.currentMessageIsIO) {
                    return;
                }
                int requestCount = threadPool.getRequestCount();
                if (requestCount == 0) {
                    StatusBar.this.setMessageAndClear(jEdit.getProperty("view.status.io.done"));
                    StatusBar.this.currentMessageIsIO = true;
                } else if (requestCount == 1) {
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io-1"));
                    StatusBar.this.currentMessageIsIO = true;
                } else {
                    Object[] args = new Object[]{requestCount};
                    StatusBar.this.setMessage(jEdit.getProperty("view.status.io", args));
                    StatusBar.this.currentMessageIsIO = true;
                }
            }
        });
    }

    public void progressUpdate(WorkThreadPool threadPool, int threadIndex) {
    }

    public void setMessageAndClear(String message) {
        this.setMessage(message);
        this.tempTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (StatusBar.this.isShowing()) {
                    StatusBar.this.setMessage(null);
                }
            }
        });
        this.tempTimer.setInitialDelay(10000);
        this.tempTimer.setRepeats(false);
        this.tempTimer.start();
    }

    public void setMessage(String message) {
        if (this.tempTimer != null) {
            this.tempTimer.stop();
            this.tempTimer = null;
        }
        this.setMessageComponent(this.message);
        if (message == null) {
            if (this.view.getMacroRecorder() != null) {
                this.message.setText(jEdit.getProperty("view.status.recording"));
            } else {
                this.message.setText(" ");
            }
        } else {
            this.message.setText(message);
        }
    }

    public void setMessageComponent(Component comp) {
        this.currentMessageIsIO = false;
        if (comp == null || this.messageComp == comp) {
            return;
        }
        this.messageComp = comp;
        this.panel.add("Center", this.messageComp);
    }

    public void updateCaretStatus() {
        if (this.showCaretStatus) {
            Buffer buffer = this.view.getBuffer();
            if (!buffer.isLoaded() || buffer != this.view.getTextArea().getBuffer()) {
                this.caretStatus.setText(" ");
                return;
            }
            JEditTextArea textArea = this.view.getTextArea();
            int currLine = textArea.getCaretLine();
            if (currLine >= buffer.getLineCount()) {
                return;
            }
            int start = textArea.getLineStartOffset(currLine);
            int dot = textArea.getCaretPosition() - start;
            if (dot < 0) {
                return;
            }
            buffer.getText(start, dot, this.seg);
            int virtualPosition = StandardUtilities.getVirtualWidth(this.seg, buffer.getTabSize());
            this.buf.setLength(0);
            this.buf.append(Integer.toString(currLine + 1));
            this.buf.append(',');
            this.buf.append(Integer.toString(dot + 1));
            if (virtualPosition != dot) {
                this.buf.append('-');
                this.buf.append(Integer.toString(virtualPosition + 1));
            }
            this.buf.append(' ');
            int firstLine = textArea.getFirstLine();
            int visible = textArea.getVisibleLines();
            int lineCount = textArea.getDisplayManager().getScrollLineCount();
            if (visible >= lineCount) {
                this.buf.append("All");
            } else if (firstLine == 0) {
                this.buf.append("Top");
            } else if (firstLine + visible >= lineCount) {
                this.buf.append("Bot");
            } else {
                float percent = (float)firstLine / (float)lineCount * 100.0f;
                this.buf.append(Integer.toString((int)percent));
                this.buf.append('%');
            }
            this.caretStatus.setText(this.buf.toString());
        }
    }

    public void updateBufferStatus() {
        this.wrapWidget.update();
        this.lineSepWidget.update();
        this.modeWidget.update();
        this.foldWidget.update();
        this.encodingWidget.update();
    }

    public void updateMiscStatus() {
        this.multiSelectWidget.update();
        this.rectSelectWidget.update();
        this.overwriteWidget.update();
    }

    private Widget getWidget(String name) {
        if ("mode".equals(name)) {
            return this.modeWidget;
        }
        if ("fold".equals(name)) {
            return this.foldWidget;
        }
        if ("encoding".equals(name)) {
            return this.encodingWidget;
        }
        if ("wrap".equals(name)) {
            return this.wrapWidget;
        }
        if ("multiSelect".equals(name)) {
            return this.multiSelectWidget;
        }
        if ("rectSelect".equals(name)) {
            return this.rectSelectWidget;
        }
        if ("overwrite".equals(name)) {
            return this.overwriteWidget;
        }
        if ("lineSep".equals(name)) {
            return this.lineSepWidget;
        }
        return this._getWidget(name);
    }

    private Widget _getWidget(String name) {
        StatusWidgetFactory widgetFactory = (StatusWidgetFactory)ServiceManager.getService("org.gjt.sp.jedit.gui.statusbar.StatusWidget", name);
        if (widgetFactory == null) {
            Log.log(9, this, "Widget " + name + " doesn't exists");
            return null;
        }
        return widgetFactory.getWidget(this.view);
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            Object source = evt.getSource();
            if (source == StatusBar.this.caretStatus && evt.getClickCount() == 2) {
                StatusBar.this.view.getTextArea().showGoToLineDialog();
            }
        }
    }
}

