/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class KeyEventTranslator {
    protected static KeyEvent lastKeyPressEvent;
    protected static boolean lastKeyPressAccepted;
    private static final int[] MODS;
    static int c;
    static int a;
    static int m;
    static int s;
    private static final Map<Key, Key> transMap;

    public static void addTranslation(Key key1, Key key2) {
        transMap.put(key1, key2);
    }

    public static Key translateKeyEvent(KeyEvent evt) {
        Key key = KeyEventTranslator.translateKeyEvent2(evt);
        if (key != null && key.isPhantom()) {
            key = null;
        }
        return key;
    }

    public static Key translateKeyEvent2(KeyEvent evt) {
        Key returnValue;
        int modifiers = evt.getModifiers();
        switch (evt.getID()) {
            case 401: {
                int keyCode = evt.getKeyCode();
                if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
                    if (Debug.ALTERNATIVE_DISPATCHER) {
                        return null;
                    }
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), 0, Character.toLowerCase((char)keyCode));
                    break;
                }
                if (keyCode == 9) {
                    evt.consume();
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), keyCode, '\u0000');
                    break;
                }
                if (keyCode == 32) {
                    if ((modifiers & 0xFFFFFFFE) == 0) {
                        returnValue = null;
                        break;
                    }
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), 0, ' ');
                    break;
                }
                returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), keyCode, '\u0000');
                break;
            }
            case 400: {
                char ch = evt.getKeyChar();
                if (KeyEventWorkaround.isMacControl(evt)) {
                    ch = (char)(ch | 0x60);
                }
                switch (ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': {
                        return null;
                    }
                    case ' ': {
                        if ((modifiers & 0xFFFFFFFE) == 0) break;
                        return null;
                    }
                }
                int ignoreMods = Debug.ALT_KEY_PRESSED_DISABLED ? 41 : 33;
                if ((modifiers & 0x20) == 0 && evt.getWhen() - KeyEventWorkaround.lastKeyTime < 750L && (KeyEventWorkaround.modifiers & ~ignoreMods) != 0) {
                    if (Debug.ALTERNATIVE_DISPATCHER) {
                        returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), 0, ch);
                        break;
                    }
                    return null;
                }
                if (ch == ' ') {
                    returnValue = new Key(KeyEventTranslator.modifiersToString(modifiers), 0, ch);
                    break;
                }
                returnValue = new Key(null, 0, ch);
                break;
            }
            default: {
                return null;
            }
        }
        Key trans = transMap.get(returnValue);
        if (trans == null) {
            return returnValue;
        }
        return trans;
    }

    public static Key parseKey(String keyStroke) {
        int ch;
        String key;
        if (keyStroke == null) {
            return null;
        }
        int modifiers = 0;
        int endOfModifiers = keyStroke.indexOf(43);
        if (endOfModifiers <= 0) {
            key = keyStroke;
        } else {
            block8: for (int i = 0; i < endOfModifiers; ++i) {
                switch (Character.toUpperCase(keyStroke.charAt(i))) {
                    case 'A': {
                        modifiers |= a;
                        continue block8;
                    }
                    case 'C': {
                        modifiers |= c;
                        continue block8;
                    }
                    case 'M': {
                        modifiers |= m;
                        continue block8;
                    }
                    case 'S': {
                        modifiers |= s;
                    }
                }
            }
            key = keyStroke.substring(endOfModifiers + 1);
        }
        if (key.length() == 1) {
            return new Key(KeyEventTranslator.modifiersToString(modifiers), 0, key.charAt(0));
        }
        if (key.length() == 0) {
            Log.log(9, KeyEventTranslator.class, "Invalid key stroke: " + keyStroke);
            return null;
        }
        if (key.equals("SPACE")) {
            return new Key(KeyEventTranslator.modifiersToString(modifiers), 0, ' ');
        }
        try {
            ch = KeyEvent.class.getField("VK_".concat(key)).getInt(null);
        }
        catch (Exception e) {
            Log.log(9, KeyEventTranslator.class, "Invalid key stroke: " + keyStroke);
            return null;
        }
        return new Key(KeyEventTranslator.modifiersToString(modifiers), ch, '\u0000');
    }

    public static void setModifierMapping(int c, int a, int m, int s) {
        int duplicateMapping = c & a | c & m | c & s | a & m | a & s | m & s;
        if ((duplicateMapping & 2) != 0) {
            throw new IllegalArgumentException("CTRL is mapped to more than one modifier");
        }
        if ((duplicateMapping & 8) != 0) {
            throw new IllegalArgumentException("ALT is mapped to more than one modifier");
        }
        if ((duplicateMapping & 4) != 0) {
            throw new IllegalArgumentException("META is mapped to more than one modifier");
        }
        if ((duplicateMapping & 1) != 0) {
            throw new IllegalArgumentException("SHIFT is mapped to more than one modifier");
        }
        KeyEventTranslator.c = c;
        KeyEventTranslator.a = a;
        KeyEventTranslator.m = m;
        KeyEventTranslator.s = s;
    }

    public static char getSymbolicModifierName(int mod) {
        if ((mod & c) != 0) {
            return 'C';
        }
        if ((mod & a) != 0) {
            return 'A';
        }
        if ((mod & m) != 0) {
            return 'M';
        }
        if ((mod & s) != 0) {
            return 'S';
        }
        return '\u0000';
    }

    public static String modifiersToString(int mods) {
        StringBuffer buf = null;
        for (int i = 0; i < MODS.length; ++i) {
            if ((mods & MODS[i]) == 0) continue;
            buf = KeyEventTranslator.lazyAppend(buf, KeyEventTranslator.getSymbolicModifierName(MODS[i]));
        }
        if (buf == null) {
            return null;
        }
        return buf.toString();
    }

    public static String getModifierString(InputEvent evt) {
        StringBuilder buf = new StringBuilder();
        if (evt.isControlDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(2));
        }
        if (evt.isAltDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(8));
        }
        if (evt.isMetaDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(4));
        }
        if (evt.isShiftDown()) {
            buf.append(KeyEventTranslator.getSymbolicModifierName(1));
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    private static StringBuffer lazyAppend(StringBuffer buf, char ch) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        if (buf.indexOf(String.valueOf(ch)) == -1) {
            buf.append(ch);
        }
        return buf;
    }

    static {
        MODS = new int[]{2, 8, 4, 1};
        transMap = new HashMap<Key, Key>();
        if (OperatingSystem.isMacOS()) {
            KeyEventTranslator.setModifierMapping(4, 2, 8, 1);
        } else {
            KeyEventTranslator.setModifierMapping(2, 8, 4, 1);
        }
    }

    public static class Key {
        public final String modifiers;
        public final int key;
        public final char input;
        private final int hashCode;
        protected boolean isFromGlobalContext;
        protected boolean isPhantom;

        public Key(String modifiers, int key, char input) {
            this.modifiers = modifiers;
            this.key = key;
            this.input = input;
            this.hashCode = key + input;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                if (StandardUtilities.objectsEqual(this.modifiers, k.modifiers) && this.key == k.key && this.input == k.input) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return (this.modifiers == null ? "" : this.modifiers) + '<' + Integer.toString(this.key, 16) + ',' + Integer.toString(this.input, 16) + '>';
        }

        public void setIsFromGlobalContext(boolean to) {
            this.isFromGlobalContext = to;
        }

        public boolean isFromGlobalContext() {
            return this.isFromGlobalContext;
        }

        public void setIsPhantom(boolean to) {
            this.isPhantom = to;
        }

        public boolean isPhantom() {
            return this.isPhantom;
        }
    }
}

