/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryModelSaver;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEditHistoryModelSaver
implements HistoryModelSaver {
    private static final String TO_ESCAPE = "\r\n\t\\\"'[]";
    private static File history;
    private static long historyModTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, HistoryModel> load(Map<String, HistoryModel> models) {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            return models;
        }
        history = new File(MiscUtilities.constructPath(settingsDirectory, "history"));
        if (!history.exists()) {
            return models;
        }
        historyModTime = history.lastModified();
        Log.log(3, HistoryModel.class, "Loading history");
        if (models == null) {
            models = Collections.synchronizedMap(new HashMap());
        }
        BufferedReader in = null;
        try {
            try {
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(history), Charset.forName("UTF-8").newDecoder()));
                    models.putAll(JEditHistoryModelSaver.loadFromReader(in));
                }
                catch (CharacterCodingException e) {
                    in.close();
                    Log.log(3, HistoryModel.class, "Failed to load history with UTF-8. Fallbacking to the system default encoding.");
                    in = new BufferedReader(new FileReader(history));
                    models.putAll(JEditHistoryModelSaver.loadFromReader(in));
                }
                Object var6_7 = null;
            }
            catch (FileNotFoundException fnf) {
                Object var6_8 = null;
                IOUtilities.closeQuietly(in);
                return models;
            }
            catch (IOException io) {
                Log.log(9, HistoryModel.class, io);
                Object var6_9 = null;
                IOUtilities.closeQuietly(in);
                return models;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            IOUtilities.closeQuietly(in);
            throw throwable;
        }
        IOUtilities.closeQuietly(in);
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean save(Map<String, HistoryModel> models) {
        File file2;
        block8: {
            Log.log(3, HistoryModel.class, "Saving history");
            File file1 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "#history#save#"));
            file2 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "history"));
            if (file2.exists() && file2.lastModified() != historyModTime) {
                Log.log(7, HistoryModel.class, file2 + " changed on disk; will not save history");
                return false;
            }
            jEdit.backupSettingsFile(file2);
            String lineSep = System.getProperty("line.separator");
            BufferedWriter out = null;
            try {
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file1), "UTF-8"));
                    if (models != null) {
                        Collection<HistoryModel> values = models.values();
                        for (HistoryModel model : values) {
                            if (model.getSize() == 0) continue;
                            out.write(91);
                            out.write(StandardUtilities.charsToEscapes(model.getName(), TO_ESCAPE));
                            out.write(93);
                            out.write(lineSep);
                            for (int i = 0; i < model.getSize(); ++i) {
                                out.write(StandardUtilities.charsToEscapes(model.getItem(i), TO_ESCAPE));
                                out.write(lineSep);
                            }
                        }
                    }
                    out.close();
                    file2.delete();
                    file1.renameTo(file2);
                }
                catch (IOException io) {
                    Log.log(9, HistoryModel.class, io);
                    Object var11_12 = null;
                    IOUtilities.closeQuietly(out);
                    break block8;
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                IOUtilities.closeQuietly(out);
                throw throwable;
            }
            IOUtilities.closeQuietly(out);
        }
        historyModTime = file2.lastModified();
        return true;
    }

    private static Map<String, HistoryModel> loadFromReader(BufferedReader in) throws IOException {
        String line;
        HashMap<String, HistoryModel> result = new HashMap<String, HistoryModel>();
        HistoryModel currentModel = null;
        while ((line = in.readLine()) != null) {
            if (line.length() > 0 && line.charAt(0) == '[' && line.charAt(line.length() - 1) == ']') {
                if (currentModel != null) {
                    result.put(currentModel.getName(), currentModel);
                }
                String modelName = MiscUtilities.escapesToChars(line.substring(1, line.length() - 1));
                currentModel = new HistoryModel(modelName);
                continue;
            }
            if (currentModel == null) {
                throw new IOException("History data starts before model name");
            }
            currentModel.addElement(MiscUtilities.escapesToChars(line));
        }
        if (currentModel != null) {
            result.put(currentModel.getName(), currentModel);
        }
        return result;
    }
}

