/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.gui.CheckBoxListModel;

public class JCheckBoxList
extends JTable {
    private TableCellRenderer dummy;

    public JCheckBoxList(Object[] items) {
        this.setModel(items);
    }

    public JCheckBoxList(Vector items) {
        this.setModel(items);
    }

    public void setModel(Object[] items) {
        this.setModel(new CheckBoxListModel(items));
        this.init();
    }

    public void setModel(Vector items) {
        this.setModel(new CheckBoxListModel(items));
        this.init();
    }

    public Object[] getCheckedValues() {
        Vector<Object> values = new Vector<Object>();
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < model.items.size(); ++i) {
            Entry entry = model.items.get(i);
            if (!entry.checked || entry.caption) continue;
            values.add(entry.value);
        }
        Object[] retVal = new Object[values.size()];
        values.copyInto(retVal);
        return retVal;
    }

    public void selectAll() {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < model.items.size(); ++i) {
            Entry entry = model.items.elementAt(i);
            if (entry.caption) continue;
            entry.checked = true;
        }
        model.fireTableRowsUpdated(0, model.getRowCount());
    }

    public Entry[] getValues() {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        Object[] retVal = new Entry[model.items.size()];
        model.items.copyInto(retVal);
        return retVal;
    }

    public Object getSelectedValue() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.getModel().getValueAt(row, 1);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            Entry entry = ((CheckBoxListModel)this.getModel()).items.get(row);
            if (entry.caption) {
                return this.dummy;
            }
        }
        return super.getCellRenderer(row, column);
    }

    private void init() {
        this.dummy = new DummyRenderer();
        this.getSelectionModel().setSelectionMode(0);
        this.setShowGrid(false);
        this.setAutoResizeMode(3);
        TableColumn column = this.getColumnModel().getColumn(0);
        int checkBoxWidth = new JCheckBox().getPreferredSize().width;
        column.setPreferredWidth(checkBoxWidth);
        column.setMinWidth(checkBoxWidth);
        column.setWidth(checkBoxWidth);
        column.setMaxWidth(checkBoxWidth);
        column.setResizable(false);
        column = this.getColumnModel().getColumn(1);
        column.setCellRenderer(new LabelRenderer());
    }

    private class LabelRenderer
    extends DefaultTableCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont = this.plainFont.deriveFont(1);

        LabelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Entry entry = ((CheckBoxListModel)JCheckBoxList.this.getModel()).items.get(row);
            if (entry.caption) {
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.plainFont);
            }
            return this;
        }
    }

    private class DummyRenderer
    extends DefaultTableCellRenderer {
        private DummyRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, null, isSelected, false, row, column);
        }
    }

    public static class Entry {
        boolean checked;
        boolean caption;
        Object value;

        public Entry(Object value) {
            this.caption = true;
            this.value = value;
        }

        public Entry(boolean checked, Object value) {
            this.checked = checked;
            this.value = value;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

