/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.WorkThread;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class IOProgressMonitor
extends JPanel {
    private JLabel caption = new JLabel();
    private ThreadProgress[] threads;
    private WorkThreadHandler workThreadHandler;

    public IOProgressMonitor() {
        super(new BorderLayout());
        this.updateCaption();
        this.add("North", this.caption);
        this.threads = new ThreadProgress[VFSManager.getIOThreadPool().getThreadCount()];
        Box box = new Box(1);
        for (int i = 0; i < this.threads.length; ++i) {
            if (i != 0) {
                box.add(Box.createVerticalStrut(6));
            }
            this.threads[i] = new ThreadProgress(i);
            box.add(this.threads[i]);
        }
        JPanel threadPanel = new JPanel(new BorderLayout());
        threadPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        threadPanel.add("North", box);
        this.add("Center", new JScrollPane(threadPanel));
        this.workThreadHandler = new WorkThreadHandler();
    }

    public void addNotify() {
        VFSManager.getIOThreadPool().addProgressListener(this.workThreadHandler);
        super.addNotify();
    }

    public void removeNotify() {
        VFSManager.getIOThreadPool().removeProgressListener(this.workThreadHandler);
        super.removeNotify();
    }

    private void updateCaption() {
        Object[] args = new String[]{String.valueOf(VFSManager.getIOThreadPool().getRequestCount())};
        this.caption.setText(jEdit.getProperty("io-progress-monitor.caption", args));
    }

    class ThreadProgress
    extends JPanel {
        private int index;
        private JProgressBar progress;
        private JButton abort;

        public ThreadProgress(int index) {
            super(new BorderLayout(12, 12));
            this.index = index;
            Box box = new Box(1);
            box.add(Box.createGlue());
            this.progress = new JProgressBar();
            box.add(this.progress);
            this.progress.setStringPainted(true);
            box.add(Box.createGlue());
            this.add("Center", box);
            this.abort = new JButton(jEdit.getProperty("io-progress-monitor.abort"));
            this.abort.addActionListener(new ActionHandler());
            this.add("East", this.abort);
            this.update();
        }

        public void update() {
            WorkThread thread = VFSManager.getIOThreadPool().getThread(this.index);
            if (thread.isRequestRunning()) {
                if (this.progress.isIndeterminate()) {
                    if (thread.getProgressMaximum() != 0) {
                        this.progress.setIndeterminate(false);
                    }
                } else if (thread.getProgressMaximum() == 0) {
                    this.progress.setIndeterminate(true);
                }
                this.abort.setEnabled(true);
                String status = thread.getStatus();
                if (status == null) {
                    status = "";
                }
                this.progress.setString(status);
                this.progress.setMaximum(thread.getProgressMaximum());
                this.progress.setValue(thread.getProgressValue());
            } else {
                this.abort.setEnabled(false);
                this.progress.setString(jEdit.getProperty("io-progress-monitor.idle"));
                this.progress.setIndeterminate(false);
                this.progress.setValue(0);
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent evt) {
                int result;
                if (evt.getSource() == ThreadProgress.this.abort && (result = GUIUtilities.confirm(IOProgressMonitor.this, "abort", null, 0, 3)) == 0) {
                    VFSManager.getIOThreadPool().getThread(ThreadProgress.this.index).abortCurrentRequest();
                }
            }
        }
    }

    class WorkThreadHandler
    implements WorkThreadProgressListener {
        WorkThreadHandler() {
        }

        public void statusUpdate(WorkThreadPool threadPool, final int threadIndex) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IOProgressMonitor.this.updateCaption();
                    IOProgressMonitor.this.threads[threadIndex].update();
                }
            });
        }

        public void progressUpdate(WorkThreadPool threadPool, final int threadIndex) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IOProgressMonitor.this.updateCaption();
                    IOProgressMonitor.this.threads[threadIndex].update();
                }
            });
        }
    }
}

