/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryText;

public class HistoryTextField
extends JTextField {
    private HistoryText controller = new HistoryText(this, null){

        public void fireActionPerformed() {
            HistoryTextField.this.fireActionPerformed();
        }
    };
    private boolean enterAddsToHistory;
    private boolean selectAllOnFocus;

    public HistoryTextField() {
        this(null);
    }

    public HistoryTextField(String name) {
        this(name, false, true);
    }

    public HistoryTextField(String name, boolean instantPopups) {
        this(name, instantPopups, true);
    }

    public HistoryTextField(String name, boolean instantPopups, boolean enterAddsToHistory) {
        this.setModel(name);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setInstantPopups(instantPopups);
        this.setEnterAddsToHistory(enterAddsToHistory);
    }

    public void setInstantPopups(boolean instantPopups) {
        this.controller.setInstantPopups(instantPopups);
    }

    public boolean getInstantPopups() {
        return this.controller.getInstantPopups();
    }

    public void setEnterAddsToHistory(boolean enterAddsToHistory) {
        this.enterAddsToHistory = enterAddsToHistory;
    }

    public boolean setEnterAddsToHistory() {
        return this.enterAddsToHistory;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }

    public boolean setSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public HistoryModel getModel() {
        return this.controller.getModel();
    }

    public void setModel(String name) {
        this.controller.setModel(name);
        if (name != null) {
            this.setBorder(new CompoundBorder(this.getBorder(), new HistoryBorder()));
        }
        this.repaint();
    }

    public void addCurrentToHistory() {
        this.controller.addCurrentToHistory();
    }

    public void setText(String text) {
        super.setText(text);
        this.controller.setIndex(-1);
    }

    public void fireActionPerformed() {
        super.fireActionPerformed();
    }

    protected void processKeyEvent(KeyEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        if (evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 10: {
                    if (this.enterAddsToHistory) {
                        this.addCurrentToHistory();
                    }
                    if (evt.getModifiers() != 0) break;
                    this.fireActionPerformed();
                    evt.consume();
                    break;
                }
                case 38: {
                    if (evt.isShiftDown()) {
                        this.controller.doBackwardSearch();
                    } else {
                        this.controller.historyPrevious();
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    if (evt.isShiftDown()) {
                        this.controller.doForwardSearch();
                    } else if (evt.isAltDown()) {
                        this.controller.showPopupMenu(evt.isShiftDown());
                    } else {
                        this.controller.historyNext();
                    }
                    evt.consume();
                    break;
                }
                case 9: {
                    if (!evt.isControlDown()) break;
                    this.controller.doBackwardSearch();
                    evt.consume();
                }
            }
        }
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    protected void processMouseEvent(MouseEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        switch (evt.getID()) {
            case 501: {
                Border border = this.getBorder();
                Insets insets = border.getBorderInsets(this);
                if (evt.getX() >= this.getWidth() - insets.right || GUIUtilities.isPopupTrigger(evt)) {
                    this.controller.showPopupMenu(evt.isShiftDown());
                    break;
                }
                super.processMouseEvent(evt);
                break;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                super.processMouseEvent(evt);
                break;
            }
            default: {
                super.processMouseEvent(evt);
            }
        }
    }

    static class HistoryBorder
    extends AbstractBorder {
        static final int WIDTH = 16;

        HistoryBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x + w - 16, y - 1);
            int w2 = 8;
            int h2 = h / 2;
            g.setColor(UIManager.getColor(c.isEnabled() && ((HistoryTextField)c).getModel() != null ? "TextField.foreground" : "TextField.disabledForeground"));
            g.drawLine(w2 - 5, h2 - 2, w2 + 4, h2 - 2);
            g.drawLine(w2 - 4, h2 - 1, w2 + 3, h2 - 1);
            g.drawLine(w2 - 3, h2, w2 + 2, h2);
            g.drawLine(w2 - 2, h2 + 1, w2 + 1, h2 + 1);
            g.drawLine(w2 - 1, h2 + 2, w2, h2 + 2);
            g.translate(-(x + w - 16), -(y - 1));
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 16);
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        boolean selectAll;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            this.selectAll = !HistoryTextField.this.hasFocus() && HistoryTextField.this.selectAllOnFocus;
        }

        public void mouseReleased(MouseEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MouseHandler.this.selectAll) {
                        HistoryTextField.this.selectAll();
                    }
                }
            });
        }

        public void mouseMoved(MouseEvent evt) {
            Border border = HistoryTextField.this.getBorder();
            Insets insets = border.getBorderInsets(HistoryTextField.this);
            if (evt.getX() >= HistoryTextField.this.getWidth() - insets.right) {
                HistoryTextField.this.setCursor(Cursor.getDefaultCursor());
            } else {
                HistoryTextField.this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }

        public void mouseDragged(MouseEvent evt) {
            this.selectAll = false;
        }
    }
}

