/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.TreeSet;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryText;

public class HistoryTextArea
extends JTextArea {
    private HistoryText controller;

    public HistoryTextArea(String name) {
        super(3, 15);
        this.controller = new HistoryText(this, name);
        TreeSet<KeyStroke> focusForwardTraversalKeys = new TreeSet<KeyStroke>();
        focusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        TreeSet<KeyStroke> focusBackwardTraversalKeys = new TreeSet<KeyStroke>();
        focusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        this.setFocusTraversalKeys(0, focusForwardTraversalKeys);
        this.setFocusTraversalKeys(1, focusBackwardTraversalKeys);
    }

    public HistoryModel getModel() {
        return this.controller.getModel();
    }

    public void setModel(String name) {
        this.controller.setModel(name);
    }

    public void setInstantPopups(boolean instantPopups) {
        this.controller.setInstantPopups(instantPopups);
    }

    public boolean getInstantPopups() {
        return this.controller.getInstantPopups();
    }

    public void addCurrentToHistory() {
        this.controller.addCurrentToHistory();
    }

    public void setText(String text) {
        super.setText(text);
        this.controller.setIndex(-1);
    }

    protected void processKeyEvent(KeyEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        if (evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 10: {
                    if (!evt.isControlDown()) break;
                    this.replaceSelection("\n");
                    evt.consume();
                    break;
                }
                case 9: {
                    if (!evt.isControlDown()) break;
                    this.replaceSelection("\t");
                    evt.consume();
                    break;
                }
                case 33: {
                    if (evt.isShiftDown()) {
                        this.controller.doBackwardSearch();
                    } else {
                        this.controller.historyPrevious();
                    }
                    evt.consume();
                    break;
                }
                case 34: {
                    if (evt.isShiftDown()) {
                        this.controller.doForwardSearch();
                    } else {
                        this.controller.historyNext();
                    }
                    evt.consume();
                    break;
                }
                case 38: {
                    if (!evt.isAltDown()) break;
                    this.controller.showPopupMenu(evt.isShiftDown());
                    evt.consume();
                }
            }
        }
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    protected void processMouseEvent(MouseEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        switch (evt.getID()) {
            case 501: {
                if (GUIUtilities.isPopupTrigger(evt)) {
                    this.controller.showPopupMenu(evt.isShiftDown());
                    break;
                }
                super.processMouseEvent(evt);
                break;
            }
            default: {
                super.processMouseEvent(evt);
            }
        }
    }
}

