/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class EnhancedButton
extends RolloverButton {
    private String action;

    public EnhancedButton(Icon icon, String toolTip, String action, ActionContext context) {
        super(icon);
        this.action = action;
        if (action != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(context, action));
            this.addMouseListener(new MouseHandler());
        } else {
            this.setEnabled(false);
        }
        this.setToolTipText(toolTip);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    class MouseHandler
    extends MouseAdapter {
        boolean msgSet = false;

        MouseHandler() {
        }

        public void mouseReleased(MouseEvent evt) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }

        public void mouseEntered(MouseEvent evt) {
            String msg = jEdit.getProperty(EnhancedButton.this.action + ".mouse-over");
            if (msg != null) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(msg);
                this.msgSet = true;
            }
        }

        public void mouseExited(MouseEvent evt) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }
    }
}

