/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.jEdit;

public class BufferSwitcher
extends JComboBox {
    private EditPane editPane;
    private boolean updating;

    public BufferSwitcher(final EditPane editPane) {
        this.editPane = editPane;
        this.setRenderer(new BufferCellRenderer());
        this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        this.addActionListener(new ActionHandler());
        this.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                editPane.getTextArea().requestFocus();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                editPane.getTextArea().requestFocus();
            }
        });
    }

    public void updateBufferList() {
        BufferSet bufferSet = this.editPane.getBufferSet();
        if (bufferSet.size() == 0) {
            return;
        }
        this.updating = true;
        this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        this.setModel(new DefaultComboBoxModel<Buffer>(bufferSet.getAllBuffers()));
        this.setSelectedItem(this.editPane.getBuffer());
        this.setToolTipText(this.editPane.getBuffer().getPath());
        this.updating = false;
    }

    class BufferCellRenderer
    extends DefaultListCellRenderer {
        BufferCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Buffer buffer = (Buffer)value;
            if (buffer == null) {
                this.setIcon(null);
            } else {
                this.setIcon(buffer.getIcon());
                this.setToolTipText(buffer.getPath());
            }
            return this;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Buffer buffer;
            if (!BufferSwitcher.this.updating && (buffer = (Buffer)BufferSwitcher.this.getSelectedItem()) != null) {
                BufferSwitcher.this.editPane.setBuffer(buffer);
            }
        }
    }
}

