/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.ContextAddDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public abstract class AbstractContextOptionPane
extends AbstractOptionPane {
    private DefaultListModel listModel;
    private JList list;
    private JButton add;
    private JButton remove;
    private JButton moveUp;
    private JButton moveDown;
    private JButton reset;
    private JLabel caption;
    private JPanel buttons;

    protected AbstractContextOptionPane(String name, String caption) {
        super(name);
        this.caption = new JLabel(caption);
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        this.add("North", this.caption);
        this.listModel = new DefaultListModel();
        this.reloadContextList(this.getContextMenu());
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListHandler());
        this.add("Center", new JScrollPane(this.list));
        this.buttons = new JPanel();
        this.buttons.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.buttons.setLayout(new BoxLayout(this.buttons, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.add.icon")));
        this.add.setToolTipText(jEdit.getProperty("common.add"));
        this.add.addActionListener(actionHandler);
        this.buttons.add(this.add);
        this.buttons.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.remove.icon")));
        this.remove.setToolTipText(jEdit.getProperty("common.remove"));
        this.remove.addActionListener(actionHandler);
        this.buttons.add(this.remove);
        this.buttons.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.moveUp.icon")));
        this.moveUp.setToolTipText(jEdit.getProperty("common.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        this.buttons.add(this.moveUp);
        this.buttons.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.moveDown.icon")));
        this.moveDown.setToolTipText(jEdit.getProperty("common.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        this.buttons.add(this.moveDown);
        this.buttons.add(Box.createGlue());
        this.reset = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.context.reset.icon")));
        this.reset.setToolTipText(jEdit.getProperty("options.context.reset"));
        this.reset.addActionListener(actionHandler);
        this.buttons.add(this.reset);
        this.updateButtons();
        this.add("South", this.buttons);
    }

    protected abstract String getContextMenu();

    protected abstract void saveContextMenu(String var1);

    protected void addButton(JComponent c) {
        this.buttons.add(c);
    }

    protected void _save() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                buf.append(' ');
            }
            buf.append(((MenuItem)this.listModel.elementAt((int)i)).actionName);
        }
        this.saveContextMenu(buf.toString());
    }

    private void updateButtons() {
        int index = this.list.getSelectedIndex();
        this.remove.setEnabled(index != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(index > 0);
        this.moveDown.setEnabled(index != -1 && index != this.listModel.getSize() - 1);
    }

    private void reloadContextList(String contextMenu) {
        this.listModel.clear();
        StringTokenizer st = new StringTokenizer(contextMenu);
        while (st.hasMoreTokens()) {
            String label;
            String actionName = st.nextToken();
            if (actionName.equals("-")) {
                this.listModel.addElement(new MenuItem("-", "-"));
                continue;
            }
            EditAction action = jEdit.getAction(actionName);
            if (action == null || (label = action.getLabel()) == null) continue;
            this.listModel.addElement(new MenuItem(actionName, label));
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            AbstractContextOptionPane.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == AbstractContextOptionPane.this.add) {
                ContextAddDialog dialog = new ContextAddDialog(AbstractContextOptionPane.this);
                String selection = dialog.getSelection();
                if (selection == null) {
                    return;
                }
                int index = AbstractContextOptionPane.this.list.getSelectedIndex();
                index = index == -1 ? AbstractContextOptionPane.this.listModel.getSize() : ++index;
                MenuItem menuItem = selection.equals("-") ? new MenuItem("-", "-") : new MenuItem(selection, jEdit.getAction(selection).getLabel());
                AbstractContextOptionPane.this.listModel.insertElementAt(menuItem, index);
                AbstractContextOptionPane.this.list.setSelectedIndex(index);
                AbstractContextOptionPane.this.list.ensureIndexIsVisible(index);
            } else if (source == AbstractContextOptionPane.this.remove) {
                int index = AbstractContextOptionPane.this.list.getSelectedIndex();
                AbstractContextOptionPane.this.listModel.removeElementAt(index);
                if (AbstractContextOptionPane.this.listModel.getSize() != 0) {
                    AbstractContextOptionPane.this.list.setSelectedIndex(Math.min(AbstractContextOptionPane.this.listModel.getSize() - 1, index));
                }
                AbstractContextOptionPane.this.updateButtons();
            } else if (source == AbstractContextOptionPane.this.moveUp) {
                int index = AbstractContextOptionPane.this.list.getSelectedIndex();
                Object selected = AbstractContextOptionPane.this.list.getSelectedValue();
                AbstractContextOptionPane.this.listModel.removeElementAt(index);
                AbstractContextOptionPane.this.listModel.insertElementAt(selected, index - 1);
                AbstractContextOptionPane.this.list.setSelectedIndex(index - 1);
                AbstractContextOptionPane.this.list.ensureIndexIsVisible(index - 1);
            } else if (source == AbstractContextOptionPane.this.moveDown) {
                int index = AbstractContextOptionPane.this.list.getSelectedIndex();
                Object selected = AbstractContextOptionPane.this.list.getSelectedValue();
                AbstractContextOptionPane.this.listModel.removeElementAt(index);
                AbstractContextOptionPane.this.listModel.insertElementAt(selected, index + 1);
                AbstractContextOptionPane.this.list.setSelectedIndex(index + 1);
                AbstractContextOptionPane.this.list.ensureIndexIsVisible(index + 1);
            } else if (source == AbstractContextOptionPane.this.reset) {
                String dialogType = "options.context.reset.dialog";
                int result = GUIUtilities.confirm(AbstractContextOptionPane.this.list, dialogType, null, 0, 2);
                if (result == 0) {
                    String orgContext = jEdit.getProperty("view.context");
                    jEdit.resetProperty("view.context");
                    String defaultContext = jEdit.getProperty("view.context");
                    jEdit.setProperty("view.context", orgContext);
                    AbstractContextOptionPane.this.reloadContextList(defaultContext);
                    AbstractContextOptionPane.this.list.setSelectedIndex(0);
                    AbstractContextOptionPane.this.list.ensureIndexIsVisible(0);
                    AbstractContextOptionPane.this.updateButtons();
                }
            }
        }
    }

    static class MenuItem {
        String actionName;
        String label;

        MenuItem(String actionName, String label) {
            this.actionName = actionName;
            this.label = GUIUtilities.prettifyMenuLabel(label);
        }

        public String toString() {
            return this.label;
        }
    }

    static class MenuItemCompare
    implements Comparator {
        MenuItemCompare() {
        }

        public int compare(Object obj1, Object obj2) {
            return StandardUtilities.compareStrings(((MenuItem)obj1).label, ((MenuItem)obj2).label, true);
        }
    }
}

