/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class BufferSet {
    private final List<Buffer> buffers = Collections.synchronizedList(new ArrayList());
    private EventListenerList listeners = new EventListenerList();
    private final Scope scope;
    private static final Comparator<Buffer> nameSorter = new NameSorter();
    private static final Comparator<Buffer> pathSorter = new PathSorter();
    private boolean sorted;
    private Comparator<Buffer> comparator;

    BufferSet(Scope scope) {
        this.scope = scope;
        this.sorted = jEdit.getBooleanProperty("sortBuffers");
        if (this.sorted) {
            this.comparator = jEdit.getBooleanProperty("sortByName") ? nameSorter : pathSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBufferAt(Buffer buffer, int position) {
        Log.log(1, this, this.hashCode() + " addBufferAt(" + buffer + ',' + position + ')');
        Buffer untitledBuffer = null;
        List<Buffer> list = this.buffers;
        synchronized (list) {
            Buffer buf;
            if (this.buffers.size() == 1 && (buf = this.buffers.get(0)).isUntitled() && !buf.isDirty()) {
                untitledBuffer = buf;
            }
            if (this.sorted) {
                if (this.buffers.contains(buffer)) {
                    return;
                }
                this.buffers.add(buffer);
                Collections.sort(this.buffers, this.comparator);
                position = this.buffers.indexOf(buffer);
            } else {
                int oldPos = this.buffers.indexOf(buffer);
                if (oldPos != -1) {
                    if (position == -1) {
                        return;
                    }
                    this.moveBuffer(oldPos, position);
                    return;
                }
                int size = this.buffers.size();
                if (position == -1 || position > size) {
                    position = size;
                }
                this.buffers.add(position, buffer);
            }
        }
        BufferSetListener[] listeners = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
        Log.log(1, this, this.hashCode() + ": Buffer added " + buffer + " at " + position);
        for (BufferSetListener listener : listeners) {
            listener.bufferAdded(buffer, position);
        }
        if (untitledBuffer != null) {
            jEdit.getBufferSetManager().removeBuffer(this, untitledBuffer);
        }
    }

    public Buffer getBuffer(int index) {
        return this.buffers.get(index);
    }

    public Scope getScope() {
        return this.scope;
    }

    public Buffer getPreviousBuffer(int index) {
        if (this.buffers.isEmpty()) {
            return null;
        }
        if (this.buffers.size() < 2) {
            return this.buffers.get(0);
        }
        if (index <= 0) {
            return this.buffers.get(this.buffers.size() - 1);
        }
        return this.buffers.get(index - 1);
    }

    public Buffer getNextBuffer(int index) {
        if (this.buffers.isEmpty()) {
            return null;
        }
        if (this.buffers.size() < 2) {
            return this.buffers.get(this.buffers.size() - 1);
        }
        if (index >= this.buffers.size() - 1) {
            return this.buffers.get(0);
        }
        return this.buffers.get(index + 1);
    }

    public int indexOf(Buffer buffer) {
        return this.buffers.indexOf(buffer);
    }

    public int size() {
        return this.buffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllBuffers(BufferSetListener listener) {
        List<Buffer> list = this.buffers;
        synchronized (list) {
            for (int i = 0; i < this.buffers.size(); ++i) {
                Buffer buffer = this.buffers.get(i);
                Log.log(1, this, this.hashCode() + ": Buffer added " + buffer + " at " + i);
                listener.bufferAdded(buffer, i);
            }
        }
    }

    public Buffer[] getAllBuffers() {
        Buffer[] buffers = new Buffer[this.buffers.size()];
        return this.buffers.toArray(buffers);
    }

    public void addBufferSetListener(BufferSetListener listener) {
        Log.log(1, this, this.hashCode() + ": addBufferSetListener " + listener);
        this.listeners.add(BufferSetListener.class, listener);
    }

    public void removeBufferSetListener(BufferSetListener listener) {
        Log.log(1, this, this.hashCode() + ": removeBufferSetListener " + listener);
        this.listeners.remove(BufferSetListener.class, listener);
        if (!this.hasListeners()) {
            Buffer[] buffers = this.getAllBuffers();
            BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
            for (Buffer buffer : buffers) {
                bufferSetManager.removeBuffer(this, buffer);
            }
        }
    }

    public boolean hasListeners() {
        return this.listeners.getListenerCount() != 0;
    }

    public String toString() {
        return "BufferSet[" + (Object)((Object)this.scope) + ",nbBuffers=" + this.size() + ']';
    }

    void copy(BufferSet copy) {
        this.buffers.addAll(copy.buffers);
    }

    void addBuffer(Buffer buffer) {
        this.addBufferAt(buffer, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveBuffer(int oldPosition, int newPosition) {
        Buffer buffer;
        if (this.sorted) {
            return;
        }
        List<Buffer> list = this.buffers;
        synchronized (list) {
            buffer = this.buffers.remove(oldPosition);
            int size = this.buffers.size();
            if (newPosition == -1 || newPosition > size) {
                newPosition = size;
            }
            this.buffers.add(newPosition, buffer);
        }
        BufferSetListener[] listeners = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
        Log.log(1, this, this.hashCode() + ": Buffer moved " + buffer + " from " + oldPosition + " to " + newPosition);
        for (BufferSetListener listener : listeners) {
            listener.bufferMoved(buffer, oldPosition, newPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBuffer(Buffer buffer) {
        int index;
        List<Buffer> list = this.buffers;
        synchronized (list) {
            index = this.buffers.indexOf(buffer);
            if (index == -1) {
                return;
            }
            this.buffers.remove(index);
        }
        BufferSetListener[] listeners = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
        Log.log(1, this, this.hashCode() + ": Buffer removed " + buffer);
        for (BufferSetListener listener : listeners) {
            listener.bufferRemoved(buffer, index);
        }
    }

    void clear() {
        this.buffers.clear();
        BufferSetListener[] listeners = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
        Log.log(1, this, this.hashCode() + ": Buffer clear");
        for (BufferSetListener listener : listeners) {
            listener.bufferCleared();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathSorter
    implements Comparator<Buffer> {
        private PathSorter() {
        }

        @Override
        public int compare(Buffer o1, Buffer o2) {
            return StandardUtilities.compareStrings(o1.getPath(), o2.getPath(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameSorter
    implements Comparator<Buffer> {
        private NameSorter() {
        }

        @Override
        public int compare(Buffer o1, Buffer o2) {
            int ret = StandardUtilities.compareStrings(o1.getName(), o2.getName(), true);
            if (ret == 0) {
                ret = StandardUtilities.compareStrings(o1.getPath(), o2.getPath(), true);
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        global,
        view,
        editpane;


        public static Scope fromString(String s) {
            Scope[] scopes;
            for (Scope scope : scopes = Scope.values()) {
                if (!scope.toString().equals(s)) continue;
                return scope;
            }
            return global;
        }
    }
}

