/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

public class MarkersSaveRequest
extends WorkRequest {
    public static final String ERROR_OCCURRED = "MarkersSaveRequest__error";
    protected View view;
    protected Buffer buffer;
    protected Object session;
    protected VFS vfs;
    protected String path;
    protected String markersPath;

    public MarkersSaveRequest(View view, Buffer buffer, Object session, VFS vfs, String path) {
        this.view = view;
        this.buffer = buffer;
        this.session = session;
        this.vfs = vfs;
        this.path = path;
        this.markersPath = Buffer.getMarkersPath(vfs, path);
    }

    public void run() {
        OutputStream out = null;
        try {
            this.setAbortable(true);
            try {
                if ((this.vfs.getCapabilities() & 8) != 0) {
                    if (this.buffer.getMarkers().isEmpty()) {
                        this.vfs._delete(this.session, this.markersPath, this.view);
                    } else {
                        Object[] args = new String[]{this.vfs.getFileName(this.path)};
                        this.setStatus(jEdit.getProperty("vfs.status.save-markers", args));
                        this.setValue(0L);
                        out = this.vfs._createOutputStream(this.session, this.markersPath, this.view);
                        if (out != null) {
                            this.writeMarkers(out);
                        }
                    }
                }
            }
            catch (IOException io) {
                Log.log(9, this, io);
                this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
            }
        }
        catch (WorkThread.Abort a) {
            IOUtilities.closeQuietly(out);
            this.buffer.setBooleanProperty(ERROR_OCCURRED, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMarkers(OutputStream out) throws IOException {
        BufferedWriter o = new BufferedWriter(new OutputStreamWriter(out));
        try {
            Vector<Marker> markers = this.buffer.getMarkers();
            for (int i = 0; i < markers.size(); ++i) {
                Marker marker = (Marker)markers.get(i);
                ((Writer)o).write(33);
                ((Writer)o).write(marker.getShortcut());
                ((Writer)o).write(59);
                String pos = String.valueOf(marker.getPosition());
                o.write(pos);
                ((Writer)o).write(59);
                o.write(pos);
                ((Writer)o).write(10);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ((Writer)o).close();
            throw throwable;
        }
        ((Writer)o).close();
    }
}

