/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.util.Log;

public class UndoManager {
    private JEditBuffer buffer;
    private Edit undosFirst;
    private Edit undosLast;
    private Edit redosFirst;
    private Edit redosLast;
    private int limit;
    private int undoCount;
    private int compoundEditCount;
    private CompoundEdit compoundEdit;
    private Edit undoClearDirty;
    private Edit redoClearDirty;

    public UndoManager(JEditBuffer buffer) {
        this.buffer = buffer;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void clear() {
        this.redosLast = null;
        this.redosFirst = null;
        this.undosLast = null;
        this.undosFirst = null;
        this.undoCount = 0;
    }

    public int undo() {
        if (this.insideCompoundEdit()) {
            throw new InternalError("Unbalanced begin/endCompoundEdit()");
        }
        if (this.undosLast == null) {
            return -1;
        }
        --this.undoCount;
        int caret = this.undosLast.undo();
        this.redosFirst = this.undosLast;
        this.undosLast = this.undosLast.prev;
        if (this.undosLast == null) {
            this.undosFirst = null;
        }
        return caret;
    }

    public int redo() {
        if (this.insideCompoundEdit()) {
            throw new InternalError("Unbalanced begin/endCompoundEdit()");
        }
        if (this.redosFirst == null) {
            return -1;
        }
        ++this.undoCount;
        int caret = this.redosFirst.redo();
        this.undosLast = this.redosFirst;
        if (this.undosFirst == null) {
            this.undosFirst = this.undosLast;
        }
        this.redosFirst = this.redosFirst.next;
        return caret;
    }

    public void beginCompoundEdit() {
        if (this.compoundEditCount == 0) {
            this.compoundEdit = new CompoundEdit();
        }
        ++this.compoundEditCount;
    }

    public void endCompoundEdit() {
        if (this.compoundEditCount == 0) {
            Log.log(7, this, new Exception("Unbalanced begin/endCompoundEdit()"));
            return;
        }
        if (this.compoundEditCount == 1) {
            if (this.compoundEdit.first != null) {
                if (this.compoundEdit.first == this.compoundEdit.last) {
                    this.addEdit(this.compoundEdit.first);
                } else {
                    this.addEdit(this.compoundEdit);
                }
            }
            this.compoundEdit = null;
        }
        --this.compoundEditCount;
    }

    public boolean insideCompoundEdit() {
        return this.compoundEditCount != 0;
    }

    public void contentInserted(int offset, int length, String text, boolean clearDirty) {
        Insert ins;
        Edit last = this.getLastEdit();
        Edit toMerge = this.getMergeEdit();
        if (!clearDirty && toMerge instanceof Insert && this.redosFirst == null) {
            ins = (Insert)toMerge;
            if (ins.offset == offset) {
                ins.str = text.concat(ins.str);
                ins.length += length;
                return;
            }
            if (ins.offset + ins.length == offset) {
                ins.str = ins.str.concat(text);
                ins.length += length;
                return;
            }
        }
        ins = new Insert(this, offset, length, text);
        if (clearDirty) {
            this.redoClearDirty = last;
            this.undoClearDirty = ins;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.add(ins);
        } else {
            this.addEdit(ins);
        }
    }

    public void contentRemoved(int offset, int length, String text, boolean clearDirty) {
        Remove rem;
        Edit last = this.getLastEdit();
        Edit toMerge = this.getMergeEdit();
        if (!clearDirty && toMerge instanceof Remove && this.redosFirst == null) {
            rem = (Remove)toMerge;
            if (rem.offset == offset) {
                rem.str = rem.str.concat(text);
                rem.hashcode = rem.str.hashCode();
                rem.length += length;
                KillRing.getInstance().changed(rem);
                return;
            }
            if (offset + length == rem.offset) {
                rem.str = text.concat(rem.str);
                rem.hashcode = rem.str.hashCode();
                rem.length += length;
                rem.offset = offset;
                KillRing.getInstance().changed(rem);
                return;
            }
        }
        rem = new Remove(this, offset, length, text);
        if (clearDirty) {
            this.redoClearDirty = last;
            this.undoClearDirty = rem;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.add(rem);
        } else {
            this.addEdit(rem);
        }
        KillRing.getInstance().add(rem);
    }

    public void resetClearDirty() {
        this.redoClearDirty = this.getLastEdit();
        this.undoClearDirty = this.redosFirst instanceof CompoundEdit ? ((CompoundEdit)this.redosFirst).first : this.redosFirst;
    }

    private void addEdit(Edit edit) {
        if (this.undosFirst == null) {
            this.undosFirst = this.undosLast = edit;
        } else {
            this.undosLast.next = edit;
            edit.prev = this.undosLast;
            this.undosLast = edit;
        }
        this.redosLast = null;
        this.redosFirst = null;
        ++this.undoCount;
        while (this.undoCount > this.limit) {
            --this.undoCount;
            if (this.undosFirst == this.undosLast) {
                this.undosLast = null;
                this.undosFirst = null;
                continue;
            }
            this.undosFirst.next.prev = null;
            this.undosFirst = this.undosFirst.next;
        }
    }

    private Edit getMergeEdit() {
        Edit last = this.getLastEdit();
        return this.compoundEdit != null ? this.compoundEdit.last : last;
    }

    private Edit getLastEdit() {
        if (this.undosLast instanceof CompoundEdit) {
            return ((CompoundEdit)this.undosLast).last;
        }
        return this.undosLast;
    }

    static class CompoundEdit
    extends Edit {
        Edit first;
        Edit last;

        CompoundEdit() {
        }

        public int undo() {
            int retVal = -1;
            Edit edit = this.last;
            while (edit != null) {
                retVal = edit.undo();
                edit = edit.prev;
            }
            return retVal;
        }

        public int redo() {
            int retVal = -1;
            Edit edit = this.first;
            while (edit != null) {
                retVal = edit.redo();
                edit = edit.next;
            }
            return retVal;
        }

        public void add(Edit edit) {
            if (this.first == null) {
                this.first = this.last = edit;
            } else {
                edit.prev = this.last;
                this.last.next = edit;
                this.last = edit;
            }
        }
    }

    public static class Remove
    extends Edit {
        UndoManager mgr;
        int offset;
        int length;
        String str;
        int hashcode;
        boolean inKillRing;

        Remove(UndoManager mgr, int offset, int length, String str) {
            this.mgr = mgr;
            this.offset = offset;
            this.length = length;
            this.str = str;
            this.hashcode = str.hashCode();
        }

        int undo() {
            this.mgr.buffer.insert(this.offset, this.str);
            if (this.mgr.undoClearDirty == this) {
                this.mgr.buffer.setDirty(false);
            }
            return this.offset + this.length;
        }

        int redo() {
            this.mgr.buffer.remove(this.offset, this.length);
            if (this.mgr.redoClearDirty == this) {
                this.mgr.buffer.setDirty(false);
            }
            return this.offset;
        }

        public String toString() {
            return this.str;
        }
    }

    static class Insert
    extends Edit {
        UndoManager mgr;
        int offset;
        int length;
        String str;

        Insert(UndoManager mgr, int offset, int length, String str) {
            this.mgr = mgr;
            this.offset = offset;
            this.length = length;
            this.str = str;
        }

        int undo() {
            this.mgr.buffer.remove(this.offset, this.length);
            if (this.mgr.undoClearDirty == this) {
                this.mgr.buffer.setDirty(false);
            }
            return this.offset;
        }

        int redo() {
            this.mgr.buffer.insert(this.offset, this.str);
            if (this.mgr.redoClearDirty == this) {
                this.mgr.buffer.setDirty(false);
            }
            return this.offset + this.length;
        }
    }

    static abstract class Edit {
        Edit prev;
        Edit next;

        Edit() {
        }

        abstract int undo();

        abstract int redo();
    }
}

