/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;

public class LineManager {
    private int[] endOffsets = new int[1];
    private short[] foldLevels;
    private TokenMarker.LineContext[] lineContext;
    private int lineCount;
    private int gapLine;
    private int gapWidth;
    private int firstInvalidLineContext;
    private int firstInvalidFoldLevel;

    public LineManager() {
        this.endOffsets[0] = 1;
        this.foldLevels = new short[1];
        this.lineContext = new TokenMarker.LineContext[1];
        this.lineCount = 1;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    public int getLineOfOffset(int offset) {
        int start = 0;
        int end = this.lineCount - 1;
        while (true) {
            switch (end - start) {
                case 0: {
                    if (this.getLineEndOffset(start) <= offset) {
                        return start + 1;
                    }
                    return start;
                }
                case 1: {
                    if (this.getLineEndOffset(start) <= offset) {
                        if (this.getLineEndOffset(end) <= offset) {
                            return end + 1;
                        }
                        return end;
                    }
                    return start;
                }
            }
            int pivot = (end + start) / 2;
            int value = this.getLineEndOffset(pivot);
            if (value == offset) {
                return pivot + 1;
            }
            if (value < offset) {
                start = pivot + 1;
                continue;
            }
            end = pivot - 1;
        }
    }

    public final int getLineEndOffset(int line) {
        if (this.gapLine != -1 && line >= this.gapLine) {
            return this.endOffsets[line] + this.gapWidth;
        }
        return this.endOffsets[line];
    }

    public final int getFoldLevel(int line) {
        return this.foldLevels[line];
    }

    public final void setFoldLevel(int line, int level) {
        if (level > 65535) {
            level = 65535;
        }
        this.foldLevels[line] = (short)level;
    }

    public void setFirstInvalidFoldLevel(int firstInvalidFoldLevel) {
        this.firstInvalidFoldLevel = firstInvalidFoldLevel;
    }

    public int getFirstInvalidFoldLevel() {
        return this.firstInvalidFoldLevel;
    }

    public final TokenMarker.LineContext getLineContext(int line) {
        return this.lineContext[line];
    }

    public final void setLineContext(int line, TokenMarker.LineContext context) {
        this.lineContext[line] = context;
    }

    public void setFirstInvalidLineContext(int firstInvalidLineContext) {
        this.firstInvalidLineContext = firstInvalidLineContext;
    }

    public int getFirstInvalidLineContext() {
        return this.firstInvalidLineContext;
    }

    public void _contentInserted(IntegerArray endOffsets) {
        this.gapLine = -1;
        this.gapWidth = 0;
        this.firstInvalidFoldLevel = 0;
        this.firstInvalidLineContext = 0;
        this.lineCount = endOffsets.getSize();
        this.endOffsets = endOffsets.getArray();
        this.foldLevels = new short[this.lineCount];
        this.lineContext = new TokenMarker.LineContext[this.lineCount];
    }

    public void contentInserted(int startLine, int offset, int numLines, int length, IntegerArray endOffsets) {
        int endLine = startLine + numLines;
        if (numLines > 0) {
            this.lineCount += numLines;
            if (this.endOffsets.length <= this.lineCount) {
                int[] endOffsetsN = new int[(this.lineCount + 1) * 2];
                System.arraycopy(this.endOffsets, 0, endOffsetsN, 0, this.endOffsets.length);
                this.endOffsets = endOffsetsN;
            }
            if (this.foldLevels.length <= this.lineCount) {
                short[] foldLevelsN = new short[(this.lineCount + 1) * 2];
                System.arraycopy(this.foldLevels, 0, foldLevelsN, 0, this.foldLevels.length);
                this.foldLevels = foldLevelsN;
            }
            if (this.lineContext.length <= this.lineCount) {
                TokenMarker.LineContext[] lineContextN = new TokenMarker.LineContext[(this.lineCount + 1) * 2];
                System.arraycopy(this.lineContext, 0, lineContextN, 0, this.lineContext.length);
                this.lineContext = lineContextN;
            }
            System.arraycopy(this.endOffsets, startLine, this.endOffsets, endLine, this.lineCount - endLine);
            System.arraycopy(this.foldLevels, startLine, this.foldLevels, endLine, this.lineCount - endLine);
            System.arraycopy(this.lineContext, startLine, this.lineContext, endLine, this.lineCount - endLine);
            if (startLine <= this.gapLine) {
                this.gapLine += numLines;
            } else if (this.gapLine != -1) {
                offset -= this.gapWidth;
            }
            if (startLine < this.firstInvalidLineContext) {
                this.firstInvalidLineContext += numLines;
            }
            for (int i = 0; i < numLines; ++i) {
                this.endOffsets[startLine + i] = offset + endOffsets.get(i);
                this.foldLevels[startLine + i] = 0;
            }
        }
        if (this.firstInvalidFoldLevel == -1 || this.firstInvalidFoldLevel > startLine) {
            this.firstInvalidFoldLevel = startLine;
        }
        this.moveGap(endLine, length, "contentInserted");
    }

    public void contentRemoved(int startLine, int offset, int numLines, int length) {
        int endLine = startLine + numLines;
        if (numLines > 0) {
            if (startLine + numLines < this.gapLine) {
                this.gapLine -= numLines;
            } else if (startLine < this.gapLine) {
                this.gapLine = startLine;
            }
            if (startLine + numLines < this.firstInvalidLineContext) {
                this.firstInvalidLineContext -= numLines;
            } else if (startLine < this.firstInvalidLineContext) {
                this.firstInvalidLineContext = startLine - 1;
            }
            this.lineCount -= numLines;
            System.arraycopy(this.endOffsets, endLine, this.endOffsets, startLine, this.lineCount - startLine);
            System.arraycopy(this.foldLevels, endLine, this.foldLevels, startLine, this.lineCount - startLine);
            System.arraycopy(this.lineContext, endLine, this.lineContext, startLine, this.lineCount - startLine);
        }
        if (this.firstInvalidFoldLevel == -1 || this.firstInvalidFoldLevel > startLine) {
            this.firstInvalidFoldLevel = startLine;
        }
        this.moveGap(startLine, -length, "contentRemoved");
    }

    private final void setLineEndOffset(int line, int end) {
        this.endOffsets[line] = end;
    }

    private final void moveGap(int newGapLine, int newGapWidth, String method) {
        if (this.gapLine == -1) {
            this.gapWidth = newGapWidth;
        } else if (newGapLine == -1) {
            if (this.gapWidth != 0) {
                if (Debug.OFFSET_DEBUG && this.gapLine != this.lineCount) {
                    Log.log(1, this, method + ": update from " + this.gapLine + " to " + this.lineCount + " width " + this.gapWidth);
                }
                for (int i = this.gapLine; i < this.lineCount; ++i) {
                    this.setLineEndOffset(i, this.getLineEndOffset(i));
                }
            }
            this.gapWidth = newGapWidth;
        } else if (newGapLine < this.gapLine) {
            if (this.gapWidth != 0) {
                if (Debug.OFFSET_DEBUG && newGapLine != this.gapLine) {
                    Log.log(1, this, method + ": update from " + newGapLine + " to " + this.gapLine + " width " + this.gapWidth);
                }
                for (int i = newGapLine; i < this.gapLine; ++i) {
                    this.setLineEndOffset(i, this.getLineEndOffset(i) - this.gapWidth);
                }
            }
            this.gapWidth += newGapWidth;
        } else {
            if (this.gapWidth != 0) {
                if (Debug.OFFSET_DEBUG && this.gapLine != newGapLine) {
                    Log.log(1, this, method + ": update from " + this.gapLine + " to " + newGapLine + " width " + this.gapWidth);
                }
                for (int i = this.gapLine; i < newGapLine; ++i) {
                    this.setLineEndOffset(i, this.getLineEndOffset(i));
                }
            }
            this.gapWidth += newGapWidth;
        }
        this.gapLine = newGapLine == this.lineCount ? -1 : newGapLine;
    }
}

