/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;

public class IndentFoldHandler
extends FoldHandler {
    public IndentFoldHandler() {
        super("indent");
    }

    public int getFoldLevel(JEditBuffer buffer, int lineIndex, Segment seg) {
        int tabSize = buffer.getTabSize();
        buffer.getLineText(lineIndex, seg);
        int offset = seg.offset;
        int count = seg.count;
        int whitespace = 0;
        boolean seenNonWhiteSpace = false;
        block4: for (int i = 0; i < count; ++i) {
            switch (seg.array[offset + i]) {
                case ' ': {
                    ++whitespace;
                    continue block4;
                }
                case '\t': {
                    whitespace += tabSize - whitespace % tabSize;
                    continue block4;
                }
                default: {
                    seenNonWhiteSpace = true;
                    break block4;
                }
            }
        }
        if (!seenNonWhiteSpace) {
            if (lineIndex != 0) {
                return buffer.getFoldLevel(lineIndex - 1);
            }
            return 0;
        }
        return whitespace;
    }
}

