/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.BufferSegment;

public class ContentManager {
    private char[] text;
    private int gapStart;
    private int gapEnd;
    private int length;

    public final int getLength() {
        return this.length;
    }

    public String getText(int start, int len) {
        if (start >= this.gapStart) {
            return new String(this.text, start + this.gapEnd - this.gapStart, len);
        }
        if (start + len <= this.gapStart) {
            return new String(this.text, start, len);
        }
        return new String(this.text, start, this.gapStart - start).concat(new String(this.text, this.gapEnd, start + len - this.gapStart));
    }

    public void getText(int start, int len, Segment seg) {
        if (start >= this.gapStart) {
            seg.array = this.text;
            seg.offset = start + this.gapEnd - this.gapStart;
            seg.count = len;
        } else if (start + len <= this.gapStart) {
            seg.array = this.text;
            seg.offset = start;
            seg.count = len;
        } else {
            seg.array = new char[len];
            System.arraycopy(this.text, start, seg.array, 0, this.gapStart - start);
            System.arraycopy(this.text, this.gapEnd, seg.array, this.gapStart - start, len + start - this.gapStart);
            seg.offset = 0;
            seg.count = len;
        }
    }

    public CharSequence getSegment(int start, int len) {
        if (start >= this.gapStart) {
            return new BufferSegment(this.text, start + this.gapEnd - this.gapStart, len);
        }
        if (start + len <= this.gapStart) {
            return new BufferSegment(this.text, start, len);
        }
        return new BufferSegment(this.text, start, this.gapStart - start, new BufferSegment(this.text, this.gapEnd, start + len - this.gapStart));
    }

    public void insert(int start, String str) {
        int len = str.length();
        this.moveGapStart(start);
        if (this.gapEnd - this.gapStart < len) {
            this.ensureCapacity(this.length + len + 1024);
            this.moveGapEnd(start + len + 1024);
        }
        str.getChars(0, len, this.text, start);
        this.gapStart += len;
        this.length += len;
    }

    public void insert(int start, CharSequence str) {
        int len = str.length();
        this.moveGapStart(start);
        if (this.gapEnd - this.gapStart < len) {
            this.ensureCapacity(this.length + len + 1024);
            this.moveGapEnd(start + len + 1024);
        }
        for (int i = 0; i < len; ++i) {
            this.text[start + i] = str.charAt(i);
        }
        this.gapStart += len;
        this.length += len;
    }

    public void insert(int start, Segment seg) {
        this.moveGapStart(start);
        if (this.gapEnd - this.gapStart < seg.count) {
            this.ensureCapacity(this.length + seg.count + 1024);
            this.moveGapEnd(start + seg.count + 1024);
        }
        System.arraycopy(seg.array, seg.offset, this.text, start, seg.count);
        this.gapStart += seg.count;
        this.length += seg.count;
    }

    public void _setContent(char[] text, int length) {
        this.text = text;
        this.gapEnd = 0;
        this.gapStart = 0;
        this.length = length;
    }

    public void remove(int start, int len) {
        this.moveGapStart(start);
        this.gapEnd += len;
        this.length -= len;
    }

    private void moveGapStart(int newStart) {
        int newEnd = this.gapEnd + (newStart - this.gapStart);
        if (newStart != this.gapStart) {
            if (newStart > this.gapStart) {
                System.arraycopy(this.text, this.gapEnd, this.text, this.gapStart, newStart - this.gapStart);
            } else if (newStart < this.gapStart) {
                System.arraycopy(this.text, newStart, this.text, newEnd, this.gapStart - newStart);
            }
        }
        this.gapStart = newStart;
        this.gapEnd = newEnd;
    }

    private void moveGapEnd(int newEnd) {
        System.arraycopy(this.text, this.gapEnd, this.text, newEnd, this.length - this.gapStart);
        this.gapEnd = newEnd;
    }

    private void ensureCapacity(int capacity) {
        if (capacity >= this.text.length) {
            char[] textN = new char[capacity * 2];
            System.arraycopy(this.text, 0, textN, 0, this.length + (this.gapEnd - this.gapStart));
            this.text = textN;
        }
    }
}

