/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

class BufferSegment
implements CharSequence {
    private final char[] data;
    private final int offset;
    private final int len;
    private final BufferSegment next;

    public BufferSegment(char[] data, int offset, int len) {
        this(data, offset, len, null);
    }

    public BufferSegment(char[] data, int offset, int len, BufferSegment next) {
        this.data = data;
        this.offset = offset;
        this.len = len;
        this.next = next;
    }

    public char charAt(int index) {
        if (index < this.len) {
            return this.data[this.offset + index];
        }
        if (this.next != null) {
            return this.next.charAt(index - this.len);
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int length() {
        return this.len + (this.next != null ? this.next.length() : 0);
    }

    public CharSequence subSequence(int start, int end) {
        return this.subSegment(start, end);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private void toString(StringBuilder sb) {
        sb.append(this.data, this.offset, this.len);
        if (this.next != null) {
            this.next.toString(sb);
        }
    }

    private BufferSegment subSegment(int start, int end) {
        if (0 <= start && start <= end) {
            if (end <= this.len) {
                return new BufferSegment(this.data, this.offset + start, end - start);
            }
            if (this.next != null) {
                if (start < this.len) {
                    return new BufferSegment(this.data, this.offset + start, this.len - start, this.next.subSegment(0, end - this.len));
                }
                return this.next.subSegment(start - this.len, end - this.len);
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

