/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.gui.ToolBarManager;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchBar;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
extends JFrame
implements EBComponent,
InputHandlerProvider {
    public static final int TOP_GROUP = 0;
    public static final int BOTTOM_GROUP = 1;
    public static final int DEFAULT_GROUP = 0;
    public static final int TOP_LAYER = Integer.MAX_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int BOTTOM_LAYER = Integer.MIN_VALUE;
    public static final int ABOVE_SYSTEM_BAR_LAYER = 150;
    public static final int SYSTEM_BAR_LAYER = 100;
    public static final int BELOW_SYSTEM_BAR_LAYER = 75;
    public static final int SEARCH_BAR_LAYER = 75;
    public static final int BELOW_SEARCH_BAR_LAYER = 50;
    @Deprecated
    public static final int ABOVE_ACTION_BAR_LAYER = -50;
    public static final int ACTION_BAR_LAYER = -75;
    public static final int STATUS_BAR_LAYER = -100;
    public static final int BELOW_STATUS_BAR_LAYER = -150;
    public static final int VIEW = 0;
    public static final int TEXT_AREA = 1;
    public static final int ACTION_BAR = 2;
    View prev;
    View next;
    private boolean closed;
    private DockableWindowManager dockableWindowManager;
    private JPanel topToolBars;
    private JPanel bottomToolBars;
    private ToolBarManager toolBarManager;
    private Container toolBar;
    private SearchBar searchBar;
    private ActionBar actionBar;
    private EditPane editPane;
    private JSplitPane splitPane;
    private String lastSplitConfig;
    private StatusBar status;
    private InputHandler inputHandler;
    private Macros.Recorder recorder;
    private Component prefixFocusOwner;
    private int waitCount;
    private boolean showFullPath;
    private boolean plainView;
    private Socket waitSocket;

    public DockableWindowManager getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    public Container getToolBar() {
        return this.toolBar;
    }

    public void addToolBar(Component toolBar) {
        this.addToolBar(0, 0, toolBar);
    }

    public void addToolBar(int group, Component toolBar) {
        this.addToolBar(group, 0, toolBar);
    }

    public void addToolBar(int group, int layer, Component toolBar) {
        this.toolBarManager.addToolBar(group, layer, toolBar);
        this.getRootPane().revalidate();
    }

    public void removeToolBar(Component toolBar) {
        if (this.toolBarManager == null) {
            return;
        }
        if (toolBar == null) {
            return;
        }
        this.toolBarManager.removeToolBar(toolBar);
        this.getRootPane().revalidate();
    }

    public synchronized void showWaitCursor() {
        if (this.waitCount++ == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            this.visit(new SetCursorVisitor(cursor));
        }
    }

    public synchronized void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            cursor = Cursor.getPredefinedCursor(2);
            this.visit(new SetCursorVisitor(cursor));
        }
    }

    public final SearchBar getSearchBar() {
        return this.searchBar;
    }

    public final ActionBar getActionBar() {
        return this.actionBar;
    }

    public StatusBar getStatus() {
        return this.status;
    }

    public void quickIncrementalSearch(boolean word) {
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(false);
        JEditTextArea textArea = this.getTextArea();
        if (word) {
            String text = textArea.getSelectedText();
            if (text == null) {
                textArea.selectWord();
                text = textArea.getSelectedText();
            } else if (text.indexOf(10) != -1) {
                text = null;
            }
            if (text != null && SearchAndReplace.getRegexp()) {
                text = SearchAndReplace.escapeRegexp(text, false);
            }
            this.searchBar.getField().setText(text);
        }
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void quickHyperSearch(boolean word) {
        JEditTextArea textArea = this.getTextArea();
        if (word) {
            String text = textArea.getSelectedText();
            if (text == null) {
                textArea.selectWord();
                text = textArea.getSelectedText();
            }
            if (text != null && text.indexOf(10) == -1) {
                if (SearchAndReplace.getRegexp()) {
                    text = SearchAndReplace.escapeRegexp(text, false);
                }
                HistoryModel.getModel("find").addItem(text);
                SearchAndReplace.setSearchString(text);
                SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
                SearchAndReplace.hyperSearch(this);
                return;
            }
        }
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(true);
        this.searchBar.getField().setText(null);
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void actionBar() {
        if (this.actionBar == null) {
            this.actionBar = new ActionBar(this, true);
        }
        if (this.actionBar.getParent() == null) {
            this.addToolBar(1, -75, this.actionBar);
        }
        this.actionBar.goToActionBar();
    }

    public KeyListener getKeyEventInterceptor() {
        return this.inputHandler.getKeyEventInterceptor();
    }

    public void setKeyEventInterceptor(KeyListener listener) {
        this.inputHandler.setKeyEventInterceptor(listener);
    }

    @Override
    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public Macros.Recorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(Macros.Recorder recorder) {
        this.recorder = recorder;
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        this.inputHandler.processKeyEvent(evt, 0, false);
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void processKeyEvent(KeyEvent evt, boolean calledFromTextArea) {
        this.processKeyEvent(evt, calledFromTextArea ? 1 : 0);
    }

    public void processKeyEvent(KeyEvent evt, int from) {
        this.processKeyEvent(evt, from, false);
    }

    @Deprecated
    public void processKeyEvent(KeyEvent evt, int from, boolean global) {
        this.inputHandler.processKeyEvent(evt, from, global);
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public EditPane splitHorizontally() {
        return this.split(0);
    }

    public EditPane splitVertically() {
        return this.split(1);
    }

    public EditPane split(int orientation) {
        PerspectiveManager.setPerspectiveDirty(true);
        this.editPane.saveCaretInfo();
        EditPane oldEditPane = this.editPane;
        String action = jEdit.getProperty("editpane.bufferset.new");
        BufferSetManager.NewBufferSetAction bufferSetAction = BufferSetManager.NewBufferSetAction.fromString(action);
        EditPane newEditPane = bufferSetAction == BufferSetManager.NewBufferSetAction.empty ? this.createEditPane(null) : this.createEditPane(oldEditPane.getBuffer());
        newEditPane.loadCaretInfo();
        JComponent oldParent = (JComponent)oldEditPane.getParent();
        final JSplitPane newSplitPane = new JSplitPane(orientation, jEdit.getBooleanProperty("appearance.continuousLayout"));
        newSplitPane.setOneTouchExpandable(true);
        newSplitPane.setBorder(null);
        newSplitPane.setMinimumSize(new Dimension(0, 0));
        newSplitPane.setResizeWeight(0.5);
        int parentSize = orientation == 0 ? oldEditPane.getHeight() : oldEditPane.getWidth();
        final int dividerPosition = (int)((double)(parentSize - newSplitPane.getDividerSize()) * 0.5);
        newSplitPane.setDividerLocation(dividerPosition);
        if (oldParent instanceof JSplitPane) {
            JSplitPane oldSplitPane = (JSplitPane)oldParent;
            int dividerPos = oldSplitPane.getDividerLocation();
            Component left = oldSplitPane.getLeftComponent();
            if (left == oldEditPane) {
                oldSplitPane.setLeftComponent(newSplitPane);
            } else {
                oldSplitPane.setRightComponent(newSplitPane);
            }
            newSplitPane.setLeftComponent(oldEditPane);
            newSplitPane.setRightComponent(newEditPane);
            oldSplitPane.setDividerLocation(dividerPos);
        } else {
            this.splitPane = newSplitPane;
            newSplitPane.setLeftComponent(oldEditPane);
            newSplitPane.setRightComponent(newEditPane);
            oldParent.add((Component)newSplitPane, 0);
            oldParent.revalidate();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                newSplitPane.setDividerLocation(dividerPosition);
            }
        });
        newEditPane.focusOnTextArea();
        return newEditPane;
    }

    public void unsplit() {
        if (this.splitPane != null) {
            this.lastSplitConfig = this.getSplitConfig();
            PerspectiveManager.setPerspectiveDirty(true);
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                EditPane _editPane = editPanes[i];
                if (this.editPane == _editPane) continue;
                _editPane.close();
            }
            JComponent parent = (JComponent)this.splitPane.getParent();
            parent.remove(this.splitPane);
            parent.add((Component)this.editPane, 0);
            parent.revalidate();
            this.splitPane = null;
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void unsplitCurrent() {
        if (this.splitPane != null) {
            this.lastSplitConfig = this.getSplitConfig();
            PerspectiveManager.setPerspectiveDirty(true);
            Container comp = this.editPane;
            while (!(comp instanceof JSplitPane)) {
                comp = comp.getParent();
            }
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                EditPane _editPane = editPanes[i];
                if (!GUIUtilities.isAncestorOf(comp, _editPane) || _editPane == this.editPane) continue;
                _editPane.close();
            }
            JComponent parent = (JComponent)comp.getParent();
            if (parent instanceof JSplitPane) {
                JSplitPane parentSplit = (JSplitPane)parent;
                int pos = parentSplit.getDividerLocation();
                if (parentSplit.getLeftComponent() == comp) {
                    parentSplit.setLeftComponent(this.editPane);
                } else {
                    parentSplit.setRightComponent(this.editPane);
                }
                parentSplit.setDividerLocation(pos);
            } else {
                parent.remove(comp);
                parent.add((Component)this.editPane, 0);
                this.splitPane = null;
            }
            parent.revalidate();
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void resplit() {
        if (this.lastSplitConfig == null) {
            this.getToolkit().beep();
        } else {
            this.setSplitConfig(null, this.lastSplitConfig);
        }
    }

    public void nextTextArea() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            if (this.editPane != editPanes[i]) continue;
            if (i == editPanes.length - 1) {
                editPanes[0].focusOnTextArea();
                break;
            }
            editPanes[i + 1].focusOnTextArea();
            break;
        }
    }

    public void prevTextArea() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            if (this.editPane != editPanes[i]) continue;
            if (i == 0) {
                editPanes[editPanes.length - 1].focusOnTextArea();
                break;
            }
            editPanes[i - 1].focusOnTextArea();
            break;
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public Buffer getBuffer() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getBuffer();
    }

    public void setBuffer(Buffer buffer) {
        this.setBuffer(buffer, false);
    }

    public void setBuffer(Buffer buffer, boolean disableFileStatusCheck) {
        this.setBuffer(buffer, disableFileStatusCheck, true);
    }

    public void setBuffer(Buffer buffer, boolean disableFileStatusCheck, boolean focus) {
        this.editPane.setBuffer(buffer, focus);
        int check = jEdit.getIntegerProperty("checkFileStatus");
        if (!(disableFileStatusCheck || check != 1 && check != 2 && check != 3)) {
            jEdit.checkBufferStatus(this, true);
        }
    }

    public EditPane goToBuffer(Buffer buffer) {
        return this.showBuffer(buffer, true);
    }

    public EditPane showBuffer(Buffer buffer) {
        return this.showBuffer(buffer, false);
    }

    public JEditTextArea getTextArea() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getTextArea();
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    public EditPane[] getEditPanes() {
        if (this.splitPane == null) {
            EditPane[] ep = new EditPane[]{this.editPane};
            return ep;
        }
        ArrayList<EditPane> vec = new ArrayList<EditPane>();
        View.getEditPanes(vec, this.splitPane);
        EditPane[] ep = new EditPane[vec.size()];
        vec.toArray(ep);
        return ep;
    }

    public ViewConfig getViewConfig() {
        ViewConfig config = new ViewConfig();
        config.plainView = this.isPlainView();
        config.splitConfig = this.getSplitConfig();
        config.extState = this.getExtendedState();
        String prefix = config.plainView ? "plain-view" : "view";
        switch (config.extState) {
            case 1: 
            case 6: {
                config.x = jEdit.getIntegerProperty(prefix + ".x", this.getX());
                config.y = jEdit.getIntegerProperty(prefix + ".y", this.getY());
                config.width = jEdit.getIntegerProperty(prefix + ".width", this.getWidth());
                config.height = jEdit.getIntegerProperty(prefix + ".height", this.getHeight());
                break;
            }
            case 4: {
                config.x = this.getX();
                config.y = jEdit.getIntegerProperty(prefix + ".y", this.getY());
                config.width = this.getWidth();
                config.height = jEdit.getIntegerProperty(prefix + ".height", this.getHeight());
                break;
            }
            case 2: {
                config.x = jEdit.getIntegerProperty(prefix + ".x", this.getX());
                config.y = this.getY();
                config.width = jEdit.getIntegerProperty(prefix + ".width", this.getWidth());
                config.height = this.getHeight();
                break;
            }
            default: {
                config.x = this.getX();
                config.y = this.getY();
                config.width = this.getWidth();
                config.height = this.getHeight();
            }
        }
        config.top = this.dockableWindowManager.getTopDockingArea().getCurrent();
        config.left = this.dockableWindowManager.getLeftDockingArea().getCurrent();
        config.bottom = this.dockableWindowManager.getBottomDockingArea().getCurrent();
        config.right = this.dockableWindowManager.getRightDockingArea().getCurrent();
        config.topPos = this.dockableWindowManager.getTopDockingArea().getDimension();
        config.leftPos = this.dockableWindowManager.getLeftDockingArea().getDimension();
        config.bottomPos = this.dockableWindowManager.getBottomDockingArea().getDimension();
        config.rightPos = this.dockableWindowManager.getRightDockingArea().getDimension();
        return config;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPlainView() {
        return this.plainView;
    }

    public View getNext() {
        return this.next;
    }

    public View getPrev() {
        return this.prev;
    }

    @Override
    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (msg instanceof SearchSettingsChanged) {
            if (this.searchBar != null) {
                this.searchBar.update();
            }
        } else if (msg instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)msg);
        } else if (msg instanceof EditPaneUpdate) {
            this.handleEditPaneUpdate((EditPaneUpdate)msg);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setWaitSocket(Socket waitSocket) {
        this.waitSocket = waitSocket;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '[' + (jEdit.getActiveView() == this ? "active" : "inactive") + ']';
    }

    public void updateTitle() {
        ArrayList<Buffer> buffers = new ArrayList<Buffer>();
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            Buffer buffer = editPanes[i].getBuffer();
            if (buffers.contains(buffer)) continue;
            buffers.add(buffer);
        }
        StringBuilder title = new StringBuilder();
        if (!OperatingSystem.isMacOS()) {
            title.append(jEdit.getProperty("view.title"));
        }
        boolean unsavedChanges = false;
        for (int i = 0; i < buffers.size(); ++i) {
            if (i != 0) {
                title.append(", ");
            }
            Buffer buffer = (Buffer)buffers.get(i);
            title.append(this.showFullPath && !buffer.isNewFile() ? buffer.getPath() : buffer.getName());
            if (!buffer.isDirty()) continue;
            unsavedChanges = true;
            title.append(jEdit.getProperty("view.title.dirty"));
        }
        this.setTitle(title.toString());
        String WINDOW_MODIFIED = "windowModified";
        this.getRootPane().putClientProperty(WINDOW_MODIFIED, unsavedChanges);
    }

    public Component getPrefixFocusOwner() {
        return this.prefixFocusOwner;
    }

    public void setPrefixFocusOwner(Component prefixFocusOwner) {
        this.prefixFocusOwner = prefixFocusOwner;
    }

    public void visit(JEditVisitor visitor) {
        EditPane[] panes = this.getEditPanes();
        for (int i = 0; i < panes.length; ++i) {
            EditPane editPane = panes[i];
            visitor.visit(editPane);
            visitor.visit(editPane.getTextArea());
        }
    }

    View(Buffer buffer, ViewConfig config) {
        this.plainView = config.plainView;
        this.enableEvents(8L);
        this.setIconImage(GUIUtilities.getEditorIcon());
        this.dockableWindowManager = new DockableWindowManager(this, DockableWindowFactory.getInstance(), config);
        this.topToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.bottomToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.toolBarManager = new ToolBarManager(this.topToolBars, this.bottomToolBars);
        this.status = new StatusBar(this);
        this.inputHandler = new DefaultInputHandler(this, (DefaultInputHandler)jEdit.getInputHandler());
        this.setSplitConfig(buffer, config.splitConfig);
        this.getContentPane().add("Center", this.dockableWindowManager);
        this.dockableWindowManager.init();
        this.propertiesChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        EditBus.addToBus(this);
        GUIUtilities.addSizeSaver(this, null, this.plainView ? "plain-view" : "view");
    }

    void close() {
        EditBus.send(new ViewUpdate(this, ViewUpdate.CLOSED));
        this.closed = true;
        this.dockableWindowManager.close();
        EditBus.removeFromBus(this);
        this.dispose();
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            editPanes[i].close();
        }
        this.toolBarManager = null;
        this.toolBar = null;
        this.searchBar = null;
        this.splitPane = null;
        this.inputHandler = null;
        this.recorder = null;
        this.getContentPane().removeAll();
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void getEditPanes(List<EditPane> vec, Component comp) {
        if (comp instanceof EditPane) {
            vec.add((EditPane)comp);
        } else if (comp instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)comp;
            View.getEditPanes(vec, split.getLeftComponent());
            View.getEditPanes(vec, split.getRightComponent());
        }
    }

    private EditPane showBuffer(Buffer buffer, boolean focus) {
        if (this.editPane.getBuffer() == buffer && this.editPane.getTextArea().getVisibleLines() > 1) {
            if (focus) {
                this.editPane.focusOnTextArea();
            }
            return this.editPane;
        }
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            EditPane ep = editPanes[i];
            if (ep.getBuffer() != buffer || ep.getTextArea().getVisibleLines() <= 1) continue;
            this.setEditPane(ep);
            if (focus) {
                ep.focusOnTextArea();
            }
            return ep;
        }
        this.setBuffer(buffer, false, focus);
        return this.editPane;
    }

    private String getSplitConfig() {
        StringBuilder splitConfig = new StringBuilder();
        if (this.splitPane != null) {
            View.getSplitConfig(this.splitPane, splitConfig);
        } else {
            View.appendToSplitConfig(splitConfig, this.editPane);
        }
        return splitConfig.toString();
    }

    private static void getSplitConfig(JSplitPane splitPane, StringBuilder splitConfig) {
        Component right = splitPane.getRightComponent();
        View.appendToSplitConfig(splitConfig, right);
        splitConfig.append(' ');
        Component left = splitPane.getLeftComponent();
        View.appendToSplitConfig(splitConfig, left);
        splitConfig.append(' ');
        splitConfig.append(splitPane.getDividerLocation());
        splitConfig.append(' ');
        splitConfig.append(splitPane.getOrientation() == 0 ? "vertical" : "horizontal");
    }

    private static void appendToSplitConfig(StringBuilder splitConfig, Component component) {
        if (component instanceof JSplitPane) {
            View.getSplitConfig((JSplitPane)component, splitConfig);
        } else {
            EditPane editPane = (EditPane)component;
            splitConfig.append('\"');
            splitConfig.append(StandardUtilities.charsToEscapes(editPane.getBuffer().getPath()));
            splitConfig.append("\" buffer");
            BufferSet bufferSet = editPane.getBufferSet();
            Buffer[] buffers = bufferSet.getAllBuffers();
            BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
            for (Buffer buffer : buffers) {
                if (buffer.isNewFile() || !bufferSetManager.hasListeners(buffer)) continue;
                splitConfig.append(" \"");
                splitConfig.append(StandardUtilities.charsToEscapes(buffer.getPath()));
                splitConfig.append("\" buff");
            }
            splitConfig.append(" \"");
            splitConfig.append((Object)bufferSet.getScope());
            splitConfig.append("\" bufferset");
        }
    }

    private void setSplitConfig(Buffer buffer, String splitConfig) {
        if (this.editPane != null) {
            this.dockableWindowManager.remove(this.editPane);
        }
        if (this.splitPane != null) {
            this.dockableWindowManager.remove(this.splitPane);
        }
        try {
            Component comp = this.restoreSplitConfig(buffer, splitConfig);
            this.dockableWindowManager.add(comp, 0);
        }
        catch (IOException e) {
            throw new InternalError();
        }
        this.dockableWindowManager.revalidate();
        this.dockableWindowManager.repaint();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Component restoreSplitConfig(Buffer buffer, String splitConfig) throws IOException {
        if (buffer != null) {
            this.editPane = this.createEditPane(buffer);
            return this.editPane;
        }
        if (splitConfig == null) {
            this.editPane = this.createEditPane(jEdit.getFirstBuffer());
            return this.editPane;
        }
        Buffer[] buffers = jEdit.getBuffers();
        Stack<Object> stack = new Stack<Object>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(splitConfig));
        st.whitespaceChars(0, 32);
        st.wordChars(35, 126);
        st.commentChar(33);
        st.quoteChar(34);
        st.eolIsSignificant(false);
        boolean continuousLayout = jEdit.getBooleanProperty("appearance.continuousLayout");
        ArrayList<Buffer> editPaneBuffers = new ArrayList<Buffer>();
        block11: while (true) {
            switch (st.nextToken()) {
                case -1: {
                    break block11;
                }
                case -3: {
                    if (st.sval.equals("vertical") || st.sval.equals("horizontal")) {
                        int orientation = st.sval.equals("vertical") ? 0 : 1;
                        int divider = (Integer)stack.pop();
                        this.splitPane = new JSplitPane(orientation, continuousLayout, (Component)stack.pop(), (Component)stack.pop());
                        stack.push(this.splitPane);
                        this.splitPane.setOneTouchExpandable(true);
                        this.splitPane.setBorder(null);
                        this.splitPane.setMinimumSize(new Dimension(0, 0));
                        this.splitPane.setDividerLocation(divider);
                        break;
                    }
                    if (st.sval.equals("buffer")) {
                        Object obj = stack.pop();
                        if (obj instanceof Integer) {
                            int index = (Integer)obj;
                            if (index >= 0 && index < buffers.length) {
                                buffer = buffers[index];
                            }
                        } else if (obj instanceof String) {
                            String path = (String)obj;
                            buffer = jEdit.getBuffer(path);
                        }
                        if (buffer == null) {
                            buffer = jEdit.getFirstBuffer();
                        }
                        this.editPane = this.createEditPane(buffer);
                        stack.push(this.editPane);
                        break;
                    }
                    if (st.sval.equals("buff")) {
                        String path = (String)stack.pop();
                        buffer = jEdit.getBuffer(path);
                        if (buffer == null) {
                            Log.log(7, this, "Error buffer " + path + " doesn't exists");
                            break;
                        }
                        editPaneBuffers.add(buffer);
                        break;
                    }
                    if (!st.sval.equals("bufferset")) break;
                    BufferSet.Scope scope = BufferSet.Scope.fromString((String)stack.pop());
                    BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
                    switch (scope) {
                        case view: {
                            this.editPane.setBufferSet(bufferSetManager.getViewBufferSet(this));
                            break;
                        }
                        case editpane: {
                            this.editPane.setBufferSet(bufferSetManager.getEditPaneBufferSet(this.editPane));
                            break;
                        }
                        case global: {
                            this.editPane.setBufferSet(bufferSetManager.getGlobalBufferSet());
                            break;
                        }
                    }
                    BufferSet bufferSet = this.editPane.getBufferSet();
                    for (Buffer buff : editPaneBuffers) {
                        bufferSetManager.addBuffer(bufferSet, buff);
                    }
                    editPaneBuffers.clear();
                    break;
                }
                case -2: {
                    stack.push((int)st.nval);
                    break;
                }
                case 34: {
                    stack.push(st.sval);
                }
            }
        }
        this.updateGutterBorders();
        return (Component)stack.peek();
    }

    private void propertiesChanged() {
        boolean showStatus;
        this.setJMenuBar(GUIUtilities.loadMenuBar("view.mbar"));
        this.loadToolBars();
        this.showFullPath = jEdit.getBooleanProperty("view.showFullPath");
        this.updateTitle();
        this.status.propertiesChanged();
        this.removeToolBar(this.status);
        this.getContentPane().remove(this.status);
        boolean bl = showStatus = this.plainView ? jEdit.getBooleanProperty("view.status.plainview.visible") : jEdit.getBooleanProperty("view.status.visible");
        if (jEdit.getBooleanProperty("view.toolbar.alternateLayout")) {
            this.getContentPane().add("North", this.topToolBars);
            this.getContentPane().add("South", this.bottomToolBars);
            if (showStatus) {
                this.addToolBar(1, -100, this.status);
            }
        } else {
            this.dockableWindowManager.add(this.topToolBars, "top-toolbars", 0);
            this.dockableWindowManager.add(this.bottomToolBars, "bottom-toolbars", 0);
            if (showStatus) {
                this.getContentPane().add("South", this.status);
            }
        }
        this.getRootPane().revalidate();
        if (this.splitPane != null) {
            GUIUtilities.initContinuousLayout(this.splitPane);
        }
    }

    private void loadToolBars() {
        if (jEdit.getBooleanProperty("view.showToolbar") && !this.plainView) {
            if (this.toolBar != null) {
                this.toolBarManager.removeToolBar(this.toolBar);
            }
            this.toolBar = GUIUtilities.loadToolBar("view.toolbar");
            this.addToolBar(0, 100, this.toolBar);
        } else if (this.toolBar != null) {
            this.removeToolBar(this.toolBar);
            this.toolBar = null;
        }
        if (this.searchBar != null) {
            this.searchBar.propertiesChanged();
            this.removeToolBar(this.searchBar);
        }
        if (jEdit.getBooleanProperty("view.showSearchbar") && !this.plainView) {
            if (this.searchBar == null) {
                this.searchBar = new SearchBar(this, false);
            }
            this.addToolBar(0, 75, this.searchBar);
        }
    }

    private EditPane createEditPane(Buffer buffer) {
        EditPane editPane = new EditPane(this, buffer);
        JEditTextArea textArea = editPane.getTextArea();
        textArea.addFocusListener(new FocusHandler());
        textArea.addCaretListener(new CaretHandler());
        textArea.addScrollListener(new ScrollHandler());
        EditBus.send(new EditPaneUpdate(editPane, EditPaneUpdate.CREATED));
        return editPane;
    }

    private void setEditPane(EditPane editPane) {
        this.editPane = editPane;
        this.status.updateCaretStatus();
        this.status.updateBufferStatus();
        this.status.updateMiscStatus();
        this.updateGutterBorders();
        EditBus.send(new ViewUpdate(this, ViewUpdate.EDIT_PANE_CHANGED));
    }

    private void handleBufferUpdate(BufferUpdate msg) {
        Buffer buffer = msg.getBuffer();
        if (msg.getWhat() == BufferUpdate.DIRTY_CHANGED || msg.getWhat() == BufferUpdate.LOADED) {
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                if (editPanes[i].getBuffer() != buffer) continue;
                this.updateTitle();
                break;
            }
        }
    }

    private void handleEditPaneUpdate(EditPaneUpdate msg) {
        EditPane editPane = msg.getEditPane();
        if (editPane.getView() == this && msg.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPane.getBuffer().isLoaded()) {
            this.status.updateCaretStatus();
            this.status.updateBufferStatus();
            this.status.updateMiscStatus();
        }
    }

    private void updateGutterBorders() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            editPanes[i].getTextArea().getGutter().updateBorder();
        }
    }

    private static class SetCursorVisitor
    extends JEditVisitorAdapter {
        private final Cursor cursor;

        SetCursorVisitor(Cursor cursor) {
            this.cursor = cursor;
        }

        public void visit(EditPane editPane) {
            editPane.setCursor(this.cursor);
        }
    }

    private static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return GUIUtilities.getView(focusCycleRoot).getTextArea();
        }
    }

    public static class ViewConfig {
        public boolean plainView;
        public String splitConfig;
        public int x;
        public int y;
        public int width;
        public int height;
        public int extState;
        public String top;
        public String left;
        public String bottom;
        public String right;
        public int topPos;
        public int leftPos;
        public int bottomPos;
        public int rightPos;

        public ViewConfig() {
        }

        public ViewConfig(boolean plainView) {
            this.plainView = plainView;
            String prefix = plainView ? "plain-view" : "view";
            this.x = jEdit.getIntegerProperty(prefix + ".x", 0);
            this.y = jEdit.getIntegerProperty(prefix + ".y", 0);
            this.width = jEdit.getIntegerProperty(prefix + ".width", 0);
            this.height = jEdit.getIntegerProperty(prefix + ".height", 0);
            this.extState = jEdit.getIntegerProperty(prefix + ".extendedState", 0);
        }

        public ViewConfig(boolean plainView, String splitConfig, int x, int y, int width, int height, int extState) {
            this.plainView = plainView;
            this.splitConfig = splitConfig;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.extState = extState;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent evt) {
            boolean editPaneChanged = jEdit.getActiveViewInternal() != View.this;
            jEdit.setActiveView(View.this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int check = jEdit.getIntegerProperty("checkFileStatus");
                    if (check == 0 || check == 1) {
                        jEdit.checkBufferStatus(View.this, false);
                    } else if (check == 3) {
                        jEdit.checkBufferStatus(View.this, true);
                    }
                }
            });
            if (editPaneChanged) {
                EditBus.send(new ViewUpdate(View.this, ViewUpdate.ACTIVATED));
            }
        }

        public void windowClosing(WindowEvent evt) {
            jEdit.closeView(View.this);
        }
    }

    private class ScrollHandler
    implements ScrollListener {
        private ScrollHandler() {
        }

        public void scrolledVertically(TextArea textArea) {
            if (View.this.getTextArea() == textArea) {
                View.this.status.updateCaretStatus();
            }
        }

        public void scrolledHorizontally(TextArea textArea) {
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent evt) {
            Component comp = (Component)evt.getSource();
            while (!(comp instanceof EditPane)) {
                if (comp == null) {
                    return;
                }
                comp = comp.getParent();
            }
            if (comp != View.this.editPane) {
                View.this.setEditPane((EditPane)comp);
            } else {
                View.this.updateGutterBorders();
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent evt) {
            if (evt.getSource() == View.this.getTextArea()) {
                View.this.status.updateCaretStatus();
            }
        }
    }
}

