/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.StringReader;
import org.gjt.sp.jedit.RegisterSaver;
import org.gjt.sp.jedit.RegistersListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class Registers {
    private static Register[] registers = new Register[256];
    private static boolean loaded;
    private static boolean loading;
    private static RegisterSaver saver;
    private static RegistersListener listener;
    private static boolean modified;

    public static void copy(TextArea textArea, char register) {
        String selection = textArea.getSelectedText();
        if (selection == null) {
            return;
        }
        Registers.setRegister(register, selection);
        HistoryModel.getModel("clipboard").addItem(selection);
    }

    public static void cut(TextArea textArea, char register) {
        if (textArea.isEditable()) {
            String selection = textArea.getSelectedText();
            if (selection == null) {
                return;
            }
            Registers.setRegister(register, selection);
            HistoryModel.getModel("clipboard").addItem(selection);
            textArea.setSelectedText("");
        } else {
            textArea.getToolkit().beep();
        }
    }

    public static void append(TextArea textArea, char register) {
        Registers.append(textArea, register, "\n", false);
    }

    public static void append(TextArea textArea, char register, String separator) {
        Registers.append(textArea, register, separator, false);
    }

    public static void append(TextArea textArea, char register, String separator, boolean cut) {
        String registerContents;
        if (cut && !textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        String selection = textArea.getSelectedText();
        if (selection == null) {
            return;
        }
        Register reg = Registers.getRegister(register);
        if (reg != null && (registerContents = ((Object)reg).toString()) != null) {
            selection = registerContents.endsWith(separator) ? registerContents + selection : registerContents + separator + selection;
        }
        Registers.setRegister(register, selection);
        HistoryModel.getModel("clipboard").addItem(selection);
        if (cut) {
            textArea.setSelectedText("");
        }
    }

    public static void paste(TextArea textArea, char register) {
        Registers.paste(textArea, register, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paste(TextArea textArea, char register, boolean vertical) {
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        Register reg = Registers.getRegister(register);
        if (reg == null) {
            textArea.getToolkit().beep();
            return;
        }
        String selection = ((Object)reg).toString();
        if (selection == null) {
            textArea.getToolkit().beep();
            return;
        }
        JEditBuffer buffer = textArea.getBuffer();
        try {
            buffer.beginCompoundEdit();
            if (vertical && textArea.getSelectionCount() == 0) {
                int caret = textArea.getCaretPosition();
                int caretLine = textArea.getCaretLine();
                Selection.Rect rect = new Selection.Rect(caretLine, caret, caretLine, caret);
                textArea.setSelectedText(rect, selection);
                caretLine = textArea.getCaretLine();
                if (caretLine != textArea.getLineCount() - 1) {
                    int startColumn = rect.getStartColumn(buffer);
                    int offset = buffer.getOffsetOfVirtualColumn(caretLine + 1, startColumn, null);
                    if (offset == -1) {
                        buffer.insertAtColumn(caretLine + 1, startColumn, "");
                        textArea.setCaretPosition(buffer.getLineEndOffset(caretLine + 1) - 1);
                    } else {
                        textArea.setCaretPosition(buffer.getLineStartOffset(caretLine + 1) + offset);
                    }
                }
            } else {
                textArea.replaceSelection(selection);
            }
            Object var12_11 = null;
            buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            buffer.endCompoundEdit();
            throw throwable;
        }
        HistoryModel.getModel("clipboard").addItem(selection);
    }

    public static Register getRegister(char name) {
        if (name != '$' && name != '%' && !loaded) {
            Registers.loadRegisters();
        }
        if (registers == null || name >= registers.length) {
            return null;
        }
        return registers[name];
    }

    public static void setRegister(char name, Register newRegister) {
        Registers.touchRegister(name);
        if (name >= registers.length) {
            Register[] newRegisters = new Register[Math.min(65536, name << 1)];
            System.arraycopy(registers, 0, newRegisters, 0, registers.length);
            registers = newRegisters;
        }
        Registers.registers[name] = newRegister;
        if (listener != null) {
            listener.registerChanged(name);
        }
    }

    public static void setRegister(char name, String value) {
        Registers.touchRegister(name);
        Register register = Registers.getRegister(name);
        if (register != null) {
            register.setValue(value);
            if (listener != null) {
                listener.registerChanged(name);
            }
        } else {
            Registers.setRegister(name, new StringRegister(value));
        }
    }

    public static void clearRegister(char name) {
        if (name >= registers.length) {
            return;
        }
        Register register = registers[name];
        if (name == '$' || name == '%') {
            register.setValue("");
        } else {
            Registers.registers[name] = null;
            modified = true;
            if (listener != null) {
                listener.registerChanged(name);
            }
        }
    }

    public static Register[] getRegisters() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        return registers;
    }

    public static String getRegisterStatusPrompt(String action) {
        String registerNameString = Registers.getRegisterNameString();
        return jEdit.getProperty("view.status." + action, new String[]{registerNameString == null ? jEdit.getProperty("view.status.no-registers") : registerNameString});
    }

    public static String getRegisterNameString() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        StringBuilder buf = new StringBuilder(registers.length << 1);
        for (int i = 0; i < registers.length; ++i) {
            if (registers[i] == null) continue;
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append((char)i);
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public static void saveRegisters() {
        if (!loaded || !modified) {
            return;
        }
        if (saver != null) {
            saver.saveRegisters();
            modified = false;
        }
    }

    public static void setListener(RegistersListener listener) {
        Registers.listener = listener;
    }

    public static void setSaver(RegisterSaver saver) {
        Registers.saver = saver;
    }

    public static boolean isLoading() {
        return loading;
    }

    public static void setLoading(boolean loading) {
        Registers.loading = loading;
    }

    private Registers() {
    }

    private static void touchRegister(char name) {
        if (name == '%' || name == '$') {
            return;
        }
        if (!loaded) {
            Registers.loadRegisters();
        }
        if (!loading) {
            modified = true;
        }
    }

    private static void loadRegisters() {
        if (saver != null) {
            loaded = true;
            saver.loadRegisters();
        }
    }

    protected static void debugListDataFlavors(Transferable transferable) {
        DataFlavor[] dataFlavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavors.length; ++i) {
            DataFlavor dataFlavor = dataFlavors[i];
            Log.log(1, Registers.class, "debugListDataFlavors(): dataFlavor=" + dataFlavor + '.');
        }
        if (dataFlavors.length == 0) {
            Log.log(1, Registers.class, "debugListDataFlavors(): no dataFlavor supported.");
        }
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Registers.registers[36] = new ClipboardRegister(toolkit.getSystemClipboard());
        Clipboard selection = toolkit.getSystemSelection();
        if (selection != null) {
            Registers.registers[37] = new ClipboardRegister(selection);
        }
    }

    public static class StringRegister
    implements Register {
        private String value;

        public StringRegister(String value) {
            this.value = value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public void dispose() {
        }
    }

    public static class ClipboardRegister
    implements Register {
        Clipboard clipboard;

        public ClipboardRegister(Clipboard clipboard) {
            this.clipboard = clipboard;
        }

        public void setValue(String value) {
            StringSelection selection = new StringSelection(value);
            this.clipboard.setContents(selection, null);
        }

        public String toString() {
            try {
                String line;
                String selection = (String)this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                boolean trailingEOL = selection.endsWith("\n") || selection.endsWith(System.getProperty("line.separator"));
                BufferedReader in = new BufferedReader(new StringReader(selection));
                StringBuilder buf = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (line.endsWith("\u0000")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    buf.append(line);
                    buf.append('\n');
                }
                if (!trailingEOL && buf.length() != 0) {
                    buf.setLength(buf.length() - 1);
                }
                return buf.toString();
            }
            catch (Exception e) {
                Log.log(5, this, e);
                return null;
            }
        }
    }

    public static interface Register {
        public String toString();

        public void setValue(String var1);
    }
}

