/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import org.gjt.sp.jedit.BeanShellFacade;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEditBeanShellAction
extends JEditAbstractEditAction<TextArea> {
    private boolean noRepeat;
    private boolean noRecord;
    private boolean noRememberLast;
    private String code;
    private String isSelected;
    private BshMethod cachedCode;
    private BshMethod cachedIsSelected;
    private String sanitizedName;
    private static final BeanShellFacade<TextArea> bsh = new MyBeanShellFacade();

    public JEditBeanShellAction(String name, String code, String isSelected, boolean noRepeat, boolean noRecord, boolean noRememberLast) {
        super(name);
        this.code = code;
        this.isSelected = isSelected;
        this.noRepeat = noRepeat;
        this.noRecord = noRecord;
        this.noRememberLast = noRememberLast;
        this.sanitizedName = name.replace('.', '_').replace('-', '_');
    }

    @Override
    public void invoke(TextArea textArea) {
        try {
            if (this.cachedCode == null) {
                String cachedCodeName = "action_" + this.sanitizedName;
                this.cachedCode = bsh.cacheBlock(cachedCodeName, this.code, true);
            }
            bsh.runCachedBlock(this.cachedCode, textArea, new NameSpace(bsh.getNameSpace(), "BeanShellAction.invoke()"));
        }
        catch (Throwable e) {
            Log.log(9, this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelected(Component comp) {
        boolean cachedIsSelectedName2;
        if (this.isSelected == null) {
            return false;
        }
        NameSpace global = bsh.getNameSpace();
        try {
            try {
                if (this.cachedIsSelected == null) {
                    String cachedIsSelectedName2 = "selected_" + this.sanitizedName;
                    this.cachedIsSelected = bsh.cacheBlock(cachedIsSelectedName2, this.isSelected, true);
                }
                global.setVariable("_comp", comp);
                cachedIsSelectedName2 = Boolean.TRUE.equals(bsh.runCachedBlock(this.cachedIsSelected, null, new NameSpace(bsh.getNameSpace(), "BeanShellAction.isSelected()")));
                Object var6_6 = null;
            }
            catch (Throwable e) {
                Log.log(9, this, e);
                this.isSelected = null;
                boolean bl = false;
                Object var6_7 = null;
                try {
                    global.setVariable("_comp", null);
                    return bl;
                }
                catch (UtilEvalError err) {
                    Log.log(9, this, err);
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {}
            catch (UtilEvalError err) {
                Log.log(9, this, err);
                throw throwable;
            }
            global.setVariable("_comp", null);
            throw throwable;
        }
        try {}
        catch (UtilEvalError err) {
            Log.log(9, this, err);
            return cachedIsSelectedName2;
        }
        global.setVariable("_comp", null);
        return cachedIsSelectedName2;
    }

    public boolean noRepeat() {
        return this.noRepeat;
    }

    public boolean noRecord() {
        return this.noRecord;
    }

    public boolean noRememberLast() {
        return this.noRememberLast;
    }

    public String getCode() {
        return this.code.trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyBeanShellFacade
    extends BeanShellFacade<TextArea> {
        private MyBeanShellFacade() {
        }

        @Override
        protected void setupDefaultVariables(NameSpace namespace, TextArea textArea) throws UtilEvalError {
            if (textArea != null) {
                namespace.setVariable("buffer", textArea.getBuffer(), false);
                namespace.setVariable("textArea", textArea, false);
            }
        }

        @Override
        protected void resetDefaultVariables(NameSpace namespace) throws UtilEvalError {
            namespace.setVariable("buffer", null, false);
            namespace.setVariable("textArea", null, false);
        }

        @Override
        protected void handleException(TextArea textArea, String path, Throwable t) {
            Log.log(9, this, t, t);
        }
    }
}

