/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.gui.BufferSwitcher;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferChanging;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.AntiAlias;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.MouseHandler;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StatusListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.jedit.textarea.TextAreaTransferHandler;
import org.gjt.sp.util.SyntaxUtilities;

public class EditPane
extends JPanel
implements EBComponent,
BufferSetListener {
    private boolean init = true;
    private final View view;
    private static final Map<TextArea, EditPane> paneMap = new HashMap<TextArea, EditPane>();
    private BufferSet bufferSet;
    private Buffer buffer;
    private Buffer recentBuffer;
    private BufferSwitcher bufferSwitcher;
    private final JEditTextArea textArea;
    private final MarkerHighlight markerHighlight;
    private static final String CARETS = "Buffer->caret";

    public View getView() {
        return this.view;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.setBuffer(buffer, true);
    }

    public void setBuffer(final Buffer buffer, boolean requestFocus) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (this.buffer == buffer) {
            return;
        }
        if (this.bufferSet.indexOf(buffer) == -1) {
            jEdit.getBufferSetManager().addBuffer(this, buffer);
        }
        EditBus.send(new BufferChanging(this, buffer));
        if (this.bufferSet.indexOf(this.buffer) != -1) {
            this.recentBuffer = this.buffer;
        }
        if (this.recentBuffer != null) {
            this.saveCaretInfo();
        }
        this.buffer = buffer;
        this.textArea.setBuffer(buffer);
        if (!this.init) {
            this.view.updateTitle();
            if (this.bufferSwitcher != null) {
                if (this.bufferSwitcher.getSelectedItem() != buffer) {
                    this.bufferSwitcher.setSelectedItem(buffer);
                }
                this.bufferSwitcher.setToolTipText(buffer.getPath());
            }
            EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.BUFFER_CHANGED));
        }
        if (requestFocus) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!(EditPane.this.view.getEditPane() != EditPane.this || EditPane.this.bufferSwitcher != null && EditPane.this.bufferSwitcher.isPopupVisible())) {
                        EditPane.this.textArea.requestFocus();
                    }
                }
            });
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (buffer == EditPane.this.getBuffer()) {
                    EditPane.this.loadCaretInfo();
                }
            }
        };
        if (buffer.isPerformingIO()) {
            VFSManager.runInAWTThread(runnable);
        } else {
            runnable.run();
        }
    }

    public void prevBuffer() {
        Buffer buffer = this.bufferSet.getPreviousBuffer(this.bufferSet.indexOf(this.buffer));
        this.setBuffer(buffer);
    }

    public void nextBuffer() {
        Buffer buffer = this.bufferSet.getNextBuffer(this.bufferSet.indexOf(this.buffer));
        this.setBuffer(buffer);
    }

    public void recentBuffer() {
        if (this.recentBuffer != null) {
            this.setBuffer(this.recentBuffer);
        } else {
            this.getToolkit().beep();
        }
    }

    public void focusOnTextArea() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditPane.this.textArea.requestFocus();
            }
        });
    }

    public JEditTextArea getTextArea() {
        return this.textArea;
    }

    public BufferSwitcher getBufferSwitcher() {
        return this.bufferSwitcher;
    }

    public void showBufferSwitcher() {
        if (this.bufferSwitcher == null) {
            this.getToolkit().beep();
        } else {
            this.bufferSwitcher.requestFocus();
            this.bufferSwitcher.showPopup();
        }
    }

    public void saveCaretInfo() {
        CaretInfo caretInfo;
        if (!this.buffer.isLoaded()) {
            return;
        }
        this.buffer.setIntegerProperty("Buffer__caret", this.textArea.getCaretPosition());
        HashMap<String, CaretInfo> carets = (HashMap<String, CaretInfo>)this.getClientProperty(CARETS);
        if (carets == null) {
            carets = new HashMap<String, CaretInfo>();
            this.putClientProperty(CARETS, carets);
        }
        if ((caretInfo = (CaretInfo)carets.get(this.buffer.getPath())) == null) {
            caretInfo = new CaretInfo();
            carets.put(this.buffer.getPath(), caretInfo);
        }
        caretInfo.caret = this.textArea.getCaretPosition();
        Selection[] selection = this.textArea.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = (Selection)selection[i].clone();
        }
        this.buffer.setProperty("Buffer__selection", selection);
        caretInfo.selection = selection;
        caretInfo.rectangularSelection = this.textArea.isRectangularSelectionEnabled();
        caretInfo.multipleSelection = this.textArea.isMultipleSelectionEnabled();
        this.buffer.setIntegerProperty("Buffer__scrollVert", this.textArea.getFirstPhysicalLine());
        caretInfo.scrollVert = this.textArea.getFirstPhysicalLine();
        this.buffer.setIntegerProperty("Buffer__scrollHoriz", this.textArea.getHorizontalOffset());
        caretInfo.scrollHoriz = this.textArea.getHorizontalOffset();
        if (!this.buffer.isUntitled()) {
            BufferHistory.setEntry(this.buffer.getPath(), this.textArea.getCaretPosition(), (Selection[])this.buffer.getProperty("Buffer__selection"), this.buffer.getStringProperty("encoding"), this.buffer.getMode().getName());
        }
    }

    public void loadCaretInfo() {
        int horizontalOffset;
        Selection[] selection;
        int caret;
        CaretInfo caretInfo;
        HashMap carets = (HashMap)this.getClientProperty(CARETS);
        if (carets == null) {
            carets = new HashMap();
            this.putClientProperty(CARETS, carets);
        }
        if ((caretInfo = (CaretInfo)carets.get(this.buffer.getPath())) == null) {
            caretInfo = new CaretInfo();
        }
        if ((caret = caretInfo.caret) == -1 || this.buffer.getBooleanProperty("Buffer__caretPositioned")) {
            Integer i = (Integer)this.buffer.getProperty("Buffer__caret");
            caret = i == null ? -1 : i;
        }
        this.buffer.unsetProperty("Buffer__caretPositioned");
        if (caret != -1) {
            this.textArea.setCaretPosition(Math.min(caret, this.buffer.getLength()));
        }
        if ((selection = caretInfo.selection) == null) {
            selection = (Selection[])this.buffer.getProperty("Buffer__selection");
        }
        if (selection != null) {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                int max = this.buffer.getLength();
                if (s.getStart() <= max && s.getEnd() <= max) continue;
                selection[i] = null;
            }
        }
        this.textArea.setSelection(selection);
        this.textArea.setRectangularSelectionEnabled(caretInfo.rectangularSelection);
        this.textArea.setMultipleSelectionEnabled(caretInfo.multipleSelection);
        int firstLine = caretInfo.scrollVert;
        if (firstLine == -1) {
            Integer i = (Integer)this.buffer.getProperty("Buffer__scrollVert");
            int n = firstLine = i == null ? -1 : i;
        }
        if (firstLine != -1) {
            this.textArea.setFirstPhysicalLine(firstLine);
        }
        if ((horizontalOffset = caretInfo.scrollHoriz) == -1) {
            Integer i = (Integer)this.buffer.getProperty("Buffer__scrollHoriz");
            int n = horizontalOffset = i == null ? -1 : i;
        }
        if (horizontalOffset != -1) {
            this.textArea.setHorizontalOffset(horizontalOffset);
        }
        this.view.getStatus().setMessage(null);
    }

    void bufferRenamed(String oldPath, String newPath) {
        Map carets = (Map)this.getClientProperty(CARETS);
        if (carets == null) {
            return;
        }
        CaretInfo caretInfo = (CaretInfo)carets.remove(oldPath);
        if (caretInfo != null) {
            carets.put(newPath, caretInfo);
        }
    }

    public void goToNextMarker(boolean select) {
        Vector<Marker> markers = this.buffer.getMarkers();
        if (markers.isEmpty()) {
            this.getToolkit().beep();
            return;
        }
        Marker marker = null;
        int caret = this.textArea.getCaretPosition();
        for (int i = 0; i < markers.size(); ++i) {
            Marker _marker = (Marker)markers.get(i);
            if (_marker.getPosition() <= caret) continue;
            marker = _marker;
            break;
        }
        if (marker == null) {
            marker = (Marker)markers.get(0);
        }
        if (select) {
            this.textArea.extendSelection(caret, marker.getPosition());
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(marker.getPosition());
    }

    public void goToPrevMarker(boolean select) {
        Vector<Marker> markers = this.buffer.getMarkers();
        if (markers.isEmpty()) {
            this.getToolkit().beep();
            return;
        }
        int caret = this.textArea.getCaretPosition();
        Marker marker = null;
        for (int i = markers.size() - 1; i >= 0; --i) {
            Marker _marker = (Marker)markers.get(i);
            if (_marker.getPosition() >= caret) continue;
            marker = _marker;
            break;
        }
        if (marker == null) {
            marker = (Marker)markers.get(markers.size() - 1);
        }
        if (select) {
            this.textArea.extendSelection(caret, marker.getPosition());
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(marker.getPosition());
    }

    public void goToMarker(char shortcut, boolean select) {
        Marker marker = this.buffer.getMarker(shortcut);
        if (marker == null) {
            this.getToolkit().beep();
            return;
        }
        int pos = marker.getPosition();
        if (select) {
            this.textArea.extendSelection(this.textArea.getCaretPosition(), pos);
        } else if (!this.textArea.isMultipleSelectionEnabled()) {
            this.textArea.selectNone();
        }
        this.textArea.moveCaretPosition(pos);
    }

    public void addMarker() {
        int caretLine = this.textArea.getCaretLine();
        Selection[] selection = this.textArea.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            Selection s = selection[i];
            if (s.getStartLine() != s.getEndLine() && s.getStartLine() != caretLine) {
                this.buffer.addMarker('\u0000', s.getStart());
            }
            if (s.getEndLine() == caretLine) continue;
            this.buffer.addMarker('\u0000', s.getEnd());
        }
        this.buffer.addOrRemoveMarker('\u0000', this.textArea.getCaretPosition());
    }

    public void swapMarkerAndCaret(char shortcut) {
        Marker marker = this.buffer.getMarker(shortcut);
        if (marker == null) {
            this.getToolkit().beep();
            return;
        }
        int caret = this.textArea.getCaretPosition();
        this.textArea.setCaretPosition(marker.getPosition());
        this.buffer.addMarker(shortcut, caret);
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
            this.loadBufferSwitcher();
        } else if (msg instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)msg);
        }
    }

    public final Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public BufferSet getBufferSet() {
        return this.bufferSet;
    }

    public void setBufferSet() {
        BufferSet.Scope mode = BufferSet.Scope.fromString(jEdit.getProperty("editpane.bufferset.default"));
        switch (mode) {
            case view: {
                this.setBufferSet(jEdit.getBufferSetManager().getViewBufferSet(this.view));
                break;
            }
            case editpane: {
                this.setBufferSet(jEdit.getBufferSetManager().getEditPaneBufferSet(this));
                break;
            }
            case global: {
                this.setBufferSet(jEdit.getBufferSetManager().getGlobalBufferSet());
            }
        }
    }

    public void setBufferSet(BufferSet bufferSet) {
        if (this.bufferSet != bufferSet) {
            BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
            String action = jEdit.getProperty("editpane.bufferset.new");
            BufferSetManager.NewBufferSetAction bufferSetAction = BufferSetManager.NewBufferSetAction.fromString(action);
            switch (bufferSetAction) {
                case copy: {
                    if (this.bufferSet == null) {
                        bufferSetManager.addAllBuffers(bufferSet);
                        break;
                    }
                    bufferSetManager.mergeBufferSet(bufferSet, this.bufferSet);
                    break;
                }
                case empty: {
                    break;
                }
                case currentbuffer: {
                    View activeView = jEdit.getActiveView();
                    if (activeView == null) break;
                    EditPane editPane = activeView.getEditPane();
                    Buffer buffer = editPane.getBuffer();
                    bufferSetManager.addBuffer(bufferSet, buffer);
                }
            }
            if (this.bufferSet != null) {
                this.bufferSet.removeBufferSetListener(this);
            }
            if (this.buffer != null) {
                bufferSetManager.addBuffer(bufferSet, this.buffer);
            }
            if (bufferSet.size() == 0) {
                int untitledCount = jEdit.getNextUntitledBufferId();
                Buffer newEmptyBuffer = jEdit.openTemporary(jEdit.getActiveView(), null, "Untitled-" + untitledCount, true, null);
                jEdit.commitTemporary(newEmptyBuffer);
                bufferSetManager.addBuffer(bufferSet, newEmptyBuffer);
            }
            this.bufferSet = bufferSet;
            bufferSet.addBufferSetListener(this);
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.BUFFERSET_CHANGED));
            if (bufferSet.indexOf(this.recentBuffer) == -1) {
                this.recentBuffer = null;
            }
            if (bufferSet.size() != 0 && bufferSet.indexOf(this.buffer) == -1) {
                if (this.recentBuffer != null) {
                    this.setBuffer(this.recentBuffer);
                } else {
                    this.setBuffer(bufferSet.getBuffer(0));
                }
            }
            PerspectiveManager.setPerspectiveDirty(true);
        }
    }

    public void bufferAdded(Buffer buffer, int index) {
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
        if (this.bufferSet.indexOf(this.buffer) == -1) {
            this.setBuffer(buffer);
        }
    }

    public void bufferRemoved(Buffer buffer, int index) {
        Map carets;
        if (buffer.isUntitled() && (carets = (Map)this.getClientProperty(CARETS)) != null) {
            carets.remove(buffer.getPath());
        }
        if (buffer == this.buffer) {
            Buffer newBuffer;
            Buffer buffer2 = newBuffer = this.recentBuffer != null ? this.recentBuffer : this.bufferSet.getPreviousBuffer(index);
            if (newBuffer != null && !newBuffer.isClosed()) {
                this.setBuffer(newBuffer);
                if (this.bufferSet.size() > 1) {
                    this.recentBuffer = this.bufferSet.getPreviousBuffer(index - 1);
                }
            } else if (this.bufferSet.size() != 0) {
                this.setBuffer(this.bufferSet.getBuffer(0));
                this.recentBuffer = null;
            }
        }
        if (buffer == this.recentBuffer) {
            this.recentBuffer = null;
        }
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
    }

    public void bufferMoved(Buffer buffer, int oldIndex, int newIndex) {
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.updateBufferList();
        }
    }

    public void bufferCleared() {
        int untitledCount = jEdit.getNextUntitledBufferId();
        Buffer newEmptyBuffer = jEdit.openTemporary(jEdit.getActiveView(), null, "Untitled-" + untitledCount, true, null);
        jEdit.commitTemporary(newEmptyBuffer);
        jEdit.getBufferSetManager().addBuffer(this.bufferSet, newEmptyBuffer);
        this.setBuffer(newEmptyBuffer);
    }

    public String toString() {
        return this.getClass().getName() + '[' + (this.view.getEditPane() == this ? "active" : "inactive") + ',' + (Object)((Object)this.bufferSet.getScope()) + ']';
    }

    EditPane(View view, Buffer buffer) {
        super(new BorderLayout());
        this.view = view;
        this.textArea = new JEditTextArea(view);
        paneMap.put(this.textArea, this);
        this.textArea.getPainter().setAntiAlias(new AntiAlias(jEdit.getProperty("view.antiAlias")));
        this.textArea.setMouseHandler(new MouseHandler(this.textArea));
        this.textArea.setTransferHandler(new TextAreaTransferHandler());
        this.markerHighlight = new MarkerHighlight();
        this.textArea.getGutter().addExtension(this.markerHighlight);
        this.textArea.addStatusListener(new StatusHandler());
        this.add("Center", this.textArea);
        this.propertiesChanged();
        this.buffer = buffer;
        this.setBufferSet();
        this.buffer = null;
        if (buffer == null) {
            Buffer b = this.bufferSet.getBuffer(0);
            if (b == null) {
                this.setBuffer(jEdit.getFirstBuffer());
            } else {
                this.setBuffer(b);
            }
        } else {
            this.setBuffer(buffer);
        }
        this.loadBufferSwitcher();
        this.init = false;
        EditBus.addToBus(this);
    }

    void close() {
        paneMap.remove(this.textArea);
        this.saveCaretInfo();
        EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.DESTROYED));
        EditBus.removeFromBus(this);
        this.textArea.dispose();
    }

    public static EditPane get(TextArea ta) {
        return paneMap.get(ta);
    }

    private void propertiesChanged() {
        TextAreaPainter painter = this.textArea.getPainter();
        EditPane.initPainter(painter);
        Gutter gutter = this.textArea.getGutter();
        gutter.setExpanded(jEdit.getBooleanProperty("view.gutter.lineNumbers"));
        int interval = jEdit.getIntegerProperty("view.gutter.highlightInterval", 5);
        gutter.setHighlightInterval(interval);
        gutter.setCurrentLineHighlightEnabled(jEdit.getBooleanProperty("view.gutter.highlightCurrentLine"));
        gutter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.gutter.structureHighlight"));
        gutter.setStructureHighlightColor(jEdit.getColorProperty("view.gutter.structureHighlightColor"));
        gutter.setBackground(jEdit.getColorProperty("view.gutter.bgColor"));
        gutter.setForeground(jEdit.getColorProperty("view.gutter.fgColor"));
        gutter.setHighlightedForeground(jEdit.getColorProperty("view.gutter.highlightColor"));
        gutter.setFoldColor(jEdit.getColorProperty("view.gutter.foldColor"));
        this.markerHighlight.setMarkerHighlightColor(jEdit.getColorProperty("view.gutter.markerColor"));
        this.markerHighlight.setMarkerHighlightEnabled(jEdit.getBooleanProperty("view.gutter.markerHighlight"));
        gutter.setCurrentLineForeground(jEdit.getColorProperty("view.gutter.currentLineColor"));
        String alignment = jEdit.getProperty("view.gutter.numberAlignment");
        if ("right".equals(alignment)) {
            gutter.setLineNumberAlignment(4);
        } else if ("center".equals(alignment)) {
            gutter.setLineNumberAlignment(0);
        } else {
            gutter.setLineNumberAlignment(2);
        }
        gutter.setFont(jEdit.getFontProperty("view.gutter.font"));
        int width = jEdit.getIntegerProperty("view.gutter.borderWidth", 3);
        gutter.setBorder(width, jEdit.getColorProperty("view.gutter.focusBorderColor"), jEdit.getColorProperty("view.gutter.noFocusBorderColor"), this.textArea.getPainter().getBackground());
        this.textArea.setCaretBlinkEnabled(jEdit.getBooleanProperty("view.caretBlink"));
        this.textArea.setElectricScroll(jEdit.getIntegerProperty("view.electricBorders", 0));
        JPopupMenu popup = GUIUtilities.loadPopupMenu("view.context", this.getTextArea(), null);
        JMenuItem customize = new JMenuItem(jEdit.getProperty("view.context.customize"));
        customize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new GlobalOptions((Frame)EditPane.this.view, "context");
            }
        });
        popup.addSeparator();
        popup.add(customize);
        this.textArea.setRightClickPopup(popup);
        this.textArea.setQuickCopyEnabled(jEdit.getBooleanProperty("view.middleMousePaste"));
        this.textArea.setDragEnabled(jEdit.getBooleanProperty("view.dragAndDrop"));
        this.textArea.setJoinNonWordChars(jEdit.getBooleanProperty("view.joinNonWordChars"));
        this.textArea.setCtrlForRectangularSelection(jEdit.getBooleanProperty("view.ctrlForRectangularSelection"));
        this.textArea.propertiesChanged();
        if (this.bufferSwitcher != null) {
            this.bufferSwitcher.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        }
    }

    public static void initPainter(TextAreaPainter painter) {
        painter.setFont(jEdit.getFontProperty("view.font"));
        painter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.structureHighlight"));
        painter.setStructureHighlightColor(jEdit.getColorProperty("view.structureHighlightColor"));
        painter.setEOLMarkersPainted(jEdit.getBooleanProperty("view.eolMarkers"));
        painter.setEOLMarkerColor(jEdit.getColorProperty("view.eolMarkerColor"));
        painter.setWrapGuidePainted(jEdit.getBooleanProperty("view.wrapGuide"));
        painter.setWrapGuideColor(jEdit.getColorProperty("view.wrapGuideColor"));
        painter.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        painter.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        painter.setMultipleSelectionColor(jEdit.getColorProperty("view.multipleSelectionColor"));
        painter.setBackground(jEdit.getColorProperty("view.bgColor"));
        painter.setForeground(jEdit.getColorProperty("view.fgColor"));
        painter.setBlockCaretEnabled(jEdit.getBooleanProperty("view.blockCaret"));
        painter.setThickCaretEnabled(jEdit.getBooleanProperty("view.thickCaret"));
        painter.setLineHighlightEnabled(jEdit.getBooleanProperty("view.lineHighlight"));
        painter.setLineHighlightColor(jEdit.getColorProperty("view.lineHighlightColor"));
        painter.setAntiAlias(new AntiAlias(jEdit.getProperty("view.antiAlias")));
        painter.setFractionalFontMetricsEnabled(jEdit.getBooleanProperty("view.fracFontMetrics"));
        String defaultFont = jEdit.getProperty("view.font");
        int defaultFontSize = jEdit.getIntegerProperty("view.fontsize", 12);
        painter.setStyles(SyntaxUtilities.loadStyles(defaultFont, defaultFontSize));
        SyntaxStyle[] foldLineStyle = new SyntaxStyle[4];
        for (int i = 0; i <= 3; ++i) {
            foldLineStyle[i] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.foldLine." + i), defaultFont, defaultFontSize);
        }
        painter.setFoldLineStyle(foldLineStyle);
    }

    private void loadBufferSwitcher() {
        if (jEdit.getBooleanProperty("view.showBufferSwitcher")) {
            if (this.bufferSwitcher == null) {
                this.bufferSwitcher = new BufferSwitcher(this);
                this.add("North", this.bufferSwitcher);
                this.bufferSwitcher.updateBufferList();
                this.revalidate();
            }
        } else if (this.bufferSwitcher != null) {
            this.remove(this.bufferSwitcher);
            this.revalidate();
            this.bufferSwitcher = null;
        }
    }

    private void handleBufferUpdate(BufferUpdate msg) {
        Buffer _buffer = msg.getBuffer();
        if (msg.getWhat() == BufferUpdate.CREATED) {
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (this.buffer.isClosed()) {
                this.recentBuffer = null;
            }
        } else if (msg.getWhat() == BufferUpdate.CLOSED) {
            Map carets;
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (_buffer == this.buffer) {
                Buffer newBuffer;
                Buffer buffer = newBuffer = this.recentBuffer != null ? this.recentBuffer : _buffer.getPrev();
                if (newBuffer != null && !newBuffer.isClosed()) {
                    this.setBuffer(newBuffer);
                    this.recentBuffer = newBuffer.getPrev();
                }
            } else if (_buffer == this.recentBuffer) {
                this.recentBuffer = null;
            }
            Buffer closedBuffer = msg.getBuffer();
            if (closedBuffer.isUntitled() && (carets = (Map)this.getClientProperty(CARETS)) != null) {
                carets.remove(closedBuffer.getPath());
            }
        } else if (msg.getWhat() == BufferUpdate.LOAD_STARTED) {
            if (_buffer == this.buffer) {
                this.textArea.setCaretPosition(0);
                this.textArea.getPainter().repaint();
            }
        } else if (msg.getWhat() == BufferUpdate.LOADED) {
            if (_buffer == this.buffer) {
                this.textArea.repaint();
                if (this.bufferSwitcher != null) {
                    this.bufferSwitcher.updateBufferList();
                }
                if (this.view.getEditPane() == this) {
                    StatusBar status = this.view.getStatus();
                    status.updateCaretStatus();
                    status.updateBufferStatus();
                    status.updateMiscStatus();
                }
                this.loadCaretInfo();
            }
        } else if (msg.getWhat() == BufferUpdate.DIRTY_CHANGED) {
            if (_buffer == this.buffer && this.bufferSwitcher != null) {
                if (this.buffer.isDirty()) {
                    this.bufferSwitcher.repaint();
                } else {
                    this.bufferSwitcher.updateBufferList();
                }
            }
        } else if (msg.getWhat() == BufferUpdate.MARKERS_CHANGED) {
            if (_buffer == this.buffer) {
                this.textArea.getGutter().repaint();
            }
        } else if (msg.getWhat() == BufferUpdate.PROPERTIES_CHANGED) {
            if (_buffer == this.buffer && this.buffer.isLoaded()) {
                this.textArea.propertiesChanged();
                if (this.view.getEditPane() == this) {
                    this.view.getStatus().updateBufferStatus();
                }
            }
        } else if (msg.getWhat() == BufferUpdate.SAVED && _buffer == this.buffer) {
            this.textArea.propertiesChanged();
        }
    }

    class MarkerHighlight
    extends TextAreaExtension {
        private boolean markerHighlight;
        private Color markerHighlightColor;

        MarkerHighlight() {
        }

        public Color getMarkerHighlightColor() {
            return this.markerHighlightColor;
        }

        public void setMarkerHighlightColor(Color markerHighlightColor) {
            this.markerHighlightColor = markerHighlightColor;
        }

        public boolean isMarkerHighlightEnabled() {
            return this.markerHighlight;
        }

        public void setMarkerHighlightEnabled(boolean markerHighlight) {
            this.markerHighlight = markerHighlight;
        }

        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            Buffer buffer;
            if (this.isMarkerHighlightEnabled() && (buffer = (Buffer)EditPane.this.textArea.getBuffer()).getMarkerInRange(start, end) != null) {
                gfx.setColor(this.getMarkerHighlightColor());
                FontMetrics fm = EditPane.this.textArea.getPainter().getFontMetrics();
                gfx.fillRect(0, y, EditPane.this.textArea.getGutter().getWidth(), fm.getHeight());
            }
        }

        public String getToolTipText(int x, int y) {
            if (this.isMarkerHighlightEnabled()) {
                int lineHeight = EditPane.this.textArea.getPainter().getFontMetrics().getHeight();
                if (lineHeight == 0) {
                    return null;
                }
                int line = y / lineHeight;
                int start = EditPane.this.textArea.getScreenLineStartOffset(line);
                int end = EditPane.this.textArea.getScreenLineEndOffset(line);
                if (start == -1 || end == -1) {
                    return null;
                }
                Buffer buffer = (Buffer)EditPane.this.textArea.getBuffer();
                Marker marker = buffer.getMarkerInRange(start, end);
                if (marker != null) {
                    char shortcut = marker.getShortcut();
                    if (shortcut == '\u0000') {
                        return jEdit.getProperty("view.gutter.marker.no-name");
                    }
                    Object[] args = new String[]{String.valueOf(shortcut)};
                    return jEdit.getProperty("view.gutter.marker", args);
                }
            }
            return null;
        }
    }

    class StatusHandler
    implements StatusListener {
        StatusHandler() {
        }

        public void statusChanged(TextArea textArea, int flag, boolean value) {
            StatusBar status = EditPane.this.view.getStatus();
            if (status == null) {
                return;
            }
            switch (flag) {
                case 0: {
                    status.setMessageAndClear(jEdit.getProperty("view.status.overwrite-changed", new Integer[]{value ? 1 : 0}));
                    break;
                }
                case 1: {
                    status.setMessageAndClear(jEdit.getProperty("view.status.multi-changed", new Integer[]{value ? 1 : 0}));
                    break;
                }
                case 2: {
                    status.setMessageAndClear(jEdit.getProperty("view.status.rect-select-changed", new Integer[]{value ? 1 : 0}));
                }
            }
            status.updateMiscStatus();
        }

        public void bracketSelected(TextArea textArea, int line, String text) {
            StatusBar status = EditPane.this.view.getStatus();
            if (status == null) {
                return;
            }
            status.setMessageAndClear(jEdit.getProperty("view.status.bracket", new Object[]{line, text}));
        }

        public void narrowActive(TextArea textArea) {
            StatusBar status = EditPane.this.view.getStatus();
            if (status == null) {
                return;
            }
            status.setMessageAndClear(jEdit.getProperty("view.status.narrow"));
        }
    }

    private static class CaretInfo {
        public int caret = -1;
        public Selection[] selection;
        public int scrollVert = -1;
        public int scrollHoriz = -1;
        public boolean rectangularSelection;
        public boolean multipleSelection;

        private CaretInfo() {
        }
    }
}

