/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.ArrayList;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.util.Log;

public class EditBus {
    private static ArrayList components = new ArrayList();
    private static EBComponent[] copyComponents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToBus(EBComponent comp) {
        ArrayList arrayList = components;
        synchronized (arrayList) {
            components.add(comp);
            copyComponents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromBus(EBComponent comp) {
        ArrayList arrayList = components;
        synchronized (arrayList) {
            components.remove(comp);
            copyComponents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EBComponent[] getComponents() {
        ArrayList arrayList = components;
        synchronized (arrayList) {
            if (copyComponents == null) {
                copyComponents = components.toArray(new EBComponent[components.size()]);
            }
            return copyComponents;
        }
    }

    public static void send(EBMessage message) {
        Log.log(1, EditBus.class, message.toString());
        EBComponent[] comps = EditBus.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            try {
                EBComponent comp = comps[i];
                if (Debug.EB_TIMER) {
                    long start = System.currentTimeMillis();
                    comp.handleMessage(message);
                    long time = System.currentTimeMillis() - start;
                    if (time == 0L) continue;
                    Log.log(1, EditBus.class, comp + ": " + time + " ms");
                    continue;
                }
                comps[i].handleMessage(message);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, EditBus.class, "Exception while sending message on EditBus:");
                Log.log(9, EditBus.class, t);
            }
        }
    }

    private EditBus() {
    }
}

