/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.AddAbbrevDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Abbrevs {
    public static final String ENCODING = "UTF8";
    private static boolean loaded;
    private static boolean abbrevsChanged;
    private static long abbrevsModTime;
    private static boolean expandOnInput;
    private static Hashtable<String, String> globalAbbrevs;
    private static Hashtable<String, Hashtable<String, String>> modes;
    private static Vector<String> m_pp;

    public static boolean getExpandOnInput() {
        return expandOnInput;
    }

    public static void setExpandOnInput(boolean expandOnInput) {
        Abbrevs.expandOnInput = expandOnInput;
    }

    public static boolean expandAbbrev(View view, boolean add) {
        String abbrev;
        int wordStart;
        Buffer buffer = view.getBuffer();
        JEditTextArea textArea = view.getTextArea();
        if (!buffer.isEditable()) {
            view.getToolkit().beep();
            return false;
        }
        int line = textArea.getCaretLine();
        int lineStart = buffer.getLineStartOffset(line);
        int caret = textArea.getCaretPosition();
        String lineText = buffer.getLineText(line);
        if (lineText.length() == 0) {
            if (add) {
                view.getToolkit().beep();
            }
            return false;
        }
        int pos = caret - lineStart;
        if (pos == 0) {
            if (add) {
                view.getToolkit().beep();
            }
            return false;
        }
        m_pp.removeAllElements();
        if (lineText.charAt(pos - 1) == '#') {
            wordStart = lineText.indexOf(35);
            wordStart = TextUtilities.findWordStart(lineText, wordStart, buffer.getStringProperty("noWordSep") + '#');
            abbrev = lineText.substring(wordStart, pos - 1);
            int lastIndex = 0;
            for (int i = 0; i < abbrev.length(); ++i) {
                if (abbrev.charAt(i) != '#') continue;
                m_pp.addElement(abbrev.substring(lastIndex, i));
                lastIndex = i + 1;
            }
            m_pp.addElement(abbrev.substring(lastIndex));
            abbrev = m_pp.elementAt(0);
            m_pp.removeElementAt(0);
        } else {
            wordStart = TextUtilities.findWordStart(lineText, pos - 1, buffer.getStringProperty("noWordSep"));
            abbrev = lineText.substring(wordStart, pos);
        }
        Expansion expand = Abbrevs.expandAbbrev(buffer.getMode().getName(), abbrev, buffer.getBooleanProperty("noTabs") ? buffer.getTabSize() : 0, m_pp);
        if (expand == null) {
            if (add) {
                new AddAbbrevDialog(view, abbrev);
            }
            return false;
        }
        buffer.remove(lineStart + wordStart, pos - wordStart);
        int whitespace = buffer.insertIndented(lineStart + wordStart, expand.text);
        int newlines = Abbrevs.countNewlines(expand.text, expand.caretPosition);
        if (expand.caretPosition != -1) {
            textArea.setCaretPosition(lineStart + wordStart + expand.caretPosition + newlines * whitespace);
        }
        if (expand.posParamCount != m_pp.size()) {
            view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.incomplete-abbrev", new Integer[]{m_pp.size(), expand.posParamCount}));
        }
        return true;
    }

    public static Hashtable<String, String> getGlobalAbbrevs() {
        if (!loaded) {
            Abbrevs.load();
        }
        return globalAbbrevs;
    }

    public static void setGlobalAbbrevs(Hashtable<String, String> globalAbbrevs) {
        abbrevsChanged = true;
        Abbrevs.globalAbbrevs = globalAbbrevs;
    }

    public static Hashtable<String, Hashtable<String, String>> getModeAbbrevs() {
        if (!loaded) {
            Abbrevs.load();
        }
        return modes;
    }

    public static void setModeAbbrevs(Hashtable<String, Hashtable<String, String>> modes) {
        abbrevsChanged = true;
        Abbrevs.modes = modes;
    }

    public static void addGlobalAbbrev(String abbrev, String expansion) {
        if (!loaded) {
            Abbrevs.load();
        }
        globalAbbrevs.put(abbrev, expansion);
        abbrevsChanged = true;
    }

    public static void addModeAbbrev(String mode, String abbrev, String expansion) {
        Hashtable<String, String> modeAbbrevs;
        if (!loaded) {
            Abbrevs.load();
        }
        if ((modeAbbrevs = modes.get(mode)) == null) {
            modeAbbrevs = new Hashtable();
            modes.put(mode, modeAbbrevs);
        }
        modeAbbrevs.put(abbrev, expansion);
        abbrevsChanged = true;
    }

    static void save() {
        jEdit.setBooleanProperty("view.expandOnInput", expandOnInput);
        String settings = jEdit.getSettingsDirectory();
        if (abbrevsChanged && settings != null) {
            File file1 = new File(MiscUtilities.constructPath(settings, "#abbrevs#save#"));
            File file2 = new File(MiscUtilities.constructPath(settings, "abbrevs"));
            if (file2.exists() && file2.lastModified() != abbrevsModTime) {
                Log.log(7, Abbrevs.class, file2 + " changed on disk;" + " will not save abbrevs");
            } else {
                jEdit.backupSettingsFile(file2);
                try {
                    Abbrevs.saveAbbrevs(new OutputStreamWriter((OutputStream)new FileOutputStream(file1), ENCODING));
                    file2.delete();
                    file1.renameTo(file2);
                }
                catch (Exception e) {
                    Log.log(9, Abbrevs.class, "Error while saving " + file1);
                    Log.log(9, Abbrevs.class, e);
                }
                abbrevsModTime = file2.lastModified();
            }
        }
    }

    private Abbrevs() {
    }

    private static void load() {
        globalAbbrevs = new Hashtable();
        modes = new Hashtable();
        String settings = jEdit.getSettingsDirectory();
        if (settings != null) {
            File file = new File(MiscUtilities.constructPath(settings, "abbrevs"));
            abbrevsModTime = file.lastModified();
            try {
                Abbrevs.loadAbbrevs(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
                loaded = true;
            }
            catch (FileNotFoundException fnf) {
            }
            catch (Exception e) {
                Log.log(9, Abbrevs.class, "Error while loading " + file);
                Log.log(9, Abbrevs.class, e);
            }
        }
        if (!loaded) {
            try {
                Abbrevs.loadAbbrevs(new InputStreamReader(Abbrevs.class.getResourceAsStream("default.abbrevs"), ENCODING));
            }
            catch (Exception e) {
                Log.log(9, Abbrevs.class, "Error while loading default.abbrevs");
                Log.log(9, Abbrevs.class, e);
            }
            loaded = true;
        }
    }

    private static int countNewlines(String s, int end) {
        int counter = 0;
        for (int i = 0; i < end; ++i) {
            if (s.charAt(i) != '\n') continue;
            ++counter;
        }
        return counter;
    }

    private static Expansion expandAbbrev(String mode, String abbrev, int softTabSize, Vector<String> pp) {
        m_pp = pp;
        if (!loaded) {
            Abbrevs.load();
        }
        String expand = null;
        Hashtable<String, String> modeAbbrevs = modes.get(mode);
        if (modeAbbrevs != null) {
            expand = modeAbbrevs.get(abbrev);
        }
        if (expand == null) {
            expand = globalAbbrevs.get(abbrev);
        }
        if (expand == null) {
            return null;
        }
        return new Expansion(expand, softTabSize, m_pp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAbbrevs(Reader _in) throws Exception {
        BufferedReader in = new BufferedReader(_in);
        try {
            String line;
            Hashtable<String, String> currentAbbrevs = globalAbbrevs;
            while ((line = in.readLine()) != null) {
                int index = line.indexOf(124);
                if (line.length() == 0) continue;
                if (line.startsWith("[") && index == -1) {
                    if (line.equals("[global]")) {
                        currentAbbrevs = globalAbbrevs;
                        continue;
                    }
                    String mode = line.substring(1, line.length() - 1);
                    currentAbbrevs = modes.get(mode);
                    if (currentAbbrevs != null) continue;
                    currentAbbrevs = new Hashtable();
                    modes.put(mode, currentAbbrevs);
                    continue;
                }
                if (index == -1) continue;
                currentAbbrevs.put(line.substring(0, index), line.substring(index + 1));
            }
        }
        finally {
            in.close();
        }
    }

    private static void saveAbbrevs(Writer _out) throws Exception {
        BufferedWriter out = new BufferedWriter(_out);
        String lineSep = System.getProperty("line.separator");
        out.write("[global]");
        out.write(lineSep);
        Abbrevs.saveAbbrevs(out, globalAbbrevs);
        Enumeration<String> keys = modes.keys();
        Enumeration<Hashtable<String, String>> values = modes.elements();
        while (keys.hasMoreElements()) {
            out.write(91);
            out.write(keys.nextElement());
            out.write(93);
            out.write(lineSep);
            Abbrevs.saveAbbrevs(out, values.nextElement());
        }
        out.close();
    }

    private static void saveAbbrevs(Writer out, Hashtable<String, String> abbrevs) throws Exception {
        String lineSep = System.getProperty("line.separator");
        Enumeration<String> keys = abbrevs.keys();
        Enumeration<String> values = abbrevs.elements();
        while (keys.hasMoreElements()) {
            String abbrev = keys.nextElement();
            out.write(abbrev);
            out.write(124);
            out.write(values.nextElement());
            out.write(lineSep);
        }
    }

    static {
        m_pp = new Vector();
        expandOnInput = jEdit.getBooleanProperty("view.expandOnInput");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Expansion {
        String text;
        int caretPosition = -1;
        int lineCount;
        int posParamCount;

        Expansion(String text, int softTabSize, List<String> pp) {
            StringBuilder buf = new StringBuilder();
            boolean backslash = false;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (backslash) {
                    backslash = false;
                    if (ch == '|') {
                        this.caretPosition = buf.length();
                        continue;
                    }
                    if (ch == 'n') {
                        buf.append('\n');
                        ++this.lineCount;
                        continue;
                    }
                    if (ch == 't') {
                        if (softTabSize == 0) {
                            buf.append('\t');
                            continue;
                        }
                        for (int j = 0; j < softTabSize; ++j) {
                            buf.append(' ');
                        }
                        continue;
                    }
                    buf.append(ch);
                    continue;
                }
                if (ch == '\\') {
                    backslash = true;
                    continue;
                }
                if (ch == '$') {
                    if (i != text.length() - 1) {
                        ch = text.charAt(i + 1);
                        if (Character.isDigit(ch) && ch != '0') {
                            ++i;
                            int pos = ch - 48;
                            this.posParamCount = Math.max(pos, this.posParamCount);
                            if (pos > pp.size()) continue;
                            buf.append(pp.get(pos - 1));
                            continue;
                        }
                        buf.append('$');
                        continue;
                    }
                    buf.append('$');
                    continue;
                }
                buf.append(ch);
            }
            this.text = buf.toString();
        }
    }
}

