/*
 * Decompiled with CFR 0.152.
 */
package whitespace;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Hashtable;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import whitespace.WhiteSpaceModel;

public class BlockHighlight
extends TextAreaExtension {
    private static Hashtable highlights = new Hashtable();
    private static boolean indentBlock = jEdit.getBooleanProperty((String)"white-space.indent-block", (boolean)true);
    private static Color blockColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.block-color"));
    private JEditTextArea textArea;
    private Segment segment = new Segment();

    private BlockHighlight(JEditTextArea textArea) {
        this.textArea = textArea;
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        WhiteSpaceModel model = this.getModel();
        if (model != null && model.getBlockHighlight().isEnabled()) {
            try {
                if (this.textArea.getLineStartOffset(physicalLine) == -1 || this.textArea.getLineEndOffset(physicalLine) == -1) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            if (physicalLine > 0 && physicalLine < this.textArea.getLineCount() - 1 && this.textArea.getLineEndOffset(physicalLine) - this.textArea.getLineStartOffset(physicalLine) == 1 && this.textArea.getLineEndOffset(physicalLine - 1) - this.textArea.getLineStartOffset(physicalLine - 1) == 1 && this.textArea.getLineEndOffset(physicalLine + 1) - this.textArea.getLineStartOffset(physicalLine + 1) > 1) {
                Point p0 = new Point();
                if (indentBlock) {
                    this.textArea.getLineText(physicalLine + 1, this.segment);
                    int i = 0;
                    int off = this.segment.offset;
                    while (i < this.segment.count) {
                        char c = this.segment.array[off];
                        if (c != ' ' && c != '\t') {
                            this.textArea.offsetToXY(physicalLine + 1, i, p0);
                            break;
                        }
                        ++i;
                        ++off;
                    }
                }
                TextAreaPainter painter = this.textArea.getPainter();
                gfx.setColor(blockColor);
                gfx.drawLine(p0.x, y, painter.getWidth() - 1, y);
            }
        }
    }

    public WhiteSpaceModel getModel() {
        return (WhiteSpaceModel)this.textArea.getBuffer().getProperty((Object)"white-space.model");
    }

    private void updateTextArea() {
        if (this.textArea == null) {
            return;
        }
        DisplayManager displayManager = this.textArea.getDisplayManager();
        int physicalFirst = displayManager.getFirstVisibleLine();
        int physicalLast = displayManager.getLastVisibleLine();
        this.textArea.invalidateLineRange(physicalFirst, physicalLast);
    }

    public static void updateTextAreas(Buffer buffer) {
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditPane[] editPanes = views[i].getEditPanes();
            for (int j = 0; j < editPanes.length; ++j) {
                BlockHighlight highlight;
                if (editPanes[j].getBuffer() != buffer || (highlight = (BlockHighlight)((Object)highlights.get(editPanes[j]))) == null) continue;
                highlight.updateTextArea();
            }
        }
    }

    public static TextAreaExtension addHighlightTo(EditPane editPane) {
        JEditTextArea textArea = editPane.getTextArea();
        TextAreaPainter painter = textArea.getPainter();
        BlockHighlight highlight = null;
        highlight = (BlockHighlight)((Object)painter.getClientProperty((Object)BlockHighlight.class));
        if (highlight == null) {
            highlight = new BlockHighlight(textArea);
            highlights.put(editPane, highlight);
            painter.addExtension(0, (TextAreaExtension)highlight);
            painter.putClientProperty((Object)BlockHighlight.class, (Object)highlight);
        }
        return highlight;
    }

    public static void removeHighlightFrom(EditPane editPane) {
        BlockHighlight highlight = (BlockHighlight)((Object)editPane.getTextArea().getPainter().getClientProperty((Object)BlockHighlight.class));
        if (highlight != null) {
            editPane.getTextArea().getPainter().removeExtension((TextAreaExtension)highlight);
            editPane.getTextArea().getPainter().putClientProperty((Object)BlockHighlight.class, null);
        }
        highlights.remove(editPane);
    }

    public static void propertiesChanged() {
        boolean blockColorChanged;
        boolean newIndentBlock = jEdit.getBooleanProperty((String)"white-space.indent-block", (boolean)true);
        Color newBlockColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.block-color"));
        boolean indentBlockChanged = newIndentBlock != indentBlock;
        boolean bl = blockColorChanged = !newBlockColor.equals(blockColor);
        if (!indentBlockChanged && !blockColorChanged) {
            return;
        }
        indentBlock = newIndentBlock;
        blockColor = newBlockColor;
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditPane[] editPanes = views[i].getEditPanes();
            for (int j = 0; j < editPanes.length; ++j) {
                WhiteSpaceModel model;
                BlockHighlight highlight = (BlockHighlight)((Object)highlights.get(editPanes[j]));
                if (highlight == null || (model = highlight.getModel()) == null || !model.getBlockHighlight().isEnabled()) continue;
                highlight.updateTextArea();
            }
        }
    }
}

