/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class QuickNotepad
extends JPanel
implements EBComponent,
QuickNotepadActions,
DefaultFocusComponent {
    private static final long serialVersionUID = 6412255692894321789L;
    private String filename;
    private String defaultFilename;
    private View view;
    private boolean floating;
    private QuickNotepadTextArea textArea;
    private QuickNotepadToolPanel toolPanel;

    public QuickNotepad(View view, String string) {
        super(new BorderLayout());
        this.view = view;
        this.floating = string.equals("floating");
        if (jEdit.getSettingsDirectory() != null) {
            this.filename = jEdit.getProperty((String)"options.quicknotepad.filepath");
            if (this.filename == null || this.filename.length() == 0) {
                this.filename = new String(jEdit.getSettingsDirectory() + File.separator + "qn.txt");
                jEdit.setProperty((String)"options.quicknotepad.filepath", (String)this.filename);
            }
            this.defaultFilename = this.filename;
        }
        this.toolPanel = new QuickNotepadToolPanel(this);
        this.add("North", this.toolPanel);
        if (this.floating) {
            this.setPreferredSize(new Dimension(500, 250));
        }
        this.textArea = new QuickNotepadTextArea();
        this.textArea.setFont(QuickNotepadOptionPane.makeFont());
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        this.add("Center", jScrollPane);
        this.readFile();
    }

    public void focusOnDefaultComponent() {
        this.textArea.requestFocus();
    }

    public String getFilename() {
        return this.filename;
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    private void propertiesChanged() {
        Font font;
        String string = jEdit.getProperty((String)"options.quicknotepad.filepath");
        if (!StandardUtilities.objectsEqual((Object)this.defaultFilename, (Object)string)) {
            this.saveFile();
            this.toolPanel.propertiesChanged();
            this.filename = this.defaultFilename = string;
            this.readFile();
        }
        if (!(font = QuickNotepadOptionPane.makeFont()).equals(this.textArea.getFont())) {
            this.textArea.setFont(font);
        }
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    public void removeNotify() {
        this.saveFile();
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    public void saveFile() {
        if (this.filename == null || this.filename.length() == 0) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.filename);
            fileWriter.write(this.textArea.getText());
            fileWriter.close();
        }
        catch (IOException iOException) {
            Log.log((int)9, (Object)QuickNotepad.class, (Object)("Could not write notepad text to " + this.filename));
        }
    }

    public void chooseFile() {
        String[] stringArray = GUIUtilities.showVFSFileDialog((View)this.view, null, (int)0, (boolean)false);
        if (stringArray != null && !stringArray[0].equals(this.filename)) {
            this.saveFile();
            this.filename = stringArray[0];
            this.toolPanel.propertiesChanged();
            this.readFile();
        }
    }

    public void copyToBuffer() {
        jEdit.newFile((View)this.view);
        this.view.getEditPane().getTextArea().setText(this.textArea.getText());
    }

    private void readFile() {
        if (this.filename == null || this.filename.length() == 0) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.filename));
            StringBuffer stringBuffer = new StringBuffer(2048);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append('\n');
            }
            bufferedReader.close();
            this.textArea.setText(stringBuffer.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.log((int)9, (Object)QuickNotepad.class, (Object)("notepad file " + this.filename + " does not exist"));
        }
        catch (IOException iOException) {
            Log.log((int)9, (Object)QuickNotepad.class, (Object)("could not read notepad file " + this.filename));
        }
    }
}

