#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import location, time, pickle, math, webbrowser, sqlite3, urllib
import simplejson as json
import favorites
from gpscollector import Collector
from models import Stop, dict_as_stop


def get_fix():
	# Get GPS fix.
	print 'Getting GPS fix...'
	col = Collector()
	col.run()
	la, lo = col.data[len(col.data)-1][4:6]
	print 'Got fix: [%f,%f].' % (la, lo,)
	return la, lo

def get_stops(la, lo):
	# Retrieve nearest stops from web.
	print 'Getting nearest stops from the internet...'
	url = urllib.urlopen('http://rejs-dk.cannedtuna.org/json.php?la=%f&lo=%f' % (la, lo,))
	data = ''
	for line in url:
		data += line
	nearest = json.loads(data, object_hook=dict_as_stop)
	print 'Got %i stops.' % len(nearest)
	return nearest

def select_stop(nearest):
	# Show stop menu.
	print '\n\n***** Pick a stop: *****'
	for i in range(0, len(nearest)):
		stop = nearest[i]
		dist = str(round(stop.distance, 2)) + 'km'
		if stop.distance < 1:
			dist = str(int(stop.distance * 1000)) + 'm'
		print ('%i' % (i+1)).ljust(5), stop.name, '(' + dist + ')'

	# Get proper user input.
	choice = 'a'
	while not type(choice) is int:
		try:
			choice = int(raw_input('Stop no.: '))
		except ValueError:
			choice = 'a'
		if choice < 1 or choice > len(nearest):
			choice = 'a'
	return choice

def select_action(stop):
	# Show action menu.
	is_fav = favorites.is_favorite(stop)
	fav_action = 'Remove' if is_fav else 'Add'
	print '\n\n***** %s - What do you want to do now? *****' % stop.name
	print '1     Show time table for %s' % stop.name
	print '2     Plan a trip FROM %s' % stop.name
	print '3     Plan a trip TO %s' % stop.name
	print '4     %s %s as a favorite' % (fav_action, stop.name,)
	
	# Get proper user input.
	choice = 'a'
	while not type(choice) is int:
		try:
			choice = int(raw_input('Action no.: '))
		except ValueError:
			choice = 'a'
		if choice < 1 or choice > 4:
			choice = 'a'
	return choice

def open_browser(stop, action='time table'):
	url, msg = {
		'time table' : ('http://www.rejseplanen.dk/bin/stboard.exe/mn?ml=m&input=%i&boardType=dep&time=now&start=yes', 'Opening time tables for %s...'),
		'plan from' : ('http://www.rejseplanen.dk/bin/query.exe/mn?S=%i&start=yes', 'Opening travel planner from %s...'),
		'plan to' : ('http://www.rejseplanen.dk/bin/query.exe/mn?Z=%i&start=yes', 'Opening travel planner to %s...'),
	}[action]
	# Launch time table for stop in browser.
	print msg % stop.name
	webbrowser.open(url % stop.id)

# Run as a terminal script if run directly. Use gui.py if you want a nice GUI for all this.
if __name__ == '__main__':
	la, lo = get_fix()
	nearest = get_stops(la, lo)
	choice = select_stop(nearest)
	stop = nearest[choice - 1]
	choice = select_action(stop)
	if choice == 1:
		open_browser(stop, 'time table')
	elif choice == 2:
		open_browser(stop, 'plan from')
	elif choice == 3:
		open_browser(stop, 'plan to')
	elif choice == 4:
		if favorites.is_favorite(stop):
			favorites.remove(stop)
		else:
			favorites.add(stop)
	
