#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os, sqlite3
from models import Stop

def get_db_connection():
	print 'Opening new database connection...'
	# Make sure app data directory exists
	data_path = '/home/user/.rejs-dk'
	if not os.access(data_path, os.F_OK):
		os.mkdir(data_path)
	
	# Create SQLite database, connection and ensure proper structure.
	db_path = '%s/db.sqlite' % data_path
	conn = sqlite3.connect(db_path)
	cursor = conn.cursor()
	cursor.execute('''
		CREATE TABLE IF NOT EXISTS favorites
		(id, name)
	''')
	return conn, cursor

def add(stop):
	conn, c = get_db_connection()
	params = (stop.id,)
	# Check if this is already a favorite
	c.execute('SELECT COUNT(*) FROM favorites WHERE id=?', params)
	count = c.fetchone()[0]
	if count > 0:
		print 'Will not add favorite "%s" (ID#%i) to database. It is already a favorite.' % (stop.name, stop.id,)
	else:
		print 'Adding favorite "%s" (ID#%i) to database...' % (stop.name, stop.id,)
		params = (stop.id, stop.name)
		c.execute('INSERT INTO favorites VALUES (?, ?)', params)
		conn.commit()
	c.close()

def remove(stop):
	conn, c = get_db_connection()
	params = (stop.id,)
	print 'Deleting favorite ID#%i...' % stop.id
	c.execute('DELETE FROM favorites WHERE id=?', params)
	conn.commit()
	c.close()

def get():
	conn, c = get_db_connection()
	c.execute('SELECT * FROM favorites')
	stops = []
	for row in c:
		stop = Stop()
		stop.id = row[0]
		stop.name = row[1]
		stops.append(stop)
	return stops

def is_favorite(stop):
	# Determine whether a stop is a favorite or not
	fav = get()
	return len([s for s in fav if s.id == stop.id]) > 0
