#!/usr/bin/python
# -*- coding: UTF-8 -*-

import location, gobject


class Collector():
	data = []
	control = None
	device = None
	loop = None
	
	def on_error(control, error):
		print 'location error: %d... quitting' % error
		self.loop.quit()
		
	def on_changed(self, device):
		if not self.device:
				return
		if device.fix:
				if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
						#print 'lat = %f, long = %f' % device.fix[4:6]
						self.data.append(device.fix)
						print 'Fix #%i saved...' % len(self.data)
						# Wait for 5 fixes
						if len(self.data) > 2:
							self.control.stop()
	
	def start_location(self):
		self.control = location.GPSDControl.get_default()
		self.device = location.GPSDevice()
		self.control.set_properties(preferred_method=location.METHOD_USER_SELECTED, preferred_interval=location.INTERVAL_DEFAULT)
		self.control.connect("error-verbose", self.on_error)
		self.device.connect("changed", self.on_changed)
		self.control.connect("gpsd-stopped", self.on_stop)
		self.control.start()
		return False
		
	def on_stop(self, control):
			#print "quitting"
			self.loop.quit()

	def run(self):
		self.loop = gobject.MainLoop()
		gobject.idle_add(self.start_location)
		self.loop.run()

