﻿#!/bin/sh
# python2.5 /usr/lib/hildon-desktop/recaller.py

APP_TITLE = "Recaller"
APP_VERSION = "2.0"

import gobject
import gtk
import hildondesktop
import hildon
import os
from os import environ
import cairo
import osso
import string
import time 
import gconf

import dbus

import pygst
pygst.require("0.10")
import gst

from dbus.mainloop.glib import DBusGMainLoop
dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
dbus.mainloop.glib.threads_init()

APP_NAME = APP_TITLE.lower()
LOGO = '/opt/tomch.com/%s/%s_64.png' % (APP_NAME, APP_NAME)
GCONFPATH = "/apps/Maemo/tomch.com/%s" % APP_NAME
                                
#gobject.threads_init()
#gtk.gdk.threads_init()

class RecallerHomePlugin(hildondesktop.HomePluginItem):

  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)
    self.set_settings(True)
    self.connect("show-settings", self.show_options)

    #List of default values
    self.defaultSOURCE = "Phone"
    self.defaultFOLDER = "/home/user/MyDocs"
    self.defaultFORMAT = "aac"
    self.defaultAUTOREC = False
    self.defaultBANNERS = True

    self.SHOWBANNER = True
    
    self.isStopped = True 
    self.update_info()
    self.transparency = 0.0
    self.timer = None

    #Load the settings using GConf
    conf_client = gconf.client_get_default()
    conf_client.add_dir(GCONFPATH, gconf.CLIENT_PRELOAD_NONE)
           
    if False:  #Set to True if ever settings should be corrupt during development. Will reset gconf values to initial settings
      conf_client.set_string(GCONFPATH+"/audiosource", self.defaultSOURCE)
      conf_client.set_string(GCONFPATH+"/folder", self.defaultFOLDER)
      conf_client.set_string(GCONFPATH+"/format", self.defaultFORMAT)
      conf_client.set_bool(GCONFPATH+"/autorec", self.defaultAUTOREC)
      conf_client.set_bool(GCONFPATH+"/reminders", self.defaultBANNERS)
    #Or remove the settings through the command line (good for QA :-)
    #gconftool-2 --unset /apps/Maemo/tomch.com/recaller
    self.source=conf_client.get_string(GCONFPATH+"/audiosource")
    self.folder=conf_client.get_string(GCONFPATH+"/folder")
    self.fileformat=conf_client.get_string(GCONFPATH+"/format")
    self.autorec=conf_client.get_bool(GCONFPATH+"/autorec")
    self.reminders=conf_client.get_bool(GCONFPATH+"/reminders")
    print self.source,self.folder,self.fileformat,self.autorec,self.reminders
    if self.source == None:
      self.source=self.defaultSOURCE
    if self.folder == None:
      self.folder=self.defaultFOLDER
    if self.fileformat == None:
      self.fileformat = self.defaultFORMAT
    if self.autorec == None:
      self.autorec = self.defaultAUTOREC
    if self.reminders == None:
      self.reminders = self.defaultBANNERS
      
    self.isStopped = True 
    self.transparency = 0.0 

   
    #The usual way IF NOT a hildon-home widget. Will work when in an app
    #self.bus = dbus.SystemBus()
    #The suggestion from Kimmo Hämäläinen, doesn't help, works the same as plain "self.bus = dbus.SystemBus()" above
    #dbus_loop = DBusGMainLoop()
    #self.bus = dbus.SystemBus(mainloop=dbus_loop)
    
    #Another variant, refuses to connect (PUT EXACT MESSAGE HERE)
    self.bus = dbus.bus.BusConnection("unix:path=/var/run/dbus/system_bus_socket")
    #RuntimeError: To make asynchronous calls, receive signals or export objects, D-Bus connections must be attached to a main loop by passing mainloop=... to the constructor or calling dbus.set_default_main_loop(...)

    #---Incoming/outgoing callbacks---------------------------

    #[SIGNAL] com.nokia.csd.Call.UserConnection  /com/nokia/csd/call  :1.17
    #( true )           
    self.bus.add_signal_receiver(self.offHook,
                            dbus_interface=None,
                            signal_name="UserConnection",
                            bus_name="com.nokia.csd",
                            path="/com/nokia/csd/call",
                            )
    
    #[SIGNAL] com.nokia.csd.Call.Instance.Terminated  /com/nokia/csd/call/1  :1.17
    #()
    self.bus.add_signal_receiver(self.onHook,
                            dbus_interface=None,
                            signal_name="Terminated",
                            bus_name="com.nokia.csd",
                            path="/com/nokia/csd/call/1",
                            )
    
    #---Incoming callbacks------------------------------------
    
    #[SIGNAL] com.nokia.csd.Call.Coming  /com/nokia/csd/call  :1.17
    #( op'/com/nokia/csd/call/1', "0313520331" )
    self.bus.add_signal_receiver(self.callInfoFrom,
                            dbus_interface=None,
                            signal_name="Coming",
                            bus_name="com.nokia.csd",
                            path="/com/nokia/csd/call",
                            )

    #---Outgoing callbacks------------------------------------
    #[SIGNAL] com.nokia.csd.Call.Created  /com/nokia/csd/call  :1.17
    #( op'/com/nokia/csd/call/1', "+41313520331" )
    self.bus.add_signal_receiver(self.callInfoTo,
                            dbus_interface=None,
                            signal_name="Created",
                            bus_name="com.nokia.csd",
                            path="/com/nokia/csd/call",
                            )
                            
    root = self.bus.get_object('org.bluez', '/')
    manager = dbus.Interface(root, 'org.bluez.Manager')
    defaultAdapter = manager.DefaultAdapter()    
    obj = self.bus.get_object('org.bluez', defaultAdapter)
    self.BTadapter = dbus.Interface(obj, 'org.bluez.Adapter')
 
    
  def update_info(self, widget=None):

    self.osso_context = osso.Context("com.tomch."+APP_NAME, str(APP_VERSION), False)
    self.osso_rpc = osso.Rpc(self.osso_context)
   
    self.hbox = gtk.HBox()
    self.vbox = gtk.VBox()
    self.e_eventbox = gtk.EventBox()
    self.e_eventbox.set_size_request(64, 96)
    self.e_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
    self.e_eventbox.connect("button-release-event", self.on_button_clicked)
    self.hbox.pack_start(self.e_eventbox, True, True, 10)
    self.hbox.show_all()
    self.add(self.hbox)

  def do_expose_event(self, event):
    cr = self.window.cairo_create()
    cr.set_source_rgba(1.0, 1.0, 1.0, self.transparency) # Transparent

    # Draw the background
    cr.set_operator(cairo.OPERATOR_SOURCE)
    cr.paint()   
    # Paint icon for eventbox
    self.draw_e_off()
    # draw rounded rect
    width, height = self.allocation[2], self.allocation[3]
    
    x0 = 0
    y0 = 0
    radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */
    x1 = x0 + width
    y1 = y0 + height
    
    cr.move_to  (x0, y0 + radius)
    cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
    cr.line_to (x1 - radius, y0)
    cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
    cr.line_to (x1 , y1 - radius)
    cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
    cr.line_to (x0 + radius, y1)
    cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)
    cr.close_path ()

    cr.set_source_rgba (0.0, 0.0, 0.0, self.transparency)
    cr.fill_preserve ()
    return False

  def draw_e_off(self):
    cr_e = self.e_eventbox.window.cairo_create()
    cr_e.set_source_rgba(0.0, 0.0, 0.0, self.transparency) # Transparent
    cr_e.set_operator(cairo.OPERATOR_SOURCE)
    cr_e.paint()
    
    cr_e.set_operator(cairo.OPERATOR_OVER)
    image = cairo.ImageSurface.create_from_png("/opt/tomch.com/recaller/recaller_64.png")
    cr_e.set_source_surface(image, 0, 7)
    cr_e.paint()
    self.cr_e = cr_e

  def draw_e_on(self):
    cr_e = self.e_eventbox.window.cairo_create()
    cr_e.set_source_rgba(0.0, 0.0, 0.0, self.transparency) # Transparent
    cr_e.set_operator(cairo.OPERATOR_SOURCE)
    cr_e.paint()
    
    cr_e.set_operator(cairo.OPERATOR_OVER)
    image = cairo.ImageSurface.create_from_png("/opt/tomch.com/recaller/recaller_64_on.png")
    cr_e.set_source_surface(image, 0, 7)
    cr_e.paint()
      
  def do_realize(self):
    screen = self.get_screen()
    colormap = screen.get_rgba_colormap()
    self.set_colormap(colormap)
    hildondesktop.HomePluginItem.do_realize(self) 
   
  
  def on_button_clicked(self, widget, data=None):
      # do not listen if in middle of state change
      if not self.isStopped:
        success, state, pending = self.recorder.get_state(1)
        if not pending:
            if state == gst.STATE_PLAYING:
              self.stop()              
      else:
          self.caller = None
          self.start_PhoneRecording()
          self.isStopped = False
          
  def start_PhoneRecording(self):
      self.draw_e_on()
      self.startTime =  time.strftime("%Y%m%d_%H%M%S")
      self.startTimeToDisplay =  time.strftime("%H:%M:%S")
      if self.caller == None:
        self.fileName = os.path.join(self.folder,"Rec_%s.%s" % (self.startTime,self.fileformat.lower()))
      else:
        self.fileName = os.path.join(self.folder,"Rec_%s_%s.%s" % (self.caller,self.startTime,self.fileformat.lower()))     
      print "Launcher config is:"
      print self.get_launcher()
      self.recorder = gst.parse_launch ( self.get_launcher())
      bus = self.recorder.get_bus()
      # need to connect to sync message handler so we get the sink to be
      # embedded at the right time and not have a temporary new window
      bus.enable_sync_message_emission()
      bus.add_signal_watch()
      bus.connect("sync-message::element", self.on_sync_message)
      bus.connect("message", self.on_message)
      self.recorder.set_state(gst.STATE_PLAYING)
      if self.reminders:
        self.timer = gobject.timeout_add_seconds(30, self.recordingreminder_cb)      

      
  def stop(self):
      if not self.timer is None:     
        gobject.source_remove(self.timer)
      self.draw_e_off()
      self.recorder.send_event(gst.event_new_eos())
      if self.caller == None:
        finalName = os.path.join(self.folder,"Rec_%s-%s.%s" % (self.startTime, time.strftime("%H%M%S"),self.fileformat.lower()))
      else:
        finalName = os.path.join(self.folder,"Rec_%s_%s-%s.%s" % (self.caller,self.startTime,time.strftime("%H%M%S"),self.fileformat.lower()))       
      self.log(finalName) 
      os.rename(self.fileName, finalName)
      self.isStopped=True
      self.log("recaller: " + time.strftime("%H:%M:%S") + " - Recording stopped.")     

  def on_sync_message(self, bus, message):
      if message.structure is None:
          return
      if message.structure.get_name() == 'prepare-xwindow-id':
          # all this is needed to sync with the X server before giving the
          # x id to the sink
          gtk.gdk.threads_enter()
          gtk.gdk.display_get_default().sync()
          self.video_widget.set_sink(message.src)
          message.src.set_property("force-aspect-ratio", True)
          gtk.gdk.threads_leave()

  def on_message(self, bus, message):
      if message.type == gst.MESSAGE_ERROR:
        self.recorder.set_state(gst.STATE_NULL)
        err, debug = message.parse_error()
      if message.type == gst.MESSAGE_EOS:
        self.recorder.set_state(gst.STATE_NULL)

  def get_launcher(self):
      enc = self.get_encoder()
      if self.source == "Phone":
        self.launcher = "adder name=theAdder ! %s ! filesink location=%s. pulsesrc device=sink.hw0.monitor ! queue name=q1 ! theAdder. pulsesrc device=source.hw0 ! queue name=q2 ! theAdder."  % (enc,self.fileName)
      elif self.source == "Bluetooth":
        self.launcher = "adder name=theAdder ! %s ! filesink location=%s. pulsesrc device=sink.hw1.monitor ! queue name=q1 ! theAdder. pulsesrc device=source.hw1 ! queue name=q2 ! theAdder."  % (enc,self.fileName)
      elif self.source == "Dictaphone":
        self.launcher = "pulsesrc device=source.hw0 ! audioconvert ! queue ! %s ! filesink location=%s" % (enc,self.fileName)
      elif self.source == "System":
        self.launcher = "pulsesrc device=sink.hw0.monitor ! audioconvert ! queue ! %s ! filesink location=%s" % (enc,self.fileName)
      return self.launcher

  def get_encoder(self):
      if self.fileformat.lower() == "aac":
        self.encoder = "nokiaaacenc bitrate=128000 output-format=1"
      elif self.fileformat.lower() == "flac":
        self.encoder = "flacenc"
      elif self.fileformat.lower() == "wav":
        self.encoder = "wavenc"
      elif self.fileformat.lower() == "spx":
        self.encoder = "speexenc"
      return self.encoder
      
  def choose_folder(self,widget):
      selector=hildon.FileChooserDialog(self.w, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, hildon.FileSystemModel())
      selector.set_current_folder_uri(self.folder)
      rep=selector.run()
      selector.hide()
      self.folder=selector.get_filename()
      if rep==gtk.RESPONSE_OK:
          print "new selection=%s"%self.folder
          self.btnOpen.set_text("Save Folder", self.folder[0:16])
      else:
          print "no change"
      
  def format_changed(self, widget, data):
      self.fileformat = self.selectFormat.get_current_text().lower()
      print "Current format selection : %s" % (self.fileformat)     

  def source_changed(self, widget, data):
      self.source = self.selectAudio.get_current_text()
      print "Current source selection : %s" % (self.source)     

  def recordingreminder_cb(self):
    banner = hildon.hildon_banner_show_information(self, "", "recaller: " + "Recording since "+self.startTimeToDisplay)
    if self.reminders:
      return True
    else:
      return False

  def callInfoFrom(self,sender, message):
    if sender == "/com/nokia/csd/call/1":
      self.caller = str(message)
      self.log("Phone call from %s" % self.caller)

  def callInfoTo(self,sender, message):
    if sender == "/com/nokia/csd/call/1":
      self.caller = str(message)
      self.log("Phone call to %s" % self.caller)
      
  def offHook(self,connection):
    if connection == True:
      self.log("Picked up the call...")
      if self.autorec:
        self.currentsource = self.source  #Store original audio source
        if self.source == "Dictaphone" or self.source == "System":
          if self.hasHandsfreeConnected():
            self.source == "Bluetooth"
          else:
            self.source == "Phone"
        self.start_PhoneRecording()
        self.isStopped = False
        
  def onHook(self):
    #print sender, "said:", message
    #if sender == "/com/nokia/csd/call/1":
    self.log("Call terminated...")
    if not self.isStopped:
      #self.caller = None       #Bad idea, makes renaming fail...
      success, state, pending = self.recorder.get_state(1)
      if not pending:
          if state == gst.STATE_PLAYING:
            self.stop()
            self.source = self.currentsource  #Restore original audio source        
            
  def hasHandsfreeConnected(self):
    #If BT is disabled, we can already abort
    props = self.BTadapter.GetProperties()
    powered = props['Powered']
    if powered:
      print "BT is currently ON"
    else:
      print "BT is currently OFF"
      return False

    #Enumerate the devices
    remoteDevices = props['Devices']
    for dev in remoteDevices:
      devObj = self.bus.get_object('org.bluez', dev)
      device = dbus.Interface(devObj, 'org.bluez.Device')
      devProps = device.GetProperties()
      devName = devProps['Name']
      isConnected = devProps['Connected']
      #Check if a connected device offers a handsfree service
      if isConnected:
        print devName
        UUIDs = devProps['UUIDs']
        for uuid in UUIDs:
          id = uuid[4:8]
          if id == "111e":
            print " is a connected handsfree device !"
            return True
    return False  
      
  #Setup the main options/settings dialogue (the one accessible through the tool icon when in Hildon Desktop Edit mode)
  def show_options(self, widget):
      dialog = gtk.Dialog("%s Options" % APP_TITLE, None, gtk.DIALOG_DESTROY_WITH_PARENT)

      settings_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      settings_button.set_text("Settings", "Change how %s looks and works" % APP_TITLE)
      settings_button.set_alignment(0,0,0,0)
      settings_button.connect('clicked', self.show_settings)
              
      help_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      help_button.set_text("Help", "Get help on how to use %s" % APP_TITLE)
      help_button.set_alignment(0,0,0,0)
      help_button.connect('clicked', self.open_help) 
      
      about_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      about_button.set_text("About", "More about Author, Copyright and License")
      about_button.set_alignment(0,0,0,0)
      about_button.connect("clicked", self.show_about)

      donate_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      donate_button.set_text("Donate", "Like the software? Support the effort :-)")
      donate_button.set_alignment(0,0,0,0)
      donate_button.connect('clicked', self.open_donate)

      line1 = gtk.HBox()
      line2 = gtk.HBox()        
      line1.pack_start(settings_button, True, True, 0)
      line1.pack_start(help_button, True, True, 0)
      line2.pack_start(about_button, True, True, 0)
      line2.pack_start(donate_button, True, True, 0)
      dialog.vbox.pack_start(line1, True, True, 0)  
      dialog.vbox.pack_start(line2, True, True, 0)  
       
      dialog.show_all()
      dialog.run()
      dialog.destroy()
  
  #Link to a help page on the maemo wiki    
  def open_help(self, widget): 
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", ("http://wiki.maemo.org/"+APP_TITLE,))

  #Link to a donation page using PayPal    
  def open_donate(self, widget):
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", ("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=NJ4HVUZKB2CZY",))                
  
  #Setup the settings UI , store changed parameters  
  def show_settings(self, widget):
      dialog = gtk.Dialog("Settings", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      search_button = dialog.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
      
      main_vbox = gtk.VBox()
      
      ts = hildon.TouchSelector()
      ts.add(main_vbox)
      
      hBox1 = gtk.HBox()
      hBox2 = gtk.HBox()
      hBox3 = gtk.HBox()

      #Btn to select the default save folder
      self.btnOpen = hildon.Button(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,hildon.BUTTON_ARRANGEMENT_VERTICAL)
      #self.btnOpen.set_text("Save Folder", self.folder[0:16])
      self.btnOpen.set_text("Save Folder", self.folder)
      self.btnOpen.connect_after("clicked", self.choose_folder)

      #File format selector
      self.btnFileFormat = hildon.PickerButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      self.btnFileFormat.set_text("File Format", "The encoding format")
      self.selectFormat = hildon.TouchSelector(text=True)
      self.selectFormat.append_text("AAC")
      self.selectFormat.append_text("FLAC")
      self.selectFormat.append_text("WAV")
      #self.selectFormat.append_text("SPX")
      if self.fileformat.lower() == "aac":
        self.selectFormat.set_active(0,0)         
      elif self.fileformat.lower() == "flac":
        self.selectFormat.set_active(0,1)
      elif self.fileformat.lower() == "wav":
        self.selectFormat.set_active(0,2)
      elif self.fileformat.lower() == "spx":
        self.selectFormat.set_active(0,3)
      self.btnFileFormat.set_selector(self.selectFormat)
      self.btnFileFormat.show_all()

      #Audio source selector
      self.btnAudio = hildon.PickerButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      self.btnAudio.set_text("Audio Source", "-")
      self.selectAudio = hildon.TouchSelector(text=True)
      self.selectAudio.append_text("Dictaphone")
      self.selectAudio.append_text("System")
      self.selectAudio.append_text("Phone")
      self.selectAudio.append_text("Bluetooth")
      if self.source == "Dictaphone":
        self.selectAudio.set_active(0,0)         
      elif self.source == "System":
        self.selectAudio.set_active(0,1)
      elif self.source == "Phone":
        self.selectAudio.set_active(0,2)
      elif self.source == "Bluetooth":
        self.selectAudio.set_active(0,3)
      self.btnAudio.set_selector(self.selectAudio)
      self.btnAudio.show_all()  

      #Autorecord
      self.btnAutoRec = hildon.CheckButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
      self.btnAutoRec.set_label("Autorec")
      if self.autorec:
        self.btnAutoRec.set_active(True)

      self.btnReminders = hildon.CheckButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
      self.btnReminders.set_label("Show reminders")
      if self.reminders:
        self.btnReminders.set_active(True)
      
      hBox1.pack_start(self.btnOpen)     
      hBox2.pack_start(self.btnAudio)
      hBox2.pack_end(self.btnFileFormat)
      hBox3.pack_start(self.btnAutoRec)
      hBox3.pack_start(self.btnReminders)
      main_vbox.pack_start(hBox1)
      main_vbox.pack_start(hBox2)
      main_vbox.pack_start(hBox3)

      dialog.vbox.add(ts) 
      dialog.show_all()
      response = dialog.run()
             
      #Parse the updated settings        
      if response == gtk.RESPONSE_OK:
         self.source = self.selectAudio.get_current_text()
         self.fileformat = self.selectFormat.get_current_text().lower()   
         if (self.btnAutoRec.get_active()):
           self.autorec = True
         else:
           self.autorec = False
         if (self.btnReminders.get_active()):
           self.reminders = True
         else:
           self.reminders = False         
         #Store the updated settings
         conf_client = gconf.client_get_default()
         conf_client.add_dir(GCONFPATH, gconf.CLIENT_PRELOAD_NONE)
         try:
           conf_client.set_string(GCONFPATH+"/audiosource", self.source)
           conf_client.set_string(GCONFPATH+"/folder", self.folder)
           conf_client.set_string(GCONFPATH+"/format", self.fileformat)
           conf_client.set_bool(GCONFPATH+"/autorec", self.autorec)
           conf_client.set_bool(GCONFPATH+"/reminders", self.reminders)
         except Exception:
           self.log('Unable to save settings in GConf.')
      
      dialog.destroy()

  def choose_folder(self,widget):
      selector=hildon.FileChooserDialog(self, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, hildon.FileSystemModel())
      selector.set_current_folder_uri(self.folder)
      rep=selector.run()
      selector.hide()
      self.folder=selector.get_filename()
      if rep==gtk.RESPONSE_OK:
          print "new selection=%s"%self.folder
          self.btnOpen.set_text("Save Folder", self.folder[0:16])
      else:
          print "no change"
     
    
  #Show the about dialog    
  def show_about(self, widget):
      dialog = gtk.AboutDialog()
      dialog.set_title("About")
      dialog.set_name(APP_TITLE)
      dialog.set_version(APP_VERSION)
      dialog.set_copyright("Copyright 2010 Tom Waelti")
      dialog.set_authors(["Tom Waelti <twaelti@gmail.com>",""])
      dialog.set_logo(gtk.gdk.pixbuf_new_from_file(LOGO))
      dialog.set_comments("All logos and trademarks are property of their respective owners and are used for informational purposes only.")
      dialog.set_license("""This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public 
License along with this program.  If not, see
<http://www.gnu.org/licenses/>.""")
      dialog.set_wrap_license(True)
      dialog.show_all()
      dialog.run()
      dialog.destroy() 

  #Log and/or display banner     
  def log(self, message, *args, **kwargs):
    print time.strftime('%H:%M:%S'), '- '+APP_TITLE+':', message % args
    if self.SHOWBANNER:
        banner = hildon.hildon_banner_show_information(self, '', APP_TITLE+': ' + message%args)
        banner.set_timeout(2000)
    
      
hd_plugin_type = RecallerHomePlugin

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
