#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice
import time

class IsPrimeGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.step = 0
        # Universal Properties
        self.task = "The number is prime"
        
    def play(self):
        if self.step == 0:
            self.step = 80
            self.reactor.clearPlayArea()
            self.number = choice(range(2,100))
            self.reactor.drawMainText(str(self.number) + " is prime")
        else:
            self.step = self.step - 1
    
    def is_prime(self, n):
        '''check if integer n is a prime between 0 and 100'''
        if n in [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47,
                 53, 59, 61, 67, 71, 73, 79, 83, 89, 97]:
            return True
        return False
    
    #~ def calculate_is_prime(self, n):
        #~ '''check if integer n is a prime by calculation (unused)'''
        #~ if n == 2:
          #~ return True
        #~ if n % 2 == 0:
          #~ return False
        #~ max = n**0.5+1
        #~ i = 3
        #~ while i <= max:
            #~ if n % i == 0:
                #~ return False
            #~ i+=2
        #~ return True
    
    def evaluate(self, player):
        if self.is_prime(self.number):
            self.winMessage = "You're right!"
            self.loseMessage = str(self.number) + " is prime!"
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = str(self.number) + " is not prime!"
            if player == 1: return 2
            if player == 2: return 1
