#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice, random
import time

class AlphabetGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.step = 0
        #~ self.negative = False
        self.letters = ["A","B","C","D","E","F","G","H","I","J","K",
                        "L","M","N","O","P","Q","R","S","T","U","V","W",
                        "X","Y","Z"] # 26
        self.disordered = False
        # Universal Properties
        self.task = "These letters are in order of the alphabet"
    
    def play(self):
        if self.step == 0:
            self.step = 60
            self.reactor.clearPlayArea()
            cut1 = choice(range(3,8))
            cut2 = choice(range(8,13))
            cut3 = choice(range(13,18))
            cut4 = choice(range(18,23))
            letters = []
            letters.append(self.letters[choice(range(0,cut1))])
            letters.append(self.letters[choice(range(cut1,cut2))])
            letters.append(self.letters[choice(range(cut2,cut3))])
            letters.append(self.letters[choice(range(cut3,cut4))])
            letters.append(self.letters[choice(range(cut4,26))])
            if random() > 0.2:
                r = choice(xrange(4))
                temp = letters.pop(r)
                newLocs = range(0,4)
                newLocs.remove(r)
                letters.insert(choice(newLocs), temp)
                self.disordered = True
            else:
                self.disordered = False
            text = ""
            for i in letters:
                text = text + i + " "
            text = text.rstrip()
            self.reactor.drawMainText(text)
        else:
            self.step = self.step - 1
                    
    def evaluate(self, player):
        if not self.disordered:
            self.winMessage = "Correct!"
            self.loseMessage = "Too slow!"
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = "Wrong!"
            if player == 1: return 2
            if player == 2: return 1
