#ifndef GAMEWINDOW_H
#define GAMEWINDOW_H

#include <QWidget>
#include <QPainter>
#include <QTimer>
#include <QMouseEvent>
#include <QDebug>
#include <QCoreApplication>


class GameWindow : public QWidget
{
    Q_OBJECT
public:

    GameWindow( QWidget* aParent = 0 )
        :QWidget( aParent ),mColor(Qt::blue),mPoint(0),mGameCounter(60),mTimeCount(3)
    {
        mTimer = new QTimer( this);
        this->resize(800,480);
    }

public slots:

    void newGame()
    {
        mGameCounter = 60;
        mTimeCount = 3;
        mColor = Qt::blue;
        mPoint = 0;
        QObject::connect( mTimer,SIGNAL(timeout()),this,SLOT(startupTimer()));
        mTimer->start( 1000 );
    }

private slots:

    void paintEvent( QPaintEvent* /*aEvent*/ )
    {
        QPainter painter(this);

        if( mTimeCount < 0 ) {
           paintGame( &painter );
        } else {
            paintTime( &painter );
        }
    }

    void paintGame( QPainter* aPainter )
    {
        if ( mGameCounter < 0 ) {
            QString str("Your points are \n%1");
            str = str.arg( mPoint );
            paintText( aPainter, str, Qt::green, 80 );
            return;
        }

        //draw grid
        //draw horizontal lines
        for( int i= 0 ; i <= 5 ; ++i ) {
            aPainter->drawLine(QPoint(0,i*80),QPoint( 700,i*80) );
        }

        //draw vertical lines
        for( int i= 0 ; i <= 7 ; ++i ) {
            aPainter->drawLine(QPoint(i*100,0),QPoint( i*100,400) );
        }

        aPainter->drawText( 7*100 , 160, 100, 40 ,Qt::AlignHCenter ,"Score");
        aPainter->drawText( 7*100 , 200, 100, 40 ,Qt::AlignHCenter ,QString().setNum( mPoint));

        aPainter->drawText( 7*100 , 0, 100, 80 ,Qt::AlignCenter ,"Exit");
        aPainter->drawText( 7*100 , 80, 100, 80 ,Qt::AlignCenter ,"Menu");

        QBrush brush(Qt::SolidPattern);
        brush.setColor(mColor);
        aPainter->setBrush(brush);

        QPoint pos( mCurrentPosition.x() * 100, mCurrentPosition.y()* 80 );
        aPainter->drawRect( pos.x(),pos.y(), 100, 80 );
    }

    void paintText( QPainter* aPainter, const QString& aString,const QColor& aColor = Qt::black ,int aFontSize = 100 )
    {
        aPainter->setPen( aColor );

        QFont font = aPainter->font();
        font.setBold( true );
        font.setPixelSize( aFontSize );
        aPainter->setFont( font );
        aPainter->drawText( 0,0, 800, 480,Qt::AlignCenter, aString );
    }

    void paintTime( QPainter* aPainter )
    {        
        paintText( aPainter, QString().setNum( mTimeCount), Qt::red, 100 );
    }

    void gameTimer()
    {        
        mGameCounter --;
        if ( mGameCounter < 0 ) {
            QObject::disconnect( mTimer,SIGNAL(timeout()),this,SLOT(gameTimer()));
            mTimer->stop();
        } else {
            generateRandomPos();
            mColor = Qt::blue;
        }
        repaint();
    }

    void startupTimer()
    {
        mTimeCount --;
        if( mTimeCount < 0 ) {
            QObject::disconnect( mTimer,SIGNAL(timeout()),this,SLOT(startupTimer()));
            QObject::connect( mTimer,SIGNAL(timeout()),this,SLOT(gameTimer()));
            mTimer->start( 600 );
        }
        repaint();
    }

    void mousePressEvent(QMouseEvent *aEvent)
    {
        if( mGameCounter < 0 ) {
            emit showMenu();
            return;
        }

        int x = aEvent->pos().x() / 100;
        int y = aEvent->pos().y() / 80;
        QPoint mousePoint(x,y);

        if( mousePoint == QPoint( 7,0 )) {
            QCoreApplication::quit();
        }
        else if( mousePoint == QPoint( 7,1 )) {
             emit showMenu();
             return;
        }

        //qDebug() << aEvent->pos() << "::"<<QPoint(x,y) << "::" << mCurrentPosition;
        if( mousePoint == mCurrentPosition ) {
            mPoint ++;
            mColor = Qt::green;
        } else {
            //point --
            mColor = Qt::red;            
        }
        repaint();
    }

private:

    void generateRandomPos()
    {
        int x = qrand() % 7;
        int y = qrand() % 5;
        mCurrentPosition = QPoint(x,y);
    }

signals:

    void showMenu();

private:

    QPoint mCurrentPosition;
    QTimer* mTimer;
    QColor mColor;
    int mPoint;
    int mGameCounter;
    int mTimeCount;    
};

#endif // GAMEWINDOW_H
