/*
   rdesktop: A Remote Desktop Protocol client.
   Common data types
   Copyright (C) Matthew Chapman 1999-2007

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <string.h>
#ifndef _WIN32
#include <unistd.h>		/* select read write close */
#include <sys/ioctl.h>
#include <sys/socket.h>		/* socket connect setsockopt */
#include <sys/time.h>		/* timeval */
#include <netdb.h>		/* gethostbyname */
#include <netinet/in.h>		/* sockaddr_in */
#include <netinet/tcp.h>	/* TCP_NODELAY */
#include <arpa/inet.h>		/* inet_addr */
#include <fcntl.h>
#include <errno.h>		/* errno */
#endif
#include <net/if.h>

#include "rdesktop.h"
#include "appdata.h"

/********** private **********/

#define DBG

#ifdef DBG
#define DEBUG_FG(fmt, ...) \
do { \
	printf("%s: " fmt "\n", __PRETTY_FUNCTION__, ##__VA_ARGS__); \
	fflush(stdout); \
} while (0)
#else
#define DEBUG_FG(...)
#endif

#ifdef _WIN32
#define socklen_t int
#define TCP_CLOSE(_sck) closesocket(_sck)
#define TCP_STRERROR "tcp error"
#define TCP_BLOCKS (WSAGetLastError() == WSAEWOULDBLOCK)
#else
#define TCP_CLOSE(_sck) close(_sck)
#define TCP_STRERROR strerror(errno)
#define TCP_BLOCKS ((errno == EWOULDBLOCK)||(errno == EAGAIN))
#endif

/********** public **********/

extern int g_tcp_port_rdp;

int connect_server(char *a_server, int *a_sock)
{
	// Fix Me : Bad hack. To disconnect rdesktop if network connection is going down.
	// Checking if vpn is working fine.
	int sock;
	struct hostent *nslookup;
	struct sockaddr_in servaddr;
	char *c;

	c = strrchr(a_server, ':');
	if (c) {
		*c = '\0';
	}

	if ((nslookup = gethostbyname(a_server)) != NULL)
	{
		memcpy(&servaddr.sin_addr, nslookup->h_addr, sizeof(servaddr.sin_addr));
	}
	else if ((servaddr.sin_addr.s_addr = inet_addr(a_server)) == INADDR_NONE)
	{
		error("%s: unable to resolve host\n", a_server);
		return 0;
	}
	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		error("socket: %s\n", TCP_STRERROR);
		return 0;
	}
	servaddr.sin_family = AF_INET;
	servaddr.sin_port = htons(g_tcp_port_rdp);
	DEBUG_FG("server = '%s', port = %d", a_server, g_tcp_port_rdp);

	// connect with timeout
	 long arg;
	 fd_set myset;
	 struct timeval tv;
	 int valopt;
	 socklen_t lon;
	 if( (arg = fcntl(sock, F_GETFL, NULL)) < 0) {
		fprintf(stderr, "Error fcntl(..., F_GETFL) (%s)\n", strerror(errno));
		close(sock);
		return 0;
	 }
	 arg |= O_NONBLOCK;
	 if( fcntl(sock, F_SETFL, arg) < 0) {
		 fprintf(stderr, "Error fcntl(..., F_SETFL) (%s)\n", strerror(errno));
		close(sock);
		return 0;
	 }
	 int res = connect(sock, (struct sockaddr *)&servaddr, sizeof(struct sockaddr));
	 if (res < 0) {
		 if (errno == EINPROGRESS) {
			 fprintf(stderr, "EINPROGRESS in connect() - selecting\n");
			 do {
				 tv.tv_sec = 5;
				 tv.tv_usec = 0;

				 FD_ZERO(&myset);
				 FD_SET(sock, &myset);
				 res = select(sock+1, NULL, &myset, NULL, &tv);
				 if (res < 0 && errno != EINTR) {
					 fprintf(stderr, "Error connecting %d - %s\n", errno, strerror(errno));
					 TCP_CLOSE(sock);
					 return 0;
				 }
				 else if (res > 0) {
					 lon = sizeof(int);
					 if (getsockopt(sock, SOL_SOCKET, SO_ERROR, (void*)(&valopt), &lon) < 0) {
						 fprintf(stderr, "Error in getsockopt() %d - %s\n", errno, strerror(errno));
						 TCP_CLOSE(sock);
						 return 0;
					 }
					 if (valopt) {
						 fprintf(stderr, "Error in delayed connection() %d - %s\n", valopt, strerror(valopt));
						 TCP_CLOSE(sock);
						 return 0;
					 }
					 break;
				 }
				 else {

					 fprintf(stderr, "Timeout in select() - Cancelling!\n");
					 TCP_CLOSE(sock);
					 return 0;
				 }
			 } while (1);

		 }
		 else {
			 fprintf(stderr, "Error connecting %d - %s\n", errno, strerror(errno));
			 TCP_CLOSE(sock);
			 return 0;
		 }
	 }
	 if( (arg = fcntl(sock, F_GETFL, NULL)) < 0) {
		 fprintf(stderr, "Error fcntl(..., F_GETFL) (%s)\n", strerror(errno));
		TCP_CLOSE(sock);
		return 0;
	 }
	 arg &= (~O_NONBLOCK);
	 if( fcntl(sock, F_SETFL, arg) < 0) {
		 fprintf(stderr, "Error fcntl(..., F_SETFL) (%s)\n", strerror(errno));
		TCP_CLOSE(sock);
		return 0;
	 }
	 fprintf(stderr, "done complete");
	if (a_sock) {
		*a_sock = sock;
	}
	return 1;
}

// /* === This is here to be used when we rework the code in this file. === */
//static gboolean do_connect(struct sockaddr_in *servaddr, int *g_sock)
//{
//	// Fix Me : Bad hack. To disconnect rdesktop if network connection is going down.
//	// Checking if vpn is working fine.
//	long arg;
//	fd_set myset;
//	struct timeval tv;
//	int valopt, res;
//	socklen_t lon;
//
//	if ((*g_sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
//	{
//		error("socket: %s\n", TCP_STRERROR);
//		return FALSE;
//	}
//
//	// connect with timeout
//	if( (arg = fcntl(*g_sock, F_GETFL, NULL)) < 0) {
//		fprintf(stderr, "Error fcntl(..., F_GETFL) (%s)\n", strerror(errno));
//		close(*g_sock);
//		return FALSE;
//	}
//	arg |= O_NONBLOCK;
//	if( fcntl(*g_sock, F_SETFL, arg) < 0) {
//		fprintf(stderr, "Error fcntl(..., F_SETFL) (%s)\n", strerror(errno));
//		close(*g_sock);
//		return FALSE;
//	}
//	res = connect(*g_sock, (struct sockaddr *)servaddr, sizeof(struct sockaddr));
//	if (res < 0) {
//		if (errno == EINPROGRESS) {
//			fprintf(stderr, "EINPROGRESS in connect() - selecting\n");
//			do {
//				tv.tv_sec = 5;
//				tv.tv_usec = 0;
//
//				FD_ZERO(&myset);
//				FD_SET(*g_sock, &myset);
//				res = select(*g_sock+1, NULL, &myset, NULL, &tv);
//				if (res < 0 && errno != EINTR) {
//					fprintf(stderr, "Error connecting %d - %s\n", errno, strerror(errno));
//					TCP_CLOSE(*g_sock);
//					return FALSE;
//				} else if (res > 0) {
//					lon = sizeof(int);
//					if (getsockopt(*g_sock, SOL_SOCKET, SO_ERROR, (void*)(&valopt), &lon) < 0) {
//						fprintf(stderr, "Error in getsockopt() %d - %s\n", errno, strerror(errno));
//						TCP_CLOSE(*g_sock);
//						return FALSE;
//					}
//					if (valopt) {
//						fprintf(stderr, "Error in delayed connection() %d - %s\n", valopt, strerror(valopt));
//						TCP_CLOSE(*g_sock);
//						return FALSE;
//					}
//					break;
//				} else {
//					fprintf(stderr, "Timeout in select() - Cancelling!\n");
//					TCP_CLOSE(*g_sock);
//					return FALSE;
//				}
//			} while (1);
//		} else {
//			fprintf(stderr, "Error connecting %d - %s\n", errno, strerror(errno));
//			TCP_CLOSE(*g_sock);
//			return FALSE;
//		}
//	}
//	if ( (arg = fcntl(*g_sock, F_GETFL, NULL)) < 0) {
//		fprintf(stderr, "Error fcntl(..., F_GETFL) (%s)\n", strerror(errno));
//		TCP_CLOSE(*g_sock);
//		return FALSE;
//	}
//	arg &= (~O_NONBLOCK);
//	if ( fcntl(*g_sock, F_SETFL, arg) < 0) {
//		fprintf(stderr, "Error fcntl(..., F_SETFL) (%s)\n", strerror(errno));
//		TCP_CLOSE(*g_sock);
//		return FALSE;
//	}
//	fprintf(stderr, "done complete");
//	return TRUE;
//}
//
///**
// * Splits the hostname to address/name and port.
// * The hostanme must be in the following format:
// *
// *	address
// *	[address]
// * 	address:port
// * 	[address]:port
// *
// * @param	addr	*addr is allocated and the address/name
// * 			part is copied into it.
// * @param	port	*port is set to the integer representation
// * 			of the port part. If port part is missing
// * 			then *port is set to -1.
// * @return	0 = success
// * @return	< 0 = error
// *
// * @note	The caller must free() *addr!
// */
//int split_hostname(char *hostname, char **addr, int *port)
//{
//	int ret = 0, r, restore = 0;
//	char *c, *tmp = NULL;
//
//	/* Get the port number. */
//	*port = -1;
//	c = strchr(hostname, ']');
//	if (c) {
//		++c;
//	} else {
//		c = hostname;
//	}
//	c = strchr(c, ':');
//	if (c && c != hostname && c[1] != '\0') {
//		r = strtoul(c + 1, &tmp, 10);
//		if (tmp != NULL) {
//			ret = -2;
//			goto e;
//		}
//		*port = r;
//	}
//
//	/* Get addr/name. */
//	if (hostname[0] == '[') {
//		/* ipv6 address */
//		c = strchr(hostname, ']');
//		if (!c) {
//			ret = -2;
//			goto e;
//		}
//		++hostname;
//		r = (int)(']');
//	} else {
//		/* ipv4 address */
//		c = strchr(hostname, ':');
//		if (c) {
//			r = (int)(':');
//		} else {
//			c = hostname + strlen(hostname);
//			r = 0;
//		}
//	}
//	*c = '\0';
//	restore = 1;
//	*addr = (char *)malloc(c - hostname + 1);
//	if (!*addr) {
//		ret = -2;
//		goto e;
//	}
//	strncpy(*addr, hostname, c - hostname + 1);
//
//e:	if (restore) {
//		*c = r;
//	}
//	return ret;
//}
//
//gboolean connect_server(char *server_addr, int port, int *sock)
//{
//	gboolean ret = FALSE;
//	int r;
//	struct addrinfo hint, *res = NULL, *rp;
//
//	if (port == -1) {
//		port = TCP_PORT_RDP;
//	}
//
//	bzero(&hint, sizeof(struct addrinfo));
//	hint.ai_socktype = SOCK_STREAM;
//
//	getaddrinfo(server_addr, NULL, &hint, &res);
//
//	for (rp = res; rp; rp = rp->ai_next) {
//		/* Try all the addresses. */
//		if (rp->ai_family == AF_INET) {
//			((sockaddr_in *)(rp->ai_addr))->sin_port = htons(port);
//		} else {
//			((sockaddr_in6 *)(rp->ai_addr))->sin6_port = htons(port);
//		}
//		ret = do_connect(rp->ai_addr, sock);
//		if (ret == TRUE) {
//			break;
//		}
//	}
//
//e:	if (res) {
//		freeaddrinfo(res);
//	}
//	return ret;
//}

