/*
 * This file is part of rdesktop
 *
 * Copyright (C) 2005 Incarnis Limited
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef RDESKTOP_APPDATA_H
#define RDESKTOP_APPDATA_H

#include <libosso.h>
#include <gconf/gconf-client.h>

#include <stdio.h>
#ifndef _WIN32
#include <unistd.h>		/* select read write close */
#include <sys/ioctl.h>
#include <sys/socket.h>		/* socket connect setsockopt */
#include <sys/time.h>		/* timeval */
#include <netdb.h>		/* gethostbyname */
#include <netinet/in.h>		/* sockaddr_in */
#include <netinet/tcp.h>	/* TCP_NODELAY */
#include <arpa/inet.h>		/* inet_addr */
#include <fcntl.h>
#include <errno.h>		/* errno */
#endif
#include <net/if.h>

#include <hildon/hildon-program.h>
#ifdef _WIN32
#define socklen_t int
#define TCP_CLOSE(_sck) closesocket(_sck)
#define TCP_STRERROR "tcp error"
#define TCP_BLOCKS (WSAGetLastError() == WSAEWOULDBLOCK)
#else
#define TCP_CLOSE(_sck) close(_sck)
#define TCP_STRERROR strerror(errno)
#define TCP_BLOCKS ((errno == EWOULDBLOCK)||(errno == EAGAIN))
#endif
typedef struct _AppData AppData;

struct _AppData
{
    HildonProgram *app; /* handle to application */
    HildonWindow *main_view; /* handle to app's view */
    osso_context_t *osso; /* handle to osso */
    GConfClient* gconf;
};
gboolean connect_server(char* server,int*);

#endif
