#!/usr/bin/python

import urllib
import sys
import os
from xml.dom import minidom
from Results import Ui_ResultsWindow
from Search import Ui_SearchWindow
from PyQt4.QtCore import *
from PyQt4.QtGui import *

RADIO_TIME_SEARCH_URL = 'http://opml.radiotime.com/Search.ashx?formats=wma,mp3,aac,real,ogg,qt&partnerId=mbn0p_mK&serial=%s&query=%s'
RADIO_TIME_PRESETS_URL = 'http://opml.radiotime.com/Browse.ashx?formats=wma,mp3,aac,real,ogg,qt&c=presets&partnerId=mbn0p_mK&serial=%s'
RADIO_TIME_PRESET_ACTION_URL = 'http://opml.radiotime.com/Preset.ashx?c=%s&%s'
RADIO_TIME_REPORT_URL = 'http://opml.radiotime.com/Report.ashx?c=wizard&%s'

def getMacAddress():
    mac = '00:00:00:00:00:00'
    if os.path.isfile('/usr/bin/sysinfo-tool'):
        import commands
        mac = commands.getoutput('sysinfo-tool -g /certs/npc/esn/wlan_id')
    elif sys.platform == 'win32':
        for line in os.popen("ipconfig /all"):
            if line.lstrip().startswith('Physical Address'):
               mac = line.split(':')[1].strip().replace('-',':')
               break
    elif sys.platform == 'darwin':
        for line in os.popen("ifconfig"):
            if line.find('ether') > -1:
                mac = line.split()[1]
                break
    else:
         for line in os.popen("/sbin/ifconfig"):
             if line.find('Ether') > -1:
                mac = line.split()[4]
                break
    return mac

def populate_results(url, index, results, resultsWindow, append):
    try:
        resultsWindow.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
        app.processEvents()
    except:
        pass
    del results[:]
    resultsWindow.listWidgetResults.clear()
    safeurl = urllib.quote(url, safe="%/:=&?~#+!$,;'@()*[]")
    if append:
        resultsWindow.history.append({
                    'url':safeurl,
                    'index':0})
    if len(resultsWindow.history) > 1:
        resultsWindow.pushButtonBack.setEnabled(True)
    else:
        resultsWindow.pushButtonBack.setEnabled(False)
    #print safeurl
    dom = minidom.parse(urllib.urlopen(safeurl))
    for node in dom.getElementsByTagName('outline'):
        results.append({
            'text' : node.getAttribute('text'),
            'URL'  : node.getAttribute('URL'),
            'type' : node.getAttribute('type'),
            'key'  : node.getAttribute('key'),
            'item' : node.getAttribute('item')
        })
    i = 0
    while i < len(results):
        resultsWindow.listWidgetResults.addItem(results[i].get('text'))
        if results[i].get('key') != '' and results[i].get('URL') == '':
            item = resultsWindow.listWidgetResults.item(i)
            font = item.font()
            font.setBold(True)
            item.setFont(font)
        elif results[i].get('type') == 'link':
            resultsWindow.listWidgetResults.item(i).setForeground(Qt.cyan)
        i = i + 1
    resultsWindow.listWidgetResults.setCurrentRow(index)
    resultsWindow.index = index
    resultsWindow.listWidgetResults.setFocus()
    resultsWindow.updatePushButtons(index)
    try:
        resultsWindow.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)
    except:
        pass

class SearchWindow(QMainWindow, Ui_SearchWindow):

    def __init__(self, parent=None):
        super(SearchWindow, self).__init__(parent)
        self.setupUi(self)
        self.resultsWindow = ResultsWindow(self)
        if os.path.isfile('/opt/RadioTimeToGo/radiotime_logo_400.png'):
            pixmap = QPixmap('/opt/RadioTimeToGo/radiotime_logo_400.png')
        elif os.path.isfile('/usr/bin/RadioTimeToGo/radiotime_logo_400.png'):
            pixmap = QPixmap('/usr/bin/RadioTimeToGo/radiotime_logo_400.png')
        else:
            pixmap = QPixmap('radiotime_logo_400.png')
        self.results = []
        self.textLabelLogo.setPixmap(pixmap)
        self.lineEditSearch.setFocus()

    def doSearch(self, url, buttonText, presetAction, windowTitle):
        try:
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
            app.processEvents()
        except:
            pass
        self.resultsWindow.history = []
        populate_results(url, 0, self.results, self.resultsWindow, True)
        if len(self.results) == 0:
            self.results.append({ 'text' : 'Nothing found' })
        self.resultsWindow.pushButtonAdd.setText(buttonText)
        self.resultsWindow.presetAction = presetAction
        self.resultsWindow.setWindowTitle("RadioTimeToGo-" + windowTitle)
        try:
            self.resultsWindow.setAttribute(Qt.WA_Maemo5StackedWindow)
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)
        except:
               pass
        self.resultsWindow.show()

    def on_pushButtonSearch_released(self):
        url = RADIO_TIME_SEARCH_URL % (self.serial, self.lineEditSearch.text())
        self.doSearch(url, 'Add', 'add', 'Results')

    def on_lineEditSearch_returnPressed(self):
        url = RADIO_TIME_SEARCH_URL % (self.serial, self.lineEditSearch.text())
        self.doSearch(url, 'Add', 'add', 'Results')

    def on_pushButtonPresets_released(self):
        if self.serial == '00:00:00:00:00:00':
            QMessageBox.information(self, self.tr("Preset Status"), self.tr("Unique ID not found. Presets unavailable."))
            self.pushButtonPresets.setEnabled(False)
        else:
            url = RADIO_TIME_PRESETS_URL % (self.serial)
            self.doSearch(url, 'Remove', 'remove', 'Presets')

    @pyqtSlot() # need this to only allow one call per menu selection
    def on_actionAbout_triggered(self):
        QMessageBox.information(self, self.tr("About"), self.tr("RadioTimeToGo Version 0.0.6-1"))

class ResultsWindow(QMainWindow, Ui_ResultsWindow):

    def __init__(self, parent=None):
        super(ResultsWindow, self).__init__(parent)
        self.setupUi(self)
        self.index = -1
        self.history = []
        self.pushButtonBack.setEnabled(False)

    def updatePushButtons(self, row):
        if ui.results[row].get('type') == "audio":
            self.pushButtonListen.setEnabled(True)
            self.pushButtonListen.setText('Listen')
            self.actionReport.setEnabled(True)
            if ui.results[row].get('item') == "station" or ui.results[row].get('item') == "show":
                self.pushButtonAdd.setEnabled(True)
            else:
                self.pushButtonAdd.setEnabled(False)
        elif ui.results[row].get('type') == "link":
            self.pushButtonListen.setText('Browse')
            self.pushButtonListen.setEnabled(True)
            self.pushButtonAdd.setEnabled(False)
            self.actionReport.setEnabled(True)
        else:
            self.pushButtonListen.setEnabled(False)
            self.pushButtonAdd.setEnabled(False)
            self.actionReport.setEnabled(True)

    def on_listWidgetResults_itemClicked(self, item):
        # change button text to reflect the action based on selection
        self.index = self.listWidgetResults.row(item)
        self.updatePushButtons(self.index)

    def on_pushButtonListen_released(self):
        if self.index >= 0:
            url = ui.results[self.index].get('URL')
            if ui.results[self.index].get('type') == "link":
                self.history[len(self.history)-1]['index'] = self.index
                populate_results(url, 0, ui.results, self, True)
            else:
                if os.path.isfile('/opt/kmplayer/bin/kmplayer') or os.path.isfile('/usr/bin/kmplayer'):
                    os.system('dbus-send --print-reply --dest=com.nokia.kmplayer /com/nokia/kmplayer com.nokia.kmplayer.mime_open string:%s' % url)
                    #playlist = urllib.urlopen(url)
                    #stream = playlist.readline()
                    #os.system('dbus-send --print-reply --dest=com.nokia.mediaplayer /com/nokia/mediaplayer com.nokia.mediaplayer.mime_open string:%s' % stream)
                elif os.path.isfile('/Applications/VLC.app/Contents/MacOS/VLC'):
                    print url
                    playlist = urllib.urlopen(url)
                    for line in playlist.readlines():
                        print line
                    #os.system('/Applications/VLC.app/Contents/MacOS/VLC %s &' % url)
                elif os.path.isfile('c:/program files/VideoLAN/vlc/vlc.exe'):
                    playlist = urllib.urlopen(url)
                    for line in playlist.readlines():
                        print line
                    #os.system('"c:/program files/VideoLAN/vlc/vlc.exe" %s' % url)

    def on_pushButtonAdd_released(self):
        if self.index >= 0:
           if ui.results[self.index].get('type') == "audio":
              split = ui.results[self.index]['URL'].split('?')
              if (len(split) > 1):
                try:
                    self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, True)
                    app.processEvents()
                except:
                    pass
                url = RADIO_TIME_PRESET_ACTION_URL % (self.presetAction, split[1])
                #print url
                dom = minidom.parse(urllib.urlopen(url))
                result = dom.getElementsByTagName('status')[0].firstChild.data
                try:
                    self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)
                except:
                    pass
                if self.presetAction == 'add' and result == '200':
                    QMessageBox.information(self, self.tr("Preset Status"), self.tr("Preset Added Successfully"))
                elif self.presetAction == 'add' and result != '200':
                    QMessageBox.information(self, self.tr("Preset Status"), self.tr("Failed to Add Preset"))
                elif self.presetAction == 'remove' and result == '200':
                    self.history = []
                    url = RADIO_TIME_PRESETS_URL % (ui.serial)
                    #print url
                    populate_results(url, 0, ui.results, self, True)
                elif self.presetAction == 'remove' and result != '200':
                    QMessageBox.information(self, self.tr("Preset Status"), self.tr("Failed to Remove Preset"))

    def on_pushButtonBack_released(self):
        self.history.pop()
        index = self.history[len(self.history)-1].get('index')
        populate_results(self.history[len(self.history)-1].get('url'),
                         index, ui.results, self, False)

    @pyqtSlot() # need this to only allow one call per menu selection
    def on_actionReport_triggered(self):
        if self.index >= 0:
           if ui.results[self.index].get('type') == "audio":
              split = ui.results[self.index]['URL'].split('?')
              if (len(split) > 1):
                url = RADIO_TIME_REPORT_URL % (split[1])
                #print url
                self.history[len(self.history)-1]['index'] = self.index
                populate_results(url, 0, ui.results, self, True)

    @pyqtSlot() # need this to only allow one call per menu selection
    def on_actionClaim_triggered(self):
        url = "https://opml.radiotime.com/Account.ashx?c=claim&partnerId=mbn0p_mK&serial=%s" % ui.serial
        populate_results(url, 0, ui.results, self, True)

if __name__ == "__main__":
    serial = getMacAddress()
    app = QApplication(sys.argv)
    ui = SearchWindow()
    ui.serial = serial
    try:
        ui.setAttribute(Qt.WA_Maemo5StackedWindow)
    except:
           pass
    ui.show()
    sys.exit(app.exec_())
